/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dataexchange.model.ListOfSchemaChangeDetailsCopier;
import software.amazon.awssdk.services.dataexchange.model.SchemaChangeDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SchemaChangeRequestDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SchemaChangeRequestDetails> {
    private static final SdkField<List<SchemaChangeDetails>> CHANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Changes").getter(SchemaChangeRequestDetails.getter(SchemaChangeRequestDetails::changes)).setter(SchemaChangeRequestDetails.setter(Builder::changes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Changes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SchemaChangeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> SCHEMA_CHANGE_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SchemaChangeAt").getter(SchemaChangeRequestDetails.getter(SchemaChangeRequestDetails::schemaChangeAt)).setter(SchemaChangeRequestDetails.setter(Builder::schemaChangeAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaChangeAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGES_FIELD, SCHEMA_CHANGE_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SchemaChangeRequestDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<SchemaChangeDetails> changes;
    private final Instant schemaChangeAt;

    private SchemaChangeRequestDetails(BuilderImpl builder) {
        this.changes = builder.changes;
        this.schemaChangeAt = builder.schemaChangeAt;
    }

    public final boolean hasChanges() {
        return this.changes != null && !(this.changes instanceof SdkAutoConstructList);
    }

    public final List<SchemaChangeDetails> changes() {
        return this.changes;
    }

    public final Instant schemaChangeAt() {
        return this.schemaChangeAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChanges() ? this.changes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaChangeAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaChangeRequestDetails)) {
            return false;
        }
        SchemaChangeRequestDetails other = (SchemaChangeRequestDetails)obj;
        return this.hasChanges() == other.hasChanges() && Objects.equals(this.changes(), other.changes()) && Objects.equals(this.schemaChangeAt(), other.schemaChangeAt());
    }

    public final String toString() {
        return ToString.builder((String)"SchemaChangeRequestDetails").add("Changes", this.hasChanges() ? this.changes() : null).add("SchemaChangeAt", (Object)this.schemaChangeAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Changes": {
                return Optional.ofNullable(clazz.cast(this.changes()));
            }
            case "SchemaChangeAt": {
                return Optional.ofNullable(clazz.cast(this.schemaChangeAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Changes", CHANGES_FIELD);
        map.put("SchemaChangeAt", SCHEMA_CHANGE_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SchemaChangeRequestDetails, T> g) {
        return obj -> g.apply((SchemaChangeRequestDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<SchemaChangeDetails> changes = DefaultSdkAutoConstructList.getInstance();
        private Instant schemaChangeAt;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaChangeRequestDetails model) {
            this.changes(model.changes);
            this.schemaChangeAt(model.schemaChangeAt);
        }

        public final List<SchemaChangeDetails.Builder> getChanges() {
            List<SchemaChangeDetails.Builder> result = ListOfSchemaChangeDetailsCopier.copyToBuilder(this.changes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChanges(Collection<SchemaChangeDetails.BuilderImpl> changes) {
            this.changes = ListOfSchemaChangeDetailsCopier.copyFromBuilder(changes);
        }

        @Override
        public final Builder changes(Collection<SchemaChangeDetails> changes) {
            this.changes = ListOfSchemaChangeDetailsCopier.copy(changes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changes(SchemaChangeDetails ... changes) {
            this.changes(Arrays.asList(changes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changes(Consumer<SchemaChangeDetails.Builder> ... changes) {
            this.changes(Stream.of(changes).map(c -> (SchemaChangeDetails)((SchemaChangeDetails.Builder)SchemaChangeDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getSchemaChangeAt() {
            return this.schemaChangeAt;
        }

        public final void setSchemaChangeAt(Instant schemaChangeAt) {
            this.schemaChangeAt = schemaChangeAt;
        }

        @Override
        public final Builder schemaChangeAt(Instant schemaChangeAt) {
            this.schemaChangeAt = schemaChangeAt;
            return this;
        }

        public SchemaChangeRequestDetails build() {
            return new SchemaChangeRequestDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SchemaChangeRequestDetails> {
        public Builder changes(Collection<SchemaChangeDetails> var1);

        public Builder changes(SchemaChangeDetails ... var1);

        public Builder changes(Consumer<SchemaChangeDetails.Builder> ... var1);

        public Builder schemaChangeAt(Instant var1);
    }
}

