/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OriginDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OriginDetails> {
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductId").getter(OriginDetails.getter(OriginDetails::productId)).setter(OriginDetails.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()}).build();
    private static final SdkField<String> DATA_GRANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataGrantId").getter(OriginDetails.getter(OriginDetails::dataGrantId)).setter(OriginDetails.setter(Builder::dataGrantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataGrantId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_ID_FIELD, DATA_GRANT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String productId;
    private final String dataGrantId;

    private OriginDetails(BuilderImpl builder) {
        this.productId = builder.productId;
        this.dataGrantId = builder.dataGrantId;
    }

    public final String productId() {
        return this.productId;
    }

    public final String dataGrantId() {
        return this.dataGrantId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataGrantId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginDetails)) {
            return false;
        }
        OriginDetails other = (OriginDetails)obj;
        return Objects.equals(this.productId(), other.productId()) && Objects.equals(this.dataGrantId(), other.dataGrantId());
    }

    public final String toString() {
        return ToString.builder((String)"OriginDetails").add("ProductId", (Object)this.productId()).add("DataGrantId", (Object)this.dataGrantId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "DataGrantId": {
                return Optional.ofNullable(clazz.cast(this.dataGrantId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OriginDetails, T> g) {
        return obj -> g.apply((OriginDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String productId;
        private String dataGrantId;

        private BuilderImpl() {
        }

        private BuilderImpl(OriginDetails model) {
            this.productId(model.productId);
            this.dataGrantId(model.dataGrantId);
        }

        public final String getProductId() {
            return this.productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final String getDataGrantId() {
            return this.dataGrantId;
        }

        public final void setDataGrantId(String dataGrantId) {
            this.dataGrantId = dataGrantId;
        }

        @Override
        public final Builder dataGrantId(String dataGrantId) {
            this.dataGrantId = dataGrantId;
            return this;
        }

        public OriginDetails build() {
            return new OriginDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OriginDetails> {
        public Builder productId(String var1);

        public Builder dataGrantId(String var1);
    }
}

