/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dataexchange.model.LFTag;
import software.amazon.awssdk.services.dataexchange.model.ListOfLFTagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableLFTagPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableLFTagPolicy> {
    private static final SdkField<List<LFTag>> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Expression").getter(TableLFTagPolicy.getter(TableLFTagPolicy::expression)).setter(TableLFTagPolicy.setter(Builder::expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LFTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<LFTag> expression;

    private TableLFTagPolicy(BuilderImpl builder) {
        this.expression = builder.expression;
    }

    public final boolean hasExpression() {
        return this.expression != null && !(this.expression instanceof SdkAutoConstructList);
    }

    public final List<LFTag> expression() {
        return this.expression;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExpression() ? this.expression() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableLFTagPolicy)) {
            return false;
        }
        TableLFTagPolicy other = (TableLFTagPolicy)obj;
        return this.hasExpression() == other.hasExpression() && Objects.equals(this.expression(), other.expression());
    }

    public final String toString() {
        return ToString.builder((String)"TableLFTagPolicy").add("Expression", this.hasExpression() ? this.expression() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableLFTagPolicy, T> g) {
        return obj -> g.apply((TableLFTagPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<LFTag> expression = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TableLFTagPolicy model) {
            this.expression(model.expression);
        }

        public final List<LFTag.Builder> getExpression() {
            List<LFTag.Builder> result = ListOfLFTagsCopier.copyToBuilder(this.expression);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExpression(Collection<LFTag.BuilderImpl> expression) {
            this.expression = ListOfLFTagsCopier.copyFromBuilder(expression);
        }

        @Override
        public final Builder expression(Collection<LFTag> expression) {
            this.expression = ListOfLFTagsCopier.copy(expression);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expression(LFTag ... expression) {
            this.expression(Arrays.asList(expression));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expression(Consumer<LFTag.Builder> ... expression) {
            this.expression(Stream.of(expression).map(c -> (LFTag)((LFTag.Builder)LFTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TableLFTagPolicy build() {
            return new TableLFTagPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableLFTagPolicy> {
        public Builder expression(Collection<LFTag> var1);

        public Builder expression(LFTag ... var1);

        public Builder expression(Consumer<LFTag.Builder> ... var1);
    }
}

