/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.dataexchange.DataExchangeClient;
import software.amazon.awssdk.services.dataexchange.internal.UserAgentUtils;
import software.amazon.awssdk.services.dataexchange.model.AssetEntry;
import software.amazon.awssdk.services.dataexchange.model.ListRevisionAssetsRequest;
import software.amazon.awssdk.services.dataexchange.model.ListRevisionAssetsResponse;

public class ListRevisionAssetsIterable
implements SdkIterable<ListRevisionAssetsResponse> {
    private final DataExchangeClient client;
    private final ListRevisionAssetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRevisionAssetsIterable(DataExchangeClient client, ListRevisionAssetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRevisionAssetsResponseFetcher();
    }

    public Iterator<ListRevisionAssetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssetEntry> assets() {
        Function<ListRevisionAssetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assets() != null) {
                return response.assets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRevisionAssetsResponseFetcher
    implements SyncPageFetcher<ListRevisionAssetsResponse> {
        private ListRevisionAssetsResponseFetcher() {
        }

        public boolean hasNextPage(ListRevisionAssetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRevisionAssetsResponse nextPage(ListRevisionAssetsResponse previousPage) {
            if (previousPage == null) {
                return ListRevisionAssetsIterable.this.client.listRevisionAssets(ListRevisionAssetsIterable.this.firstRequest);
            }
            return ListRevisionAssetsIterable.this.client.listRevisionAssets((ListRevisionAssetsRequest)((Object)ListRevisionAssetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

