/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExceptionCause {
    INSUFFICIENT_S3_BUCKET_POLICY("InsufficientS3BucketPolicy"),
    S3_ACCESS_DENIED("S3AccessDenied"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExceptionCause> VALUE_MAP;
    private final String value;

    private ExceptionCause(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExceptionCause fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExceptionCause> knownValues() {
        EnumSet<ExceptionCause> knownValues = EnumSet.allOf(ExceptionCause.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExceptionCause.class, ExceptionCause::toString);
    }
}

