/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AssetType {
    S3_SNAPSHOT("S3_SNAPSHOT"),
    REDSHIFT_DATA_SHARE("REDSHIFT_DATA_SHARE"),
    API_GATEWAY_API("API_GATEWAY_API"),
    S3_DATA_ACCESS("S3_DATA_ACCESS"),
    LAKE_FORMATION_DATA_PERMISSION("LAKE_FORMATION_DATA_PERMISSION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AssetType> VALUE_MAP;
    private final String value;

    private AssetType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AssetType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AssetType> knownValues() {
        EnumSet<AssetType> knownValues = EnumSet.allOf(AssetType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AssetType.class, AssetType::toString);
    }
}

