/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LimitName {
    PRODUCTS_PER_ACCOUNT("Products per account"),
    DATA_SETS_PER_ACCOUNT("Data sets per account"),
    DATA_SETS_PER_PRODUCT("Data sets per product"),
    REVISIONS_PER_DATA_SET("Revisions per data set"),
    ASSETS_PER_REVISION("Assets per revision"),
    ASSETS_PER_IMPORT_JOB_FROM_AMAZON_S3("Assets per import job from Amazon S3"),
    ASSET_PER_EXPORT_JOB_FROM_AMAZON_S3("Asset per export job from Amazon S3"),
    ASSET_SIZE_IN_GB("Asset size in GB"),
    CONCURRENT_IN_PROGRESS_JOBS_TO_EXPORT_ASSETS_TO_AMAZON_S3("Concurrent in progress jobs to export assets to Amazon S3"),
    CONCURRENT_IN_PROGRESS_JOBS_TO_EXPORT_ASSETS_TO_A_SIGNED_URL("Concurrent in progress jobs to export assets to a signed URL"),
    CONCURRENT_IN_PROGRESS_JOBS_TO_IMPORT_ASSETS_FROM_AMAZON_S3("Concurrent in progress jobs to import assets from Amazon S3"),
    CONCURRENT_IN_PROGRESS_JOBS_TO_IMPORT_ASSETS_FROM_A_SIGNED_URL("Concurrent in progress jobs to import assets from a signed URL"),
    CONCURRENT_IN_PROGRESS_JOBS_TO_EXPORT_REVISIONS_TO_AMAZON_S3("Concurrent in progress jobs to export revisions to Amazon S3"),
    EVENT_ACTIONS_PER_ACCOUNT("Event actions per account"),
    AUTO_EXPORT_EVENT_ACTIONS_PER_DATA_SET("Auto export event actions per data set"),
    AMAZON_REDSHIFT_DATASHARE_ASSETS_PER_IMPORT_JOB_FROM_REDSHIFT("Amazon Redshift datashare assets per import job from Redshift"),
    CONCURRENT_IN_PROGRESS_JOBS_TO_IMPORT_ASSETS_FROM_AMAZON_REDSHIFT_DATASHARES("Concurrent in progress jobs to import assets from Amazon Redshift datashares"),
    REVISIONS_PER_AMAZON_REDSHIFT_DATASHARE_DATA_SET("Revisions per Amazon Redshift datashare data set"),
    AMAZON_REDSHIFT_DATASHARE_ASSETS_PER_REVISION("Amazon Redshift datashare assets per revision"),
    CONCURRENT_IN_PROGRESS_JOBS_TO_IMPORT_ASSETS_FROM_AN_API_GATEWAY_API("Concurrent in progress jobs to import assets from an API Gateway API"),
    AMAZON_API_GATEWAY_API_ASSETS_PER_REVISION("Amazon API Gateway API assets per revision"),
    REVISIONS_PER_AMAZON_API_GATEWAY_API_DATA_SET("Revisions per Amazon API Gateway API data set"),
    CONCURRENT_IN_PROGRESS_JOBS_TO_IMPORT_ASSETS_FROM_AN_AWS_LAKE_FORMATION_TAG_POLICY("Concurrent in progress jobs to import assets from an AWS Lake Formation tag policy"),
    AWS_LAKE_FORMATION_DATA_PERMISSION_ASSETS_PER_REVISION("AWS Lake Formation data permission assets per revision"),
    REVISIONS_PER_AWS_LAKE_FORMATION_DATA_PERMISSION_DATA_SET("Revisions per AWS Lake Formation data permission data set"),
    REVISIONS_PER_AMAZON_S3_DATA_ACCESS_DATA_SET("Revisions per Amazon S3 data access data set"),
    AMAZON_S3_DATA_ACCESS_ASSETS_PER_REVISION("Amazon S3 data access assets per revision"),
    CONCURRENT_IN_PROGRESS_JOBS_TO_CREATE_AMAZON_S3_DATA_ACCESS_ASSETS_FROM_S3_BUCKETS("Concurrent in progress jobs to create Amazon S3 data access assets from S3 buckets"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LimitName> VALUE_MAP;
    private final String value;

    private LimitName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LimitName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LimitName> knownValues() {
        EnumSet<LimitName> knownValues = EnumSet.allOf(LimitName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LimitName.class, LimitName::toString);
    }
}

