/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the published revision.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevisionPublished implements SdkPojo, Serializable,
        ToCopyableBuilder<RevisionPublished.Builder, RevisionPublished> {
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetId").getter(getter(RevisionPublished::dataSetId)).setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataSetId;

    private RevisionPublished(BuilderImpl builder) {
        this.dataSetId = builder.dataSetId;
    }

    /**
     * <p>
     * The data set ID of the published revision.
     * </p>
     * 
     * @return The data set ID of the published revision.
     */
    public final String dataSetId() {
        return dataSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevisionPublished)) {
            return false;
        }
        RevisionPublished other = (RevisionPublished) obj;
        return Objects.equals(dataSetId(), other.dataSetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RevisionPublished").add("DataSetId", dataSetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RevisionPublished, T> g) {
        return obj -> g.apply((RevisionPublished) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RevisionPublished> {
        /**
         * <p>
         * The data set ID of the published revision.
         * </p>
         * 
         * @param dataSetId
         *        The data set ID of the published revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);
    }

    static final class BuilderImpl implements Builder {
        private String dataSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(RevisionPublished model) {
            dataSetId(model.dataSetId);
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        @Override
        public RevisionPublished build() {
            return new RevisionPublished(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
