/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the LF-tag policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LFTagPolicyDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<LFTagPolicyDetails.Builder, LFTagPolicyDetails> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(LFTagPolicyDetails::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(LFTagPolicyDetails::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<LFResourceDetails> RESOURCE_DETAILS_FIELD = SdkField
            .<LFResourceDetails> builder(MarshallingType.SDK_POJO).memberName("ResourceDetails")
            .getter(getter(LFTagPolicyDetails::resourceDetails)).setter(setter(Builder::resourceDetails))
            .constructor(LFResourceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            RESOURCE_TYPE_FIELD, RESOURCE_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String catalogId;

    private final String resourceType;

    private final LFResourceDetails resourceDetails;

    private LFTagPolicyDetails(BuilderImpl builder) {
        this.catalogId = builder.catalogId;
        this.resourceType = builder.resourceType;
        this.resourceDetails = builder.resourceDetails;
    }

    /**
     * <p>
     * The identifier for the AWS Glue Data Catalog.
     * </p>
     * 
     * @return The identifier for the AWS Glue Data Catalog.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The resource type for which the LF-tag policy applies.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link LFResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type for which the LF-tag policy applies.
     * @see LFResourceType
     */
    public final LFResourceType resourceType() {
        return LFResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The resource type for which the LF-tag policy applies.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link LFResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type for which the LF-tag policy applies.
     * @see LFResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * Details for the Lake Formation Resources included in the LF-tag policy.
     * </p>
     * 
     * @return Details for the Lake Formation Resources included in the LF-tag policy.
     */
    public final LFResourceDetails resourceDetails() {
        return resourceDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LFTagPolicyDetails)) {
            return false;
        }
        LFTagPolicyDetails other = (LFTagPolicyDetails) obj;
        return Objects.equals(catalogId(), other.catalogId())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resourceDetails(), other.resourceDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LFTagPolicyDetails").add("CatalogId", catalogId()).add("ResourceType", resourceTypeAsString())
                .add("ResourceDetails", resourceDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "ResourceDetails":
            return Optional.ofNullable(clazz.cast(resourceDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LFTagPolicyDetails, T> g) {
        return obj -> g.apply((LFTagPolicyDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LFTagPolicyDetails> {
        /**
         * <p>
         * The identifier for the AWS Glue Data Catalog.
         * </p>
         * 
         * @param catalogId
         *        The identifier for the AWS Glue Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The resource type for which the LF-tag policy applies.
         * </p>
         * 
         * @param resourceType
         *        The resource type for which the LF-tag policy applies.
         * @see LFResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LFResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type for which the LF-tag policy applies.
         * </p>
         * 
         * @param resourceType
         *        The resource type for which the LF-tag policy applies.
         * @see LFResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LFResourceType
         */
        Builder resourceType(LFResourceType resourceType);

        /**
         * <p>
         * Details for the Lake Formation Resources included in the LF-tag policy.
         * </p>
         * 
         * @param resourceDetails
         *        Details for the Lake Formation Resources included in the LF-tag policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceDetails(LFResourceDetails resourceDetails);

        /**
         * <p>
         * Details for the Lake Formation Resources included in the LF-tag policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link LFResourceDetails.Builder} avoiding the
         * need to create one manually via {@link LFResourceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LFResourceDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceDetails(LFResourceDetails)}.
         * 
         * @param resourceDetails
         *        a consumer that will call methods on {@link LFResourceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceDetails(LFResourceDetails)
         */
        default Builder resourceDetails(Consumer<LFResourceDetails.Builder> resourceDetails) {
            return resourceDetails(LFResourceDetails.builder().applyMutation(resourceDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String catalogId;

        private String resourceType;

        private LFResourceDetails resourceDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(LFTagPolicyDetails model) {
            catalogId(model.catalogId);
            resourceType(model.resourceType);
            resourceDetails(model.resourceDetails);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(LFResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final LFResourceDetails.Builder getResourceDetails() {
            return resourceDetails != null ? resourceDetails.toBuilder() : null;
        }

        public final void setResourceDetails(LFResourceDetails.BuilderImpl resourceDetails) {
            this.resourceDetails = resourceDetails != null ? resourceDetails.build() : null;
        }

        @Override
        public final Builder resourceDetails(LFResourceDetails resourceDetails) {
            this.resourceDetails = resourceDetails;
            return this;
        }

        @Override
        public LFTagPolicyDetails build() {
            return new LFTagPolicyDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
