/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dataexchange.model.Action;
import software.amazon.awssdk.services.dataexchange.model.Event;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventActionEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventActionEntry> {
    private static final SdkField<Action> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Action").getter(EventActionEntry.getter(EventActionEntry::action)).setter(EventActionEntry.setter(Builder::action)).constructor(Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(EventActionEntry.getter(EventActionEntry::arn)).setter(EventActionEntry.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(EventActionEntry.getter(EventActionEntry::createdAt)).setter(EventActionEntry.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Event> EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Event").getter(EventActionEntry.getter(EventActionEntry::event)).setter(EventActionEntry.setter(Builder::event)).constructor(Event::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Event").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(EventActionEntry.getter(EventActionEntry::id)).setter(EventActionEntry.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(EventActionEntry.getter(EventActionEntry::updatedAt)).setter(EventActionEntry.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, ARN_FIELD, CREATED_AT_FIELD, EVENT_FIELD, ID_FIELD, UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Action action;
    private final String arn;
    private final Instant createdAt;
    private final Event event;
    private final String id;
    private final Instant updatedAt;

    private EventActionEntry(BuilderImpl builder) {
        this.action = builder.action;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.event = builder.event;
        this.id = builder.id;
        this.updatedAt = builder.updatedAt;
    }

    public final Action action() {
        return this.action;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Event event() {
        return this.event;
    }

    public final String id() {
        return this.id;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.event());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventActionEntry)) {
            return false;
        }
        EventActionEntry other = (EventActionEntry)obj;
        return Objects.equals(this.action(), other.action()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.event(), other.event()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"EventActionEntry").add("Action", (Object)this.action()).add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("Event", (Object)this.event()).add("Id", (Object)this.id()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Event": {
                return Optional.ofNullable(clazz.cast(this.event()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventActionEntry, T> g) {
        return obj -> g.apply((EventActionEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Action action;
        private String arn;
        private Instant createdAt;
        private Event event;
        private String id;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(EventActionEntry model) {
            this.action(model.action);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.event(model.event);
            this.id(model.id);
            this.updatedAt(model.updatedAt);
        }

        public final Action.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        public final void setAction(Action.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(Action action) {
            this.action = action;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Event.Builder getEvent() {
            return this.event != null ? this.event.toBuilder() : null;
        }

        public final void setEvent(Event.BuilderImpl event) {
            this.event = event != null ? event.build() : null;
        }

        @Override
        public final Builder event(Event event) {
            this.event = event;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public EventActionEntry build() {
            return new EventActionEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventActionEntry> {
        public Builder action(Action var1);

        default public Builder action(Consumer<Action.Builder> action) {
            return this.action((Action)((Action.Builder)Action.builder().applyMutation(action)).build());
        }

        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder event(Event var1);

        default public Builder event(Consumer<Event.Builder> event) {
            return this.event((Event)((Event.Builder)Event.builder().applyMutation(event)).build());
        }

        public Builder id(String var1);

        public Builder updatedAt(Instant var1);
    }
}

