/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dataexchange.model.LFResourceDetails;
import software.amazon.awssdk.services.dataexchange.model.LFResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LFTagPolicyDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LFTagPolicyDetails> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(LFTagPolicyDetails.getter(LFTagPolicyDetails::catalogId)).setter(LFTagPolicyDetails.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(LFTagPolicyDetails.getter(LFTagPolicyDetails::resourceTypeAsString)).setter(LFTagPolicyDetails.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<LFResourceDetails> RESOURCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceDetails").getter(LFTagPolicyDetails.getter(LFTagPolicyDetails::resourceDetails)).setter(LFTagPolicyDetails.setter(Builder::resourceDetails)).constructor(LFResourceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String catalogId;
    private final String resourceType;
    private final LFResourceDetails resourceDetails;

    private LFTagPolicyDetails(BuilderImpl builder) {
        this.catalogId = builder.catalogId;
        this.resourceType = builder.resourceType;
        this.resourceDetails = builder.resourceDetails;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final LFResourceType resourceType() {
        return LFResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final LFResourceDetails resourceDetails() {
        return this.resourceDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LFTagPolicyDetails)) {
            return false;
        }
        LFTagPolicyDetails other = (LFTagPolicyDetails)obj;
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceDetails(), other.resourceDetails());
    }

    public final String toString() {
        return ToString.builder((String)"LFTagPolicyDetails").add("CatalogId", (Object)this.catalogId()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceDetails", (Object)this.resourceDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ResourceDetails": {
                return Optional.ofNullable(clazz.cast(this.resourceDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LFTagPolicyDetails, T> g) {
        return obj -> g.apply((LFTagPolicyDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String catalogId;
        private String resourceType;
        private LFResourceDetails resourceDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(LFTagPolicyDetails model) {
            this.catalogId(model.catalogId);
            this.resourceType(model.resourceType);
            this.resourceDetails(model.resourceDetails);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(LFResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final LFResourceDetails.Builder getResourceDetails() {
            return this.resourceDetails != null ? this.resourceDetails.toBuilder() : null;
        }

        public final void setResourceDetails(LFResourceDetails.BuilderImpl resourceDetails) {
            this.resourceDetails = resourceDetails != null ? resourceDetails.build() : null;
        }

        @Override
        public final Builder resourceDetails(LFResourceDetails resourceDetails) {
            this.resourceDetails = resourceDetails;
            return this;
        }

        public LFTagPolicyDetails build() {
            return new LFTagPolicyDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LFTagPolicyDetails> {
        public Builder catalogId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(LFResourceType var1);

        public Builder resourceDetails(LFResourceDetails var1);

        default public Builder resourceDetails(Consumer<LFResourceDetails.Builder> resourceDetails) {
            return this.resourceDetails((LFResourceDetails)((LFResourceDetails.Builder)LFResourceDetails.builder().applyMutation(resourceDetails)).build());
        }
    }
}

