/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.dataexchange.DataExchangeAsyncClient;
import software.amazon.awssdk.services.dataexchange.internal.UserAgentUtils;
import software.amazon.awssdk.services.dataexchange.model.EventActionEntry;
import software.amazon.awssdk.services.dataexchange.model.ListEventActionsRequest;
import software.amazon.awssdk.services.dataexchange.model.ListEventActionsResponse;

public class ListEventActionsPublisher
implements SdkPublisher<ListEventActionsResponse> {
    private final DataExchangeAsyncClient client;
    private final ListEventActionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEventActionsPublisher(DataExchangeAsyncClient client, ListEventActionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEventActionsPublisher(DataExchangeAsyncClient client, ListEventActionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEventActionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEventActionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EventActionEntry> eventActions() {
        Function<ListEventActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventActions() != null) {
                return response.eventActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEventActionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEventActionsResponseFetcher
    implements AsyncPageFetcher<ListEventActionsResponse> {
        private ListEventActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListEventActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEventActionsResponse> nextPage(ListEventActionsResponse previousPage) {
            if (previousPage == null) {
                return ListEventActionsPublisher.this.client.listEventActions(ListEventActionsPublisher.this.firstRequest);
            }
            return ListEventActionsPublisher.this.client.listEventActions((ListEventActionsRequest)((Object)ListEventActionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

