/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The AWS Lake Formation data permission asset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LakeFormationDataPermissionAsset implements SdkPojo, Serializable,
        ToCopyableBuilder<LakeFormationDataPermissionAsset.Builder, LakeFormationDataPermissionAsset> {
    private static final SdkField<LakeFormationDataPermissionDetails> LAKE_FORMATION_DATA_PERMISSION_DETAILS_FIELD = SdkField
            .<LakeFormationDataPermissionDetails> builder(MarshallingType.SDK_POJO)
            .memberName("LakeFormationDataPermissionDetails")
            .getter(getter(LakeFormationDataPermissionAsset::lakeFormationDataPermissionDetails))
            .setter(setter(Builder::lakeFormationDataPermissionDetails))
            .constructor(LakeFormationDataPermissionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LakeFormationDataPermissionDetails")
                    .build()).build();

    private static final SdkField<String> LAKE_FORMATION_DATA_PERMISSION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LakeFormationDataPermissionType")
            .getter(getter(LakeFormationDataPermissionAsset::lakeFormationDataPermissionTypeAsString))
            .setter(setter(Builder::lakeFormationDataPermissionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LakeFormationDataPermissionType")
                    .build()).build();

    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(LakeFormationDataPermissionAsset::permissionsAsStrings))
            .setter(setter(Builder::permissionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(LakeFormationDataPermissionAsset::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LAKE_FORMATION_DATA_PERMISSION_DETAILS_FIELD, LAKE_FORMATION_DATA_PERMISSION_TYPE_FIELD, PERMISSIONS_FIELD,
            ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final LakeFormationDataPermissionDetails lakeFormationDataPermissionDetails;

    private final String lakeFormationDataPermissionType;

    private final List<String> permissions;

    private final String roleArn;

    private LakeFormationDataPermissionAsset(BuilderImpl builder) {
        this.lakeFormationDataPermissionDetails = builder.lakeFormationDataPermissionDetails;
        this.lakeFormationDataPermissionType = builder.lakeFormationDataPermissionType;
        this.permissions = builder.permissions;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * Details about the AWS Lake Formation data permission.
     * </p>
     * 
     * @return Details about the AWS Lake Formation data permission.
     */
    public final LakeFormationDataPermissionDetails lakeFormationDataPermissionDetails() {
        return lakeFormationDataPermissionDetails;
    }

    /**
     * <p>
     * The data permission type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lakeFormationDataPermissionType} will return
     * {@link LakeFormationDataPermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lakeFormationDataPermissionTypeAsString}.
     * </p>
     * 
     * @return The data permission type.
     * @see LakeFormationDataPermissionType
     */
    public final LakeFormationDataPermissionType lakeFormationDataPermissionType() {
        return LakeFormationDataPermissionType.fromValue(lakeFormationDataPermissionType);
    }

    /**
     * <p>
     * The data permission type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lakeFormationDataPermissionType} will return
     * {@link LakeFormationDataPermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lakeFormationDataPermissionTypeAsString}.
     * </p>
     * 
     * @return The data permission type.
     * @see LakeFormationDataPermissionType
     */
    public final String lakeFormationDataPermissionTypeAsString() {
        return lakeFormationDataPermissionType;
    }

    /**
     * <p>
     * The permissions granted to the subscribers on the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return The permissions granted to the subscribers on the resource.
     */
    public final List<LFPermission> permissions() {
        return ListOfLFPermissionsCopier.copyStringToEnum(permissions);
    }

    /**
     * For responses, this returns true if the service returned a value for the Permissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permissions granted to the subscribers on the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return The permissions granted to the subscribers on the resource.
     */
    public final List<String> permissionsAsStrings() {
        return permissions;
    }

    /**
     * <p>
     * The IAM role's ARN that allows AWS Data Exchange to assume the role and grant and revoke permissions to AWS Lake
     * Formation data permissions.
     * </p>
     * 
     * @return The IAM role's ARN that allows AWS Data Exchange to assume the role and grant and revoke permissions to
     *         AWS Lake Formation data permissions.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lakeFormationDataPermissionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(lakeFormationDataPermissionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LakeFormationDataPermissionAsset)) {
            return false;
        }
        LakeFormationDataPermissionAsset other = (LakeFormationDataPermissionAsset) obj;
        return Objects.equals(lakeFormationDataPermissionDetails(), other.lakeFormationDataPermissionDetails())
                && Objects.equals(lakeFormationDataPermissionTypeAsString(), other.lakeFormationDataPermissionTypeAsString())
                && hasPermissions() == other.hasPermissions()
                && Objects.equals(permissionsAsStrings(), other.permissionsAsStrings())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LakeFormationDataPermissionAsset")
                .add("LakeFormationDataPermissionDetails", lakeFormationDataPermissionDetails())
                .add("LakeFormationDataPermissionType", lakeFormationDataPermissionTypeAsString())
                .add("Permissions", hasPermissions() ? permissionsAsStrings() : null).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LakeFormationDataPermissionDetails":
            return Optional.ofNullable(clazz.cast(lakeFormationDataPermissionDetails()));
        case "LakeFormationDataPermissionType":
            return Optional.ofNullable(clazz.cast(lakeFormationDataPermissionTypeAsString()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissionsAsStrings()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LakeFormationDataPermissionAsset, T> g) {
        return obj -> g.apply((LakeFormationDataPermissionAsset) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LakeFormationDataPermissionAsset> {
        /**
         * <p>
         * Details about the AWS Lake Formation data permission.
         * </p>
         * 
         * @param lakeFormationDataPermissionDetails
         *        Details about the AWS Lake Formation data permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lakeFormationDataPermissionDetails(LakeFormationDataPermissionDetails lakeFormationDataPermissionDetails);

        /**
         * <p>
         * Details about the AWS Lake Formation data permission.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LakeFormationDataPermissionDetails.Builder} avoiding the need to create one manually via
         * {@link LakeFormationDataPermissionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LakeFormationDataPermissionDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #lakeFormationDataPermissionDetails(LakeFormationDataPermissionDetails)}.
         * 
         * @param lakeFormationDataPermissionDetails
         *        a consumer that will call methods on {@link LakeFormationDataPermissionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lakeFormationDataPermissionDetails(LakeFormationDataPermissionDetails)
         */
        default Builder lakeFormationDataPermissionDetails(
                Consumer<LakeFormationDataPermissionDetails.Builder> lakeFormationDataPermissionDetails) {
            return lakeFormationDataPermissionDetails(LakeFormationDataPermissionDetails.builder()
                    .applyMutation(lakeFormationDataPermissionDetails).build());
        }

        /**
         * <p>
         * The data permission type.
         * </p>
         * 
         * @param lakeFormationDataPermissionType
         *        The data permission type.
         * @see LakeFormationDataPermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LakeFormationDataPermissionType
         */
        Builder lakeFormationDataPermissionType(String lakeFormationDataPermissionType);

        /**
         * <p>
         * The data permission type.
         * </p>
         * 
         * @param lakeFormationDataPermissionType
         *        The data permission type.
         * @see LakeFormationDataPermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LakeFormationDataPermissionType
         */
        Builder lakeFormationDataPermissionType(LakeFormationDataPermissionType lakeFormationDataPermissionType);

        /**
         * <p>
         * The permissions granted to the subscribers on the resource.
         * </p>
         * 
         * @param permissions
         *        The permissions granted to the subscribers on the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithStrings(Collection<String> permissions);

        /**
         * <p>
         * The permissions granted to the subscribers on the resource.
         * </p>
         * 
         * @param permissions
         *        The permissions granted to the subscribers on the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithStrings(String... permissions);

        /**
         * <p>
         * The permissions granted to the subscribers on the resource.
         * </p>
         * 
         * @param permissions
         *        The permissions granted to the subscribers on the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<LFPermission> permissions);

        /**
         * <p>
         * The permissions granted to the subscribers on the resource.
         * </p>
         * 
         * @param permissions
         *        The permissions granted to the subscribers on the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(LFPermission... permissions);

        /**
         * <p>
         * The IAM role's ARN that allows AWS Data Exchange to assume the role and grant and revoke permissions to AWS
         * Lake Formation data permissions.
         * </p>
         * 
         * @param roleArn
         *        The IAM role's ARN that allows AWS Data Exchange to assume the role and grant and revoke permissions
         *        to AWS Lake Formation data permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private LakeFormationDataPermissionDetails lakeFormationDataPermissionDetails;

        private String lakeFormationDataPermissionType;

        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(LakeFormationDataPermissionAsset model) {
            lakeFormationDataPermissionDetails(model.lakeFormationDataPermissionDetails);
            lakeFormationDataPermissionType(model.lakeFormationDataPermissionType);
            permissionsWithStrings(model.permissions);
            roleArn(model.roleArn);
        }

        public final LakeFormationDataPermissionDetails.Builder getLakeFormationDataPermissionDetails() {
            return lakeFormationDataPermissionDetails != null ? lakeFormationDataPermissionDetails.toBuilder() : null;
        }

        public final void setLakeFormationDataPermissionDetails(
                LakeFormationDataPermissionDetails.BuilderImpl lakeFormationDataPermissionDetails) {
            this.lakeFormationDataPermissionDetails = lakeFormationDataPermissionDetails != null ? lakeFormationDataPermissionDetails
                    .build() : null;
        }

        @Override
        public final Builder lakeFormationDataPermissionDetails(
                LakeFormationDataPermissionDetails lakeFormationDataPermissionDetails) {
            this.lakeFormationDataPermissionDetails = lakeFormationDataPermissionDetails;
            return this;
        }

        public final String getLakeFormationDataPermissionType() {
            return lakeFormationDataPermissionType;
        }

        public final void setLakeFormationDataPermissionType(String lakeFormationDataPermissionType) {
            this.lakeFormationDataPermissionType = lakeFormationDataPermissionType;
        }

        @Override
        public final Builder lakeFormationDataPermissionType(String lakeFormationDataPermissionType) {
            this.lakeFormationDataPermissionType = lakeFormationDataPermissionType;
            return this;
        }

        @Override
        public final Builder lakeFormationDataPermissionType(LakeFormationDataPermissionType lakeFormationDataPermissionType) {
            this.lakeFormationDataPermissionType(lakeFormationDataPermissionType == null ? null : lakeFormationDataPermissionType
                    .toString());
            return this;
        }

        public final Collection<String> getPermissions() {
            if (permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return permissions;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = ListOfLFPermissionsCopier.copy(permissions);
        }

        @Override
        public final Builder permissionsWithStrings(Collection<String> permissions) {
            this.permissions = ListOfLFPermissionsCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithStrings(String... permissions) {
            permissionsWithStrings(Arrays.asList(permissions));
            return this;
        }

        @Override
        public final Builder permissions(Collection<LFPermission> permissions) {
            this.permissions = ListOfLFPermissionsCopier.copyEnumToString(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(LFPermission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public LakeFormationDataPermissionAsset build() {
            return new LakeFormationDataPermissionAsset(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
