/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEventActionRequest extends DataExchangeRequest implements
        ToCopyableBuilder<CreateEventActionRequest.Builder, CreateEventActionRequest> {
    private static final SdkField<Action> ACTION_FIELD = SdkField.<Action> builder(MarshallingType.SDK_POJO).memberName("Action")
            .getter(getter(CreateEventActionRequest::action)).setter(setter(Builder::action)).constructor(Action::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<Event> EVENT_FIELD = SdkField.<Event> builder(MarshallingType.SDK_POJO).memberName("Event")
            .getter(getter(CreateEventActionRequest::event)).setter(setter(Builder::event)).constructor(Event::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Event").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, EVENT_FIELD));

    private final Action action;

    private final Event event;

    private CreateEventActionRequest(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.event = builder.event;
    }

    /**
     * <p>
     * What occurs after a certain event.
     * </p>
     * 
     * @return What occurs after a certain event.
     */
    public final Action action() {
        return action;
    }

    /**
     * <p>
     * What occurs to start an action.
     * </p>
     * 
     * @return What occurs to start an action.
     */
    public final Event event() {
        return event;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(event());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEventActionRequest)) {
            return false;
        }
        CreateEventActionRequest other = (CreateEventActionRequest) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(event(), other.event());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEventActionRequest").add("Action", action()).add("Event", event()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "Event":
            return Optional.ofNullable(clazz.cast(event()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEventActionRequest, T> g) {
        return obj -> g.apply((CreateEventActionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataExchangeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateEventActionRequest> {
        /**
         * <p>
         * What occurs after a certain event.
         * </p>
         * 
         * @param action
         *        What occurs after a certain event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(Action action);

        /**
         * <p>
         * What occurs after a certain event.
         * </p>
         * This is a convenience method that creates an instance of the {@link Action.Builder} avoiding the need to
         * create one manually via {@link Action#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Action.Builder#build()} is called immediately and its result is
         * passed to {@link #action(Action)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link Action.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(Action)
         */
        default Builder action(Consumer<Action.Builder> action) {
            return action(Action.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * What occurs to start an action.
         * </p>
         * 
         * @param event
         *        What occurs to start an action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder event(Event event);

        /**
         * <p>
         * What occurs to start an action.
         * </p>
         * This is a convenience method that creates an instance of the {@link Event.Builder} avoiding the need to
         * create one manually via {@link Event#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Event.Builder#build()} is called immediately and its result is
         * passed to {@link #event(Event)}.
         * 
         * @param event
         *        a consumer that will call methods on {@link Event.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #event(Event)
         */
        default Builder event(Consumer<Event.Builder> event) {
            return event(Event.builder().applyMutation(event).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataExchangeRequest.BuilderImpl implements Builder {
        private Action action;

        private Event event;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEventActionRequest model) {
            super(model);
            action(model.action);
            event(model.event);
        }

        public final Action.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(Action.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(Action action) {
            this.action = action;
            return this;
        }

        public final Event.Builder getEvent() {
            return event != null ? event.toBuilder() : null;
        }

        public final void setEvent(Event.BuilderImpl event) {
            this.event = event != null ? event.build() : null;
        }

        @Override
        public final Builder event(Event event) {
            this.event = event;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEventActionRequest build() {
            return new CreateEventActionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
