/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum Code {
    ACCESS_DENIED_EXCEPTION("ACCESS_DENIED_EXCEPTION"),

    INTERNAL_SERVER_EXCEPTION("INTERNAL_SERVER_EXCEPTION"),

    MALWARE_DETECTED("MALWARE_DETECTED"),

    RESOURCE_NOT_FOUND_EXCEPTION("RESOURCE_NOT_FOUND_EXCEPTION"),

    SERVICE_QUOTA_EXCEEDED_EXCEPTION("SERVICE_QUOTA_EXCEEDED_EXCEPTION"),

    VALIDATION_EXCEPTION("VALIDATION_EXCEPTION"),

    MALWARE_SCAN_ENCRYPTED_FILE("MALWARE_SCAN_ENCRYPTED_FILE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Code> VALUE_MAP = EnumUtils.uniqueIndex(Code.class, Code::toString);

    private final String value;

    private Code(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return Code corresponding to the value
     */
    public static Code fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link Code}s
     */
    public static Set<Code> knownValues() {
        Set<Code> knownValues = EnumSet.allOf(Code.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
