/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the asset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetDetails implements SdkPojo, Serializable, ToCopyableBuilder<AssetDetails.Builder, AssetDetails> {
    private static final SdkField<S3SnapshotAsset> S3_SNAPSHOT_ASSET_FIELD = SdkField
            .<S3SnapshotAsset> builder(MarshallingType.SDK_POJO).memberName("S3SnapshotAsset")
            .getter(getter(AssetDetails::s3SnapshotAsset)).setter(setter(Builder::s3SnapshotAsset))
            .constructor(S3SnapshotAsset::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3SnapshotAsset").build()).build();

    private static final SdkField<RedshiftDataShareAsset> REDSHIFT_DATA_SHARE_ASSET_FIELD = SdkField
            .<RedshiftDataShareAsset> builder(MarshallingType.SDK_POJO).memberName("RedshiftDataShareAsset")
            .getter(getter(AssetDetails::redshiftDataShareAsset)).setter(setter(Builder::redshiftDataShareAsset))
            .constructor(RedshiftDataShareAsset::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftDataShareAsset").build())
            .build();

    private static final SdkField<ApiGatewayApiAsset> API_GATEWAY_API_ASSET_FIELD = SdkField
            .<ApiGatewayApiAsset> builder(MarshallingType.SDK_POJO).memberName("ApiGatewayApiAsset")
            .getter(getter(AssetDetails::apiGatewayApiAsset)).setter(setter(Builder::apiGatewayApiAsset))
            .constructor(ApiGatewayApiAsset::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiGatewayApiAsset").build())
            .build();

    private static final SdkField<S3DataAccessAsset> S3_DATA_ACCESS_ASSET_FIELD = SdkField
            .<S3DataAccessAsset> builder(MarshallingType.SDK_POJO).memberName("S3DataAccessAsset")
            .getter(getter(AssetDetails::s3DataAccessAsset)).setter(setter(Builder::s3DataAccessAsset))
            .constructor(S3DataAccessAsset::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataAccessAsset").build()).build();

    private static final SdkField<LakeFormationDataPermissionAsset> LAKE_FORMATION_DATA_PERMISSION_ASSET_FIELD = SdkField
            .<LakeFormationDataPermissionAsset> builder(MarshallingType.SDK_POJO)
            .memberName("LakeFormationDataPermissionAsset")
            .getter(getter(AssetDetails::lakeFormationDataPermissionAsset))
            .setter(setter(Builder::lakeFormationDataPermissionAsset))
            .constructor(LakeFormationDataPermissionAsset::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LakeFormationDataPermissionAsset")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_SNAPSHOT_ASSET_FIELD,
            REDSHIFT_DATA_SHARE_ASSET_FIELD, API_GATEWAY_API_ASSET_FIELD, S3_DATA_ACCESS_ASSET_FIELD,
            LAKE_FORMATION_DATA_PERMISSION_ASSET_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3SnapshotAsset s3SnapshotAsset;

    private final RedshiftDataShareAsset redshiftDataShareAsset;

    private final ApiGatewayApiAsset apiGatewayApiAsset;

    private final S3DataAccessAsset s3DataAccessAsset;

    private final LakeFormationDataPermissionAsset lakeFormationDataPermissionAsset;

    private AssetDetails(BuilderImpl builder) {
        this.s3SnapshotAsset = builder.s3SnapshotAsset;
        this.redshiftDataShareAsset = builder.redshiftDataShareAsset;
        this.apiGatewayApiAsset = builder.apiGatewayApiAsset;
        this.s3DataAccessAsset = builder.s3DataAccessAsset;
        this.lakeFormationDataPermissionAsset = builder.lakeFormationDataPermissionAsset;
    }

    /**
     * <p>
     * The Amazon S3 object that is the asset.
     * </p>
     * 
     * @return The Amazon S3 object that is the asset.
     */
    public final S3SnapshotAsset s3SnapshotAsset() {
        return s3SnapshotAsset;
    }

    /**
     * <p>
     * The Amazon Redshift datashare that is the asset.
     * </p>
     * 
     * @return The Amazon Redshift datashare that is the asset.
     */
    public final RedshiftDataShareAsset redshiftDataShareAsset() {
        return redshiftDataShareAsset;
    }

    /**
     * <p>
     * Information about the API Gateway API asset.
     * </p>
     * 
     * @return Information about the API Gateway API asset.
     */
    public final ApiGatewayApiAsset apiGatewayApiAsset() {
        return apiGatewayApiAsset;
    }

    /**
     * <p>
     * The Amazon S3 data access that is the asset.
     * </p>
     * 
     * @return The Amazon S3 data access that is the asset.
     */
    public final S3DataAccessAsset s3DataAccessAsset() {
        return s3DataAccessAsset;
    }

    /**
     * <p>
     * The AWS Lake Formation data permission that is the asset.
     * </p>
     * 
     * @return The AWS Lake Formation data permission that is the asset.
     */
    public final LakeFormationDataPermissionAsset lakeFormationDataPermissionAsset() {
        return lakeFormationDataPermissionAsset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3SnapshotAsset());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftDataShareAsset());
        hashCode = 31 * hashCode + Objects.hashCode(apiGatewayApiAsset());
        hashCode = 31 * hashCode + Objects.hashCode(s3DataAccessAsset());
        hashCode = 31 * hashCode + Objects.hashCode(lakeFormationDataPermissionAsset());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetDetails)) {
            return false;
        }
        AssetDetails other = (AssetDetails) obj;
        return Objects.equals(s3SnapshotAsset(), other.s3SnapshotAsset())
                && Objects.equals(redshiftDataShareAsset(), other.redshiftDataShareAsset())
                && Objects.equals(apiGatewayApiAsset(), other.apiGatewayApiAsset())
                && Objects.equals(s3DataAccessAsset(), other.s3DataAccessAsset())
                && Objects.equals(lakeFormationDataPermissionAsset(), other.lakeFormationDataPermissionAsset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetDetails").add("S3SnapshotAsset", s3SnapshotAsset())
                .add("RedshiftDataShareAsset", redshiftDataShareAsset()).add("ApiGatewayApiAsset", apiGatewayApiAsset())
                .add("S3DataAccessAsset", s3DataAccessAsset())
                .add("LakeFormationDataPermissionAsset", lakeFormationDataPermissionAsset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3SnapshotAsset":
            return Optional.ofNullable(clazz.cast(s3SnapshotAsset()));
        case "RedshiftDataShareAsset":
            return Optional.ofNullable(clazz.cast(redshiftDataShareAsset()));
        case "ApiGatewayApiAsset":
            return Optional.ofNullable(clazz.cast(apiGatewayApiAsset()));
        case "S3DataAccessAsset":
            return Optional.ofNullable(clazz.cast(s3DataAccessAsset()));
        case "LakeFormationDataPermissionAsset":
            return Optional.ofNullable(clazz.cast(lakeFormationDataPermissionAsset()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetDetails, T> g) {
        return obj -> g.apply((AssetDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetDetails> {
        /**
         * <p>
         * The Amazon S3 object that is the asset.
         * </p>
         * 
         * @param s3SnapshotAsset
         *        The Amazon S3 object that is the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3SnapshotAsset(S3SnapshotAsset s3SnapshotAsset);

        /**
         * <p>
         * The Amazon S3 object that is the asset.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3SnapshotAsset.Builder} avoiding the
         * need to create one manually via {@link S3SnapshotAsset#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3SnapshotAsset.Builder#build()} is called immediately and its
         * result is passed to {@link #s3SnapshotAsset(S3SnapshotAsset)}.
         * 
         * @param s3SnapshotAsset
         *        a consumer that will call methods on {@link S3SnapshotAsset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3SnapshotAsset(S3SnapshotAsset)
         */
        default Builder s3SnapshotAsset(Consumer<S3SnapshotAsset.Builder> s3SnapshotAsset) {
            return s3SnapshotAsset(S3SnapshotAsset.builder().applyMutation(s3SnapshotAsset).build());
        }

        /**
         * <p>
         * The Amazon Redshift datashare that is the asset.
         * </p>
         * 
         * @param redshiftDataShareAsset
         *        The Amazon Redshift datashare that is the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftDataShareAsset(RedshiftDataShareAsset redshiftDataShareAsset);

        /**
         * <p>
         * The Amazon Redshift datashare that is the asset.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedshiftDataShareAsset.Builder} avoiding
         * the need to create one manually via {@link RedshiftDataShareAsset#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftDataShareAsset.Builder#build()} is called immediately and
         * its result is passed to {@link #redshiftDataShareAsset(RedshiftDataShareAsset)}.
         * 
         * @param redshiftDataShareAsset
         *        a consumer that will call methods on {@link RedshiftDataShareAsset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftDataShareAsset(RedshiftDataShareAsset)
         */
        default Builder redshiftDataShareAsset(Consumer<RedshiftDataShareAsset.Builder> redshiftDataShareAsset) {
            return redshiftDataShareAsset(RedshiftDataShareAsset.builder().applyMutation(redshiftDataShareAsset).build());
        }

        /**
         * <p>
         * Information about the API Gateway API asset.
         * </p>
         * 
         * @param apiGatewayApiAsset
         *        Information about the API Gateway API asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiGatewayApiAsset(ApiGatewayApiAsset apiGatewayApiAsset);

        /**
         * <p>
         * Information about the API Gateway API asset.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApiGatewayApiAsset.Builder} avoiding the
         * need to create one manually via {@link ApiGatewayApiAsset#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApiGatewayApiAsset.Builder#build()} is called immediately and its
         * result is passed to {@link #apiGatewayApiAsset(ApiGatewayApiAsset)}.
         * 
         * @param apiGatewayApiAsset
         *        a consumer that will call methods on {@link ApiGatewayApiAsset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apiGatewayApiAsset(ApiGatewayApiAsset)
         */
        default Builder apiGatewayApiAsset(Consumer<ApiGatewayApiAsset.Builder> apiGatewayApiAsset) {
            return apiGatewayApiAsset(ApiGatewayApiAsset.builder().applyMutation(apiGatewayApiAsset).build());
        }

        /**
         * <p>
         * The Amazon S3 data access that is the asset.
         * </p>
         * 
         * @param s3DataAccessAsset
         *        The Amazon S3 data access that is the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DataAccessAsset(S3DataAccessAsset s3DataAccessAsset);

        /**
         * <p>
         * The Amazon S3 data access that is the asset.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3DataAccessAsset.Builder} avoiding the
         * need to create one manually via {@link S3DataAccessAsset#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DataAccessAsset.Builder#build()} is called immediately and its
         * result is passed to {@link #s3DataAccessAsset(S3DataAccessAsset)}.
         * 
         * @param s3DataAccessAsset
         *        a consumer that will call methods on {@link S3DataAccessAsset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3DataAccessAsset(S3DataAccessAsset)
         */
        default Builder s3DataAccessAsset(Consumer<S3DataAccessAsset.Builder> s3DataAccessAsset) {
            return s3DataAccessAsset(S3DataAccessAsset.builder().applyMutation(s3DataAccessAsset).build());
        }

        /**
         * <p>
         * The AWS Lake Formation data permission that is the asset.
         * </p>
         * 
         * @param lakeFormationDataPermissionAsset
         *        The AWS Lake Formation data permission that is the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lakeFormationDataPermissionAsset(LakeFormationDataPermissionAsset lakeFormationDataPermissionAsset);

        /**
         * <p>
         * The AWS Lake Formation data permission that is the asset.
         * </p>
         * This is a convenience method that creates an instance of the {@link LakeFormationDataPermissionAsset.Builder}
         * avoiding the need to create one manually via {@link LakeFormationDataPermissionAsset#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LakeFormationDataPermissionAsset.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #lakeFormationDataPermissionAsset(LakeFormationDataPermissionAsset)}.
         * 
         * @param lakeFormationDataPermissionAsset
         *        a consumer that will call methods on {@link LakeFormationDataPermissionAsset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lakeFormationDataPermissionAsset(LakeFormationDataPermissionAsset)
         */
        default Builder lakeFormationDataPermissionAsset(
                Consumer<LakeFormationDataPermissionAsset.Builder> lakeFormationDataPermissionAsset) {
            return lakeFormationDataPermissionAsset(LakeFormationDataPermissionAsset.builder()
                    .applyMutation(lakeFormationDataPermissionAsset).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3SnapshotAsset s3SnapshotAsset;

        private RedshiftDataShareAsset redshiftDataShareAsset;

        private ApiGatewayApiAsset apiGatewayApiAsset;

        private S3DataAccessAsset s3DataAccessAsset;

        private LakeFormationDataPermissionAsset lakeFormationDataPermissionAsset;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetDetails model) {
            s3SnapshotAsset(model.s3SnapshotAsset);
            redshiftDataShareAsset(model.redshiftDataShareAsset);
            apiGatewayApiAsset(model.apiGatewayApiAsset);
            s3DataAccessAsset(model.s3DataAccessAsset);
            lakeFormationDataPermissionAsset(model.lakeFormationDataPermissionAsset);
        }

        public final S3SnapshotAsset.Builder getS3SnapshotAsset() {
            return s3SnapshotAsset != null ? s3SnapshotAsset.toBuilder() : null;
        }

        public final void setS3SnapshotAsset(S3SnapshotAsset.BuilderImpl s3SnapshotAsset) {
            this.s3SnapshotAsset = s3SnapshotAsset != null ? s3SnapshotAsset.build() : null;
        }

        @Override
        public final Builder s3SnapshotAsset(S3SnapshotAsset s3SnapshotAsset) {
            this.s3SnapshotAsset = s3SnapshotAsset;
            return this;
        }

        public final RedshiftDataShareAsset.Builder getRedshiftDataShareAsset() {
            return redshiftDataShareAsset != null ? redshiftDataShareAsset.toBuilder() : null;
        }

        public final void setRedshiftDataShareAsset(RedshiftDataShareAsset.BuilderImpl redshiftDataShareAsset) {
            this.redshiftDataShareAsset = redshiftDataShareAsset != null ? redshiftDataShareAsset.build() : null;
        }

        @Override
        public final Builder redshiftDataShareAsset(RedshiftDataShareAsset redshiftDataShareAsset) {
            this.redshiftDataShareAsset = redshiftDataShareAsset;
            return this;
        }

        public final ApiGatewayApiAsset.Builder getApiGatewayApiAsset() {
            return apiGatewayApiAsset != null ? apiGatewayApiAsset.toBuilder() : null;
        }

        public final void setApiGatewayApiAsset(ApiGatewayApiAsset.BuilderImpl apiGatewayApiAsset) {
            this.apiGatewayApiAsset = apiGatewayApiAsset != null ? apiGatewayApiAsset.build() : null;
        }

        @Override
        public final Builder apiGatewayApiAsset(ApiGatewayApiAsset apiGatewayApiAsset) {
            this.apiGatewayApiAsset = apiGatewayApiAsset;
            return this;
        }

        public final S3DataAccessAsset.Builder getS3DataAccessAsset() {
            return s3DataAccessAsset != null ? s3DataAccessAsset.toBuilder() : null;
        }

        public final void setS3DataAccessAsset(S3DataAccessAsset.BuilderImpl s3DataAccessAsset) {
            this.s3DataAccessAsset = s3DataAccessAsset != null ? s3DataAccessAsset.build() : null;
        }

        @Override
        public final Builder s3DataAccessAsset(S3DataAccessAsset s3DataAccessAsset) {
            this.s3DataAccessAsset = s3DataAccessAsset;
            return this;
        }

        public final LakeFormationDataPermissionAsset.Builder getLakeFormationDataPermissionAsset() {
            return lakeFormationDataPermissionAsset != null ? lakeFormationDataPermissionAsset.toBuilder() : null;
        }

        public final void setLakeFormationDataPermissionAsset(
                LakeFormationDataPermissionAsset.BuilderImpl lakeFormationDataPermissionAsset) {
            this.lakeFormationDataPermissionAsset = lakeFormationDataPermissionAsset != null ? lakeFormationDataPermissionAsset
                    .build() : null;
        }

        @Override
        public final Builder lakeFormationDataPermissionAsset(LakeFormationDataPermissionAsset lakeFormationDataPermissionAsset) {
            this.lakeFormationDataPermissionAsset = lakeFormationDataPermissionAsset;
            return this;
        }

        @Override
        public AssetDetails build() {
            return new AssetDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
