/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dataexchange.model.Action;
import software.amazon.awssdk.services.dataexchange.model.DataExchangeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEventActionRequest
extends DataExchangeRequest
implements ToCopyableBuilder<Builder, UpdateEventActionRequest> {
    private static final SdkField<Action> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Action").getter(UpdateEventActionRequest.getter(UpdateEventActionRequest::action)).setter(UpdateEventActionRequest.setter(Builder::action)).constructor(Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> EVENT_ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventActionId").getter(UpdateEventActionRequest.getter(UpdateEventActionRequest::eventActionId)).setter(UpdateEventActionRequest.setter(Builder::eventActionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("EventActionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, EVENT_ACTION_ID_FIELD));
    private final Action action;
    private final String eventActionId;

    private UpdateEventActionRequest(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.eventActionId = builder.eventActionId;
    }

    public final Action action() {
        return this.action;
    }

    public final String eventActionId() {
        return this.eventActionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventActionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEventActionRequest)) {
            return false;
        }
        UpdateEventActionRequest other = (UpdateEventActionRequest)((Object)obj);
        return Objects.equals(this.action(), other.action()) && Objects.equals(this.eventActionId(), other.eventActionId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEventActionRequest").add("Action", (Object)this.action()).add("EventActionId", (Object)this.eventActionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "EventActionId": {
                return Optional.ofNullable(clazz.cast(this.eventActionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEventActionRequest, T> g) {
        return obj -> g.apply((UpdateEventActionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataExchangeRequest.BuilderImpl
    implements Builder {
        private Action action;
        private String eventActionId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEventActionRequest model) {
            super(model);
            this.action(model.action);
            this.eventActionId(model.eventActionId);
        }

        public final Action.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        public final void setAction(Action.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        @Transient
        public final Builder action(Action action) {
            this.action = action;
            return this;
        }

        public final String getEventActionId() {
            return this.eventActionId;
        }

        public final void setEventActionId(String eventActionId) {
            this.eventActionId = eventActionId;
        }

        @Override
        @Transient
        public final Builder eventActionId(String eventActionId) {
            this.eventActionId = eventActionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEventActionRequest build() {
            return new UpdateEventActionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataExchangeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEventActionRequest> {
        public Builder action(Action var1);

        default public Builder action(Consumer<Action.Builder> action) {
            return this.action((Action)((Action.Builder)Action.builder().applyMutation(action)).build());
        }

        public Builder eventActionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

