/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dataexchange.model.ApiGatewayApiAsset;
import software.amazon.awssdk.services.dataexchange.model.RedshiftDataShareAsset;
import software.amazon.awssdk.services.dataexchange.model.S3SnapshotAsset;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetDetails> {
    private static final SdkField<S3SnapshotAsset> S3_SNAPSHOT_ASSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3SnapshotAsset").getter(AssetDetails.getter(AssetDetails::s3SnapshotAsset)).setter(AssetDetails.setter(Builder::s3SnapshotAsset)).constructor(S3SnapshotAsset::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3SnapshotAsset").build()}).build();
    private static final SdkField<RedshiftDataShareAsset> REDSHIFT_DATA_SHARE_ASSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RedshiftDataShareAsset").getter(AssetDetails.getter(AssetDetails::redshiftDataShareAsset)).setter(AssetDetails.setter(Builder::redshiftDataShareAsset)).constructor(RedshiftDataShareAsset::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftDataShareAsset").build()}).build();
    private static final SdkField<ApiGatewayApiAsset> API_GATEWAY_API_ASSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApiGatewayApiAsset").getter(AssetDetails.getter(AssetDetails::apiGatewayApiAsset)).setter(AssetDetails.setter(Builder::apiGatewayApiAsset)).constructor(ApiGatewayApiAsset::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiGatewayApiAsset").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_SNAPSHOT_ASSET_FIELD, REDSHIFT_DATA_SHARE_ASSET_FIELD, API_GATEWAY_API_ASSET_FIELD));
    private static final long serialVersionUID = 1L;
    private final S3SnapshotAsset s3SnapshotAsset;
    private final RedshiftDataShareAsset redshiftDataShareAsset;
    private final ApiGatewayApiAsset apiGatewayApiAsset;

    private AssetDetails(BuilderImpl builder) {
        this.s3SnapshotAsset = builder.s3SnapshotAsset;
        this.redshiftDataShareAsset = builder.redshiftDataShareAsset;
        this.apiGatewayApiAsset = builder.apiGatewayApiAsset;
    }

    public final S3SnapshotAsset s3SnapshotAsset() {
        return this.s3SnapshotAsset;
    }

    public final RedshiftDataShareAsset redshiftDataShareAsset() {
        return this.redshiftDataShareAsset;
    }

    public final ApiGatewayApiAsset apiGatewayApiAsset() {
        return this.apiGatewayApiAsset;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3SnapshotAsset());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftDataShareAsset());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiGatewayApiAsset());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetDetails)) {
            return false;
        }
        AssetDetails other = (AssetDetails)obj;
        return Objects.equals(this.s3SnapshotAsset(), other.s3SnapshotAsset()) && Objects.equals(this.redshiftDataShareAsset(), other.redshiftDataShareAsset()) && Objects.equals(this.apiGatewayApiAsset(), other.apiGatewayApiAsset());
    }

    public final String toString() {
        return ToString.builder((String)"AssetDetails").add("S3SnapshotAsset", (Object)this.s3SnapshotAsset()).add("RedshiftDataShareAsset", (Object)this.redshiftDataShareAsset()).add("ApiGatewayApiAsset", (Object)this.apiGatewayApiAsset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3SnapshotAsset": {
                return Optional.ofNullable(clazz.cast(this.s3SnapshotAsset()));
            }
            case "RedshiftDataShareAsset": {
                return Optional.ofNullable(clazz.cast(this.redshiftDataShareAsset()));
            }
            case "ApiGatewayApiAsset": {
                return Optional.ofNullable(clazz.cast(this.apiGatewayApiAsset()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetDetails, T> g) {
        return obj -> g.apply((AssetDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3SnapshotAsset s3SnapshotAsset;
        private RedshiftDataShareAsset redshiftDataShareAsset;
        private ApiGatewayApiAsset apiGatewayApiAsset;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetDetails model) {
            this.s3SnapshotAsset(model.s3SnapshotAsset);
            this.redshiftDataShareAsset(model.redshiftDataShareAsset);
            this.apiGatewayApiAsset(model.apiGatewayApiAsset);
        }

        public final S3SnapshotAsset.Builder getS3SnapshotAsset() {
            return this.s3SnapshotAsset != null ? this.s3SnapshotAsset.toBuilder() : null;
        }

        public final void setS3SnapshotAsset(S3SnapshotAsset.BuilderImpl s3SnapshotAsset) {
            this.s3SnapshotAsset = s3SnapshotAsset != null ? s3SnapshotAsset.build() : null;
        }

        @Override
        public final Builder s3SnapshotAsset(S3SnapshotAsset s3SnapshotAsset) {
            this.s3SnapshotAsset = s3SnapshotAsset;
            return this;
        }

        public final RedshiftDataShareAsset.Builder getRedshiftDataShareAsset() {
            return this.redshiftDataShareAsset != null ? this.redshiftDataShareAsset.toBuilder() : null;
        }

        public final void setRedshiftDataShareAsset(RedshiftDataShareAsset.BuilderImpl redshiftDataShareAsset) {
            this.redshiftDataShareAsset = redshiftDataShareAsset != null ? redshiftDataShareAsset.build() : null;
        }

        @Override
        public final Builder redshiftDataShareAsset(RedshiftDataShareAsset redshiftDataShareAsset) {
            this.redshiftDataShareAsset = redshiftDataShareAsset;
            return this;
        }

        public final ApiGatewayApiAsset.Builder getApiGatewayApiAsset() {
            return this.apiGatewayApiAsset != null ? this.apiGatewayApiAsset.toBuilder() : null;
        }

        public final void setApiGatewayApiAsset(ApiGatewayApiAsset.BuilderImpl apiGatewayApiAsset) {
            this.apiGatewayApiAsset = apiGatewayApiAsset != null ? apiGatewayApiAsset.build() : null;
        }

        @Override
        public final Builder apiGatewayApiAsset(ApiGatewayApiAsset apiGatewayApiAsset) {
            this.apiGatewayApiAsset = apiGatewayApiAsset;
            return this;
        }

        public AssetDetails build() {
            return new AssetDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetDetails> {
        public Builder s3SnapshotAsset(S3SnapshotAsset var1);

        default public Builder s3SnapshotAsset(Consumer<S3SnapshotAsset.Builder> s3SnapshotAsset) {
            return this.s3SnapshotAsset((S3SnapshotAsset)((S3SnapshotAsset.Builder)S3SnapshotAsset.builder().applyMutation(s3SnapshotAsset)).build());
        }

        public Builder redshiftDataShareAsset(RedshiftDataShareAsset var1);

        default public Builder redshiftDataShareAsset(Consumer<RedshiftDataShareAsset.Builder> redshiftDataShareAsset) {
            return this.redshiftDataShareAsset((RedshiftDataShareAsset)((RedshiftDataShareAsset.Builder)RedshiftDataShareAsset.builder().applyMutation(redshiftDataShareAsset)).build());
        }

        public Builder apiGatewayApiAsset(ApiGatewayApiAsset var1);

        default public Builder apiGatewayApiAsset(Consumer<ApiGatewayApiAsset.Builder> apiGatewayApiAsset) {
            return this.apiGatewayApiAsset((ApiGatewayApiAsset)((ApiGatewayApiAsset.Builder)ApiGatewayApiAsset.builder().applyMutation(apiGatewayApiAsset)).build());
        }
    }
}

