/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dataexchange.model.ProtocolType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApiGatewayApiAsset
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApiGatewayApiAsset> {
    private static final SdkField<String> API_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiDescription").getter(ApiGatewayApiAsset.getter(ApiGatewayApiAsset::apiDescription)).setter(ApiGatewayApiAsset.setter(Builder::apiDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiDescription").build()}).build();
    private static final SdkField<String> API_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiEndpoint").getter(ApiGatewayApiAsset.getter(ApiGatewayApiAsset::apiEndpoint)).setter(ApiGatewayApiAsset.setter(Builder::apiEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiEndpoint").build()}).build();
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiId").getter(ApiGatewayApiAsset.getter(ApiGatewayApiAsset::apiId)).setter(ApiGatewayApiAsset.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiId").build()}).build();
    private static final SdkField<String> API_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiKey").getter(ApiGatewayApiAsset.getter(ApiGatewayApiAsset::apiKey)).setter(ApiGatewayApiAsset.setter(Builder::apiKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiKey").build()}).build();
    private static final SdkField<String> API_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiName").getter(ApiGatewayApiAsset.getter(ApiGatewayApiAsset::apiName)).setter(ApiGatewayApiAsset.setter(Builder::apiName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiName").build()}).build();
    private static final SdkField<String> API_SPECIFICATION_DOWNLOAD_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiSpecificationDownloadUrl").getter(ApiGatewayApiAsset.getter(ApiGatewayApiAsset::apiSpecificationDownloadUrl)).setter(ApiGatewayApiAsset.setter(Builder::apiSpecificationDownloadUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiSpecificationDownloadUrl").build()}).build();
    private static final SdkField<Instant> API_SPECIFICATION_DOWNLOAD_URL_EXPIRES_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ApiSpecificationDownloadUrlExpiresAt").getter(ApiGatewayApiAsset.getter(ApiGatewayApiAsset::apiSpecificationDownloadUrlExpiresAt)).setter(ApiGatewayApiAsset.setter(Builder::apiSpecificationDownloadUrlExpiresAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiSpecificationDownloadUrlExpiresAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> PROTOCOL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProtocolType").getter(ApiGatewayApiAsset.getter(ApiGatewayApiAsset::protocolTypeAsString)).setter(ApiGatewayApiAsset.setter(Builder::protocolType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtocolType").build()}).build();
    private static final SdkField<String> STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Stage").getter(ApiGatewayApiAsset.getter(ApiGatewayApiAsset::stage)).setter(ApiGatewayApiAsset.setter(Builder::stage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_DESCRIPTION_FIELD, API_ENDPOINT_FIELD, API_ID_FIELD, API_KEY_FIELD, API_NAME_FIELD, API_SPECIFICATION_DOWNLOAD_URL_FIELD, API_SPECIFICATION_DOWNLOAD_URL_EXPIRES_AT_FIELD, PROTOCOL_TYPE_FIELD, STAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String apiDescription;
    private final String apiEndpoint;
    private final String apiId;
    private final String apiKey;
    private final String apiName;
    private final String apiSpecificationDownloadUrl;
    private final Instant apiSpecificationDownloadUrlExpiresAt;
    private final String protocolType;
    private final String stage;

    private ApiGatewayApiAsset(BuilderImpl builder) {
        this.apiDescription = builder.apiDescription;
        this.apiEndpoint = builder.apiEndpoint;
        this.apiId = builder.apiId;
        this.apiKey = builder.apiKey;
        this.apiName = builder.apiName;
        this.apiSpecificationDownloadUrl = builder.apiSpecificationDownloadUrl;
        this.apiSpecificationDownloadUrlExpiresAt = builder.apiSpecificationDownloadUrlExpiresAt;
        this.protocolType = builder.protocolType;
        this.stage = builder.stage;
    }

    public final String apiDescription() {
        return this.apiDescription;
    }

    public final String apiEndpoint() {
        return this.apiEndpoint;
    }

    public final String apiId() {
        return this.apiId;
    }

    public final String apiKey() {
        return this.apiKey;
    }

    public final String apiName() {
        return this.apiName;
    }

    public final String apiSpecificationDownloadUrl() {
        return this.apiSpecificationDownloadUrl;
    }

    public final Instant apiSpecificationDownloadUrlExpiresAt() {
        return this.apiSpecificationDownloadUrlExpiresAt;
    }

    public final ProtocolType protocolType() {
        return ProtocolType.fromValue(this.protocolType);
    }

    public final String protocolTypeAsString() {
        return this.protocolType;
    }

    public final String stage() {
        return this.stage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiName());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiSpecificationDownloadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiSpecificationDownloadUrlExpiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiGatewayApiAsset)) {
            return false;
        }
        ApiGatewayApiAsset other = (ApiGatewayApiAsset)obj;
        return Objects.equals(this.apiDescription(), other.apiDescription()) && Objects.equals(this.apiEndpoint(), other.apiEndpoint()) && Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.apiKey(), other.apiKey()) && Objects.equals(this.apiName(), other.apiName()) && Objects.equals(this.apiSpecificationDownloadUrl(), other.apiSpecificationDownloadUrl()) && Objects.equals(this.apiSpecificationDownloadUrlExpiresAt(), other.apiSpecificationDownloadUrlExpiresAt()) && Objects.equals(this.protocolTypeAsString(), other.protocolTypeAsString()) && Objects.equals(this.stage(), other.stage());
    }

    public final String toString() {
        return ToString.builder((String)"ApiGatewayApiAsset").add("ApiDescription", (Object)this.apiDescription()).add("ApiEndpoint", (Object)this.apiEndpoint()).add("ApiId", (Object)this.apiId()).add("ApiKey", (Object)this.apiKey()).add("ApiName", (Object)this.apiName()).add("ApiSpecificationDownloadUrl", (Object)this.apiSpecificationDownloadUrl()).add("ApiSpecificationDownloadUrlExpiresAt", (Object)this.apiSpecificationDownloadUrlExpiresAt()).add("ProtocolType", (Object)this.protocolTypeAsString()).add("Stage", (Object)this.stage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiDescription": {
                return Optional.ofNullable(clazz.cast(this.apiDescription()));
            }
            case "ApiEndpoint": {
                return Optional.ofNullable(clazz.cast(this.apiEndpoint()));
            }
            case "ApiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "ApiKey": {
                return Optional.ofNullable(clazz.cast(this.apiKey()));
            }
            case "ApiName": {
                return Optional.ofNullable(clazz.cast(this.apiName()));
            }
            case "ApiSpecificationDownloadUrl": {
                return Optional.ofNullable(clazz.cast(this.apiSpecificationDownloadUrl()));
            }
            case "ApiSpecificationDownloadUrlExpiresAt": {
                return Optional.ofNullable(clazz.cast(this.apiSpecificationDownloadUrlExpiresAt()));
            }
            case "ProtocolType": {
                return Optional.ofNullable(clazz.cast(this.protocolTypeAsString()));
            }
            case "Stage": {
                return Optional.ofNullable(clazz.cast(this.stage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApiGatewayApiAsset, T> g) {
        return obj -> g.apply((ApiGatewayApiAsset)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String apiDescription;
        private String apiEndpoint;
        private String apiId;
        private String apiKey;
        private String apiName;
        private String apiSpecificationDownloadUrl;
        private Instant apiSpecificationDownloadUrlExpiresAt;
        private String protocolType;
        private String stage;

        private BuilderImpl() {
        }

        private BuilderImpl(ApiGatewayApiAsset model) {
            this.apiDescription(model.apiDescription);
            this.apiEndpoint(model.apiEndpoint);
            this.apiId(model.apiId);
            this.apiKey(model.apiKey);
            this.apiName(model.apiName);
            this.apiSpecificationDownloadUrl(model.apiSpecificationDownloadUrl);
            this.apiSpecificationDownloadUrlExpiresAt(model.apiSpecificationDownloadUrlExpiresAt);
            this.protocolType(model.protocolType);
            this.stage(model.stage);
        }

        public final String getApiDescription() {
            return this.apiDescription;
        }

        public final void setApiDescription(String apiDescription) {
            this.apiDescription = apiDescription;
        }

        @Override
        @Transient
        public final Builder apiDescription(String apiDescription) {
            this.apiDescription = apiDescription;
            return this;
        }

        public final String getApiEndpoint() {
            return this.apiEndpoint;
        }

        public final void setApiEndpoint(String apiEndpoint) {
            this.apiEndpoint = apiEndpoint;
        }

        @Override
        @Transient
        public final Builder apiEndpoint(String apiEndpoint) {
            this.apiEndpoint = apiEndpoint;
            return this;
        }

        public final String getApiId() {
            return this.apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        @Transient
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getApiKey() {
            return this.apiKey;
        }

        public final void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        @Override
        @Transient
        public final Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public final String getApiName() {
            return this.apiName;
        }

        public final void setApiName(String apiName) {
            this.apiName = apiName;
        }

        @Override
        @Transient
        public final Builder apiName(String apiName) {
            this.apiName = apiName;
            return this;
        }

        public final String getApiSpecificationDownloadUrl() {
            return this.apiSpecificationDownloadUrl;
        }

        public final void setApiSpecificationDownloadUrl(String apiSpecificationDownloadUrl) {
            this.apiSpecificationDownloadUrl = apiSpecificationDownloadUrl;
        }

        @Override
        @Transient
        public final Builder apiSpecificationDownloadUrl(String apiSpecificationDownloadUrl) {
            this.apiSpecificationDownloadUrl = apiSpecificationDownloadUrl;
            return this;
        }

        public final Instant getApiSpecificationDownloadUrlExpiresAt() {
            return this.apiSpecificationDownloadUrlExpiresAt;
        }

        public final void setApiSpecificationDownloadUrlExpiresAt(Instant apiSpecificationDownloadUrlExpiresAt) {
            this.apiSpecificationDownloadUrlExpiresAt = apiSpecificationDownloadUrlExpiresAt;
        }

        @Override
        @Transient
        public final Builder apiSpecificationDownloadUrlExpiresAt(Instant apiSpecificationDownloadUrlExpiresAt) {
            this.apiSpecificationDownloadUrlExpiresAt = apiSpecificationDownloadUrlExpiresAt;
            return this;
        }

        public final String getProtocolType() {
            return this.protocolType;
        }

        public final void setProtocolType(String protocolType) {
            this.protocolType = protocolType;
        }

        @Override
        @Transient
        public final Builder protocolType(String protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        @Override
        @Transient
        public final Builder protocolType(ProtocolType protocolType) {
            this.protocolType(protocolType == null ? null : protocolType.toString());
            return this;
        }

        public final String getStage() {
            return this.stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        @Transient
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        public ApiGatewayApiAsset build() {
            return new ApiGatewayApiAsset(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApiGatewayApiAsset> {
        public Builder apiDescription(String var1);

        public Builder apiEndpoint(String var1);

        public Builder apiId(String var1);

        public Builder apiKey(String var1);

        public Builder apiName(String var1);

        public Builder apiSpecificationDownloadUrl(String var1);

        public Builder apiSpecificationDownloadUrlExpiresAt(Instant var1);

        public Builder protocolType(String var1);

        public Builder protocolType(ProtocolType var1);

        public Builder stage(String var1);
    }
}

