/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJobsResponse extends DataExchangeResponse implements
        ToCopyableBuilder<ListJobsResponse.Builder, ListJobsResponse> {
    private static final SdkField<List<JobEntry>> JOBS_FIELD = SdkField
            .<List<JobEntry>> builder(MarshallingType.LIST)
            .memberName("Jobs")
            .getter(getter(ListJobsResponse::jobs))
            .setter(setter(Builder::jobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Jobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOBS_FIELD, NEXT_TOKEN_FIELD));

    private final List<JobEntry> jobs;

    private final String nextToken;

    private ListJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobs = builder.jobs;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Jobs property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasJobs() {
        return jobs != null && !(jobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The jobs listed by the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasJobs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The jobs listed by the request.
     */
    public final List<JobEntry> jobs() {
        return jobs;
    }

    /**
     * <p>
     * The token value retrieved from a previous call to access the next page of results.
     * </p>
     * 
     * @return The token value retrieved from a previous call to access the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasJobs() ? jobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsResponse)) {
            return false;
        }
        ListJobsResponse other = (ListJobsResponse) obj;
        return hasJobs() == other.hasJobs() && Objects.equals(jobs(), other.jobs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListJobsResponse").add("Jobs", hasJobs() ? jobs() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Jobs":
            return Optional.ofNullable(clazz.cast(jobs()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobsResponse, T> g) {
        return obj -> g.apply((ListJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataExchangeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListJobsResponse> {
        /**
         * <p>
         * The jobs listed by the request.
         * </p>
         * 
         * @param jobs
         *        The jobs listed by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(Collection<JobEntry> jobs);

        /**
         * <p>
         * The jobs listed by the request.
         * </p>
         * 
         * @param jobs
         *        The jobs listed by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(JobEntry... jobs);

        /**
         * <p>
         * The jobs listed by the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobEntry>.Builder} avoiding the need to
         * create one manually via {@link List<JobEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobEntry>.Builder#build()} is called immediately and its
         * result is passed to {@link #jobs(List<JobEntry>)}.
         * 
         * @param jobs
         *        a consumer that will call methods on {@link List<JobEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobs(List<JobEntry>)
         */
        Builder jobs(Consumer<JobEntry.Builder>... jobs);

        /**
         * <p>
         * The token value retrieved from a previous call to access the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token value retrieved from a previous call to access the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DataExchangeResponse.BuilderImpl implements Builder {
        private List<JobEntry> jobs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsResponse model) {
            super(model);
            jobs(model.jobs);
            nextToken(model.nextToken);
        }

        public final Collection<JobEntry.Builder> getJobs() {
            if (jobs instanceof SdkAutoConstructList) {
                return null;
            }
            return jobs != null ? jobs.stream().map(JobEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobs(Collection<JobEntry> jobs) {
            this.jobs = ListOfJobEntryCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(JobEntry... jobs) {
            jobs(Arrays.asList(jobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Consumer<JobEntry.Builder>... jobs) {
            jobs(Stream.of(jobs).map(c -> JobEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobs(Collection<JobEntry.BuilderImpl> jobs) {
            this.jobs = ListOfJobEntryCopier.copyFromBuilder(jobs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListJobsResponse build() {
            return new ListJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
