/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.dataexchange.model.AccessDeniedException;
import software.amazon.awssdk.services.dataexchange.model.CancelJobRequest;
import software.amazon.awssdk.services.dataexchange.model.CancelJobResponse;
import software.amazon.awssdk.services.dataexchange.model.ConflictException;
import software.amazon.awssdk.services.dataexchange.model.CreateDataSetRequest;
import software.amazon.awssdk.services.dataexchange.model.CreateDataSetResponse;
import software.amazon.awssdk.services.dataexchange.model.CreateJobRequest;
import software.amazon.awssdk.services.dataexchange.model.CreateJobResponse;
import software.amazon.awssdk.services.dataexchange.model.CreateRevisionRequest;
import software.amazon.awssdk.services.dataexchange.model.CreateRevisionResponse;
import software.amazon.awssdk.services.dataexchange.model.DataExchangeException;
import software.amazon.awssdk.services.dataexchange.model.DeleteAssetRequest;
import software.amazon.awssdk.services.dataexchange.model.DeleteAssetResponse;
import software.amazon.awssdk.services.dataexchange.model.DeleteDataSetRequest;
import software.amazon.awssdk.services.dataexchange.model.DeleteDataSetResponse;
import software.amazon.awssdk.services.dataexchange.model.DeleteRevisionRequest;
import software.amazon.awssdk.services.dataexchange.model.DeleteRevisionResponse;
import software.amazon.awssdk.services.dataexchange.model.GetAssetRequest;
import software.amazon.awssdk.services.dataexchange.model.GetAssetResponse;
import software.amazon.awssdk.services.dataexchange.model.GetDataSetRequest;
import software.amazon.awssdk.services.dataexchange.model.GetDataSetResponse;
import software.amazon.awssdk.services.dataexchange.model.GetJobRequest;
import software.amazon.awssdk.services.dataexchange.model.GetJobResponse;
import software.amazon.awssdk.services.dataexchange.model.GetRevisionRequest;
import software.amazon.awssdk.services.dataexchange.model.GetRevisionResponse;
import software.amazon.awssdk.services.dataexchange.model.InternalServerException;
import software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsRequest;
import software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsResponse;
import software.amazon.awssdk.services.dataexchange.model.ListDataSetsRequest;
import software.amazon.awssdk.services.dataexchange.model.ListDataSetsResponse;
import software.amazon.awssdk.services.dataexchange.model.ListJobsRequest;
import software.amazon.awssdk.services.dataexchange.model.ListJobsResponse;
import software.amazon.awssdk.services.dataexchange.model.ListRevisionAssetsRequest;
import software.amazon.awssdk.services.dataexchange.model.ListRevisionAssetsResponse;
import software.amazon.awssdk.services.dataexchange.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.dataexchange.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.dataexchange.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dataexchange.model.ServiceLimitExceededException;
import software.amazon.awssdk.services.dataexchange.model.StartJobRequest;
import software.amazon.awssdk.services.dataexchange.model.StartJobResponse;
import software.amazon.awssdk.services.dataexchange.model.TagResourceRequest;
import software.amazon.awssdk.services.dataexchange.model.TagResourceResponse;
import software.amazon.awssdk.services.dataexchange.model.ThrottlingException;
import software.amazon.awssdk.services.dataexchange.model.UntagResourceRequest;
import software.amazon.awssdk.services.dataexchange.model.UntagResourceResponse;
import software.amazon.awssdk.services.dataexchange.model.UpdateAssetRequest;
import software.amazon.awssdk.services.dataexchange.model.UpdateAssetResponse;
import software.amazon.awssdk.services.dataexchange.model.UpdateDataSetRequest;
import software.amazon.awssdk.services.dataexchange.model.UpdateDataSetResponse;
import software.amazon.awssdk.services.dataexchange.model.UpdateRevisionRequest;
import software.amazon.awssdk.services.dataexchange.model.UpdateRevisionResponse;
import software.amazon.awssdk.services.dataexchange.model.ValidationException;
import software.amazon.awssdk.services.dataexchange.paginators.ListDataSetRevisionsIterable;
import software.amazon.awssdk.services.dataexchange.paginators.ListDataSetsIterable;
import software.amazon.awssdk.services.dataexchange.paginators.ListJobsIterable;
import software.amazon.awssdk.services.dataexchange.paginators.ListRevisionAssetsIterable;

/**
 * Service client for accessing AWS Data Exchange. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * AWS Data Exchange is a service that makes it easy for AWS customers to exchange data in the cloud. You can use the
 * AWS Data Exchange APIs to create, update, manage, and access file-based data set in the AWS Cloud.
 * </p>
 * <p>
 * As a subscriber, you can view and access the data sets that you have an entitlement to through a subscription. You
 * can use the APIS to download or copy your entitled data sets to Amazon S3 for use across a variety of AWS analytics
 * and machine learning services.
 * </p>
 * <p>
 * As a provider, you can create and manage your data sets that you would like to publish to a product. Being able to
 * package and provide your data sets into products requires a few steps to determine eligibility. For more information,
 * visit the AWS Data Exchange User Guide.
 * </p>
 * <p>
 * A data set is a collection of data that can be changed or updated over time. Data sets can be updated using
 * revisions, which represent a new version or incremental change to a data set. A revision contains one or more assets.
 * An asset in AWS Data Exchange is a piece of data that can be stored as an Amazon S3 object. The asset can be a
 * structured data file, an image file, or some other data file. Jobs are asynchronous import or export operations used
 * to create or copy assets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface DataExchangeClient extends SdkClient {
    String SERVICE_NAME = "dataexchange";

    /**
     * Create a {@link DataExchangeClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static DataExchangeClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link DataExchangeClient}.
     */
    static DataExchangeClientBuilder builder() {
        return new DefaultDataExchangeClientBuilder();
    }

    /**
     * <p>
     * This operation cancels a job. Jobs can be cancelled only when they are in the WAITING state.
     * </p>
     *
     * @param cancelJobRequest
     * @return Result of the CancelJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws ConflictException
     *         409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.CancelJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/CancelJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelJobResponse cancelJob(CancelJobRequest cancelJobRequest) throws ResourceNotFoundException, ThrottlingException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            DataExchangeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation cancels a job. Jobs can be cancelled only when they are in the WAITING state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelJobRequest.Builder} avoiding the need to
     * create one manually via {@link CancelJobRequest#builder()}
     * </p>
     *
     * @param cancelJobRequest
     *        A {@link Consumer} that will call methods on {@link CancelJobRequest.Builder} to create a request.
     * @return Result of the CancelJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws ConflictException
     *         409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.CancelJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/CancelJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelJobResponse cancelJob(Consumer<CancelJobRequest.Builder> cancelJobRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, InternalServerException, ConflictException, AwsServiceException,
            SdkClientException, DataExchangeException {
        return cancelJob(CancelJobRequest.builder().applyMutation(cancelJobRequest).build());
    }

    /**
     * <p>
     * This operation creates a data set.
     * </p>
     *
     * @param createDataSetRequest
     *        The request body for CreateDataSet.
     * @return Result of the CreateDataSet operation returned by the service.
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws ServiceLimitExceededException
     *         402 response
     * @throws AccessDeniedException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.CreateDataSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/CreateDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDataSetResponse createDataSet(CreateDataSetRequest createDataSetRequest) throws ThrottlingException,
            ValidationException, InternalServerException, ServiceLimitExceededException, AccessDeniedException,
            AwsServiceException, SdkClientException, DataExchangeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation creates a data set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataSetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDataSetRequest#builder()}
     * </p>
     *
     * @param createDataSetRequest
     *        A {@link Consumer} that will call methods on {@link CreateDataSetRequest.Builder} to create a request. The
     *        request body for CreateDataSet.
     * @return Result of the CreateDataSet operation returned by the service.
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws ServiceLimitExceededException
     *         402 response
     * @throws AccessDeniedException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.CreateDataSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/CreateDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDataSetResponse createDataSet(Consumer<CreateDataSetRequest.Builder> createDataSetRequest)
            throws ThrottlingException, ValidationException, InternalServerException, ServiceLimitExceededException,
            AccessDeniedException, AwsServiceException, SdkClientException, DataExchangeException {
        return createDataSet(CreateDataSetRequest.builder().applyMutation(createDataSetRequest).build());
    }

    /**
     * <p>
     * This operation creates a job.
     * </p>
     *
     * @param createJobRequest
     *        The request body for CreateJob.
     * @return Result of the CreateJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws AccessDeniedException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.CreateJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/CreateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateJobResponse createJob(CreateJobRequest createJobRequest) throws ResourceNotFoundException, ThrottlingException,
            ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            DataExchangeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation creates a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateJobRequest.Builder} avoiding the need to
     * create one manually via {@link CreateJobRequest#builder()}
     * </p>
     *
     * @param createJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateJobRequest.Builder} to create a request. The
     *        request body for CreateJob.
     * @return Result of the CreateJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws AccessDeniedException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.CreateJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/CreateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateJobResponse createJob(Consumer<CreateJobRequest.Builder> createJobRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException,
            SdkClientException, DataExchangeException {
        return createJob(CreateJobRequest.builder().applyMutation(createJobRequest).build());
    }

    /**
     * <p>
     * This operation creates a revision for a data set.
     * </p>
     *
     * @param createRevisionRequest
     *        The request body for CreateRevision.
     * @return Result of the CreateRevision operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws AccessDeniedException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.CreateRevision
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/CreateRevision" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateRevisionResponse createRevision(CreateRevisionRequest createRevisionRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException,
            SdkClientException, DataExchangeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation creates a revision for a data set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRevisionRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRevisionRequest#builder()}
     * </p>
     *
     * @param createRevisionRequest
     *        A {@link Consumer} that will call methods on {@link CreateRevisionRequest.Builder} to create a request.
     *        The request body for CreateRevision.
     * @return Result of the CreateRevision operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws AccessDeniedException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.CreateRevision
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/CreateRevision" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateRevisionResponse createRevision(Consumer<CreateRevisionRequest.Builder> createRevisionRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException,
            AccessDeniedException, AwsServiceException, SdkClientException, DataExchangeException {
        return createRevision(CreateRevisionRequest.builder().applyMutation(createRevisionRequest).build());
    }

    /**
     * <p>
     * This operation deletes an asset.
     * </p>
     *
     * @param deleteAssetRequest
     * @return Result of the DeleteAsset operation returned by the service.
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws AccessDeniedException
     *         403 response
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ConflictException
     *         409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.DeleteAsset
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/DeleteAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAssetResponse deleteAsset(DeleteAssetRequest deleteAssetRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException,
            AwsServiceException, SdkClientException, DataExchangeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation deletes an asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAssetRequest#builder()}
     * </p>
     *
     * @param deleteAssetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAssetRequest.Builder} to create a request.
     * @return Result of the DeleteAsset operation returned by the service.
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws AccessDeniedException
     *         403 response
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ConflictException
     *         409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.DeleteAsset
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/DeleteAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAssetResponse deleteAsset(Consumer<DeleteAssetRequest.Builder> deleteAssetRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException,
            AwsServiceException, SdkClientException, DataExchangeException {
        return deleteAsset(DeleteAssetRequest.builder().applyMutation(deleteAssetRequest).build());
    }

    /**
     * <p>
     * This operation deletes a data set.
     * </p>
     *
     * @param deleteDataSetRequest
     * @return Result of the DeleteDataSet operation returned by the service.
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws AccessDeniedException
     *         403 response
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ConflictException
     *         409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.DeleteDataSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/DeleteDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDataSetResponse deleteDataSet(DeleteDataSetRequest deleteDataSetRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException,
            AwsServiceException, SdkClientException, DataExchangeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation deletes a data set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataSetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDataSetRequest#builder()}
     * </p>
     *
     * @param deleteDataSetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDataSetRequest.Builder} to create a request.
     * @return Result of the DeleteDataSet operation returned by the service.
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws AccessDeniedException
     *         403 response
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ConflictException
     *         409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.DeleteDataSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/DeleteDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDataSetResponse deleteDataSet(Consumer<DeleteDataSetRequest.Builder> deleteDataSetRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, ConflictException, AwsServiceException, SdkClientException, DataExchangeException {
        return deleteDataSet(DeleteDataSetRequest.builder().applyMutation(deleteDataSetRequest).build());
    }

    /**
     * <p>
     * This operation deletes a revision.
     * </p>
     *
     * @param deleteRevisionRequest
     * @return Result of the DeleteRevision operation returned by the service.
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws AccessDeniedException
     *         403 response
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ConflictException
     *         409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.DeleteRevision
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/DeleteRevision" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteRevisionResponse deleteRevision(DeleteRevisionRequest deleteRevisionRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException,
            AwsServiceException, SdkClientException, DataExchangeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation deletes a revision.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRevisionRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRevisionRequest#builder()}
     * </p>
     *
     * @param deleteRevisionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRevisionRequest.Builder} to create a request.
     * @return Result of the DeleteRevision operation returned by the service.
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws AccessDeniedException
     *         403 response
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ConflictException
     *         409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.DeleteRevision
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/DeleteRevision" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteRevisionResponse deleteRevision(Consumer<DeleteRevisionRequest.Builder> deleteRevisionRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, ConflictException, AwsServiceException, SdkClientException, DataExchangeException {
        return deleteRevision(DeleteRevisionRequest.builder().applyMutation(deleteRevisionRequest).build());
    }

    /**
     * <p>
     * This operation returns information about an asset.
     * </p>
     *
     * @param getAssetRequest
     * @return Result of the GetAsset operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.GetAsset
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/GetAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAssetResponse getAsset(GetAssetRequest getAssetRequest) throws ResourceNotFoundException, ThrottlingException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, DataExchangeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation returns information about an asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssetRequest.Builder} avoiding the need to
     * create one manually via {@link GetAssetRequest#builder()}
     * </p>
     *
     * @param getAssetRequest
     *        A {@link Consumer} that will call methods on {@link GetAssetRequest.Builder} to create a request.
     * @return Result of the GetAsset operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.GetAsset
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/GetAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAssetResponse getAsset(Consumer<GetAssetRequest.Builder> getAssetRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            DataExchangeException {
        return getAsset(GetAssetRequest.builder().applyMutation(getAssetRequest).build());
    }

    /**
     * <p>
     * This operation returns information about a data set.
     * </p>
     *
     * @param getDataSetRequest
     * @return Result of the GetDataSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.GetDataSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/GetDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDataSetResponse getDataSet(GetDataSetRequest getDataSetRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            DataExchangeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation returns information about a data set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataSetRequest.Builder} avoiding the need to
     * create one manually via {@link GetDataSetRequest#builder()}
     * </p>
     *
     * @param getDataSetRequest
     *        A {@link Consumer} that will call methods on {@link GetDataSetRequest.Builder} to create a request.
     * @return Result of the GetDataSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.GetDataSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/GetDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDataSetResponse getDataSet(Consumer<GetDataSetRequest.Builder> getDataSetRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, DataExchangeException {
        return getDataSet(GetDataSetRequest.builder().applyMutation(getDataSetRequest).build());
    }

    /**
     * <p>
     * This operation returns information about a job.
     * </p>
     *
     * @param getJobRequest
     * @return Result of the GetJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.GetJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobResponse getJob(GetJobRequest getJobRequest) throws ResourceNotFoundException, ThrottlingException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, DataExchangeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation returns information about a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobRequest.Builder} avoiding the need to create
     * one manually via {@link GetJobRequest#builder()}
     * </p>
     *
     * @param getJobRequest
     *        A {@link Consumer} that will call methods on {@link GetJobRequest.Builder} to create a request.
     * @return Result of the GetJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.GetJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobResponse getJob(Consumer<GetJobRequest.Builder> getJobRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            DataExchangeException {
        return getJob(GetJobRequest.builder().applyMutation(getJobRequest).build());
    }

    /**
     * <p>
     * This operation returns information about a revision.
     * </p>
     *
     * @param getRevisionRequest
     * @return Result of the GetRevision operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.GetRevision
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/GetRevision" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRevisionResponse getRevision(GetRevisionRequest getRevisionRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            DataExchangeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation returns information about a revision.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRevisionRequest.Builder} avoiding the need to
     * create one manually via {@link GetRevisionRequest#builder()}
     * </p>
     *
     * @param getRevisionRequest
     *        A {@link Consumer} that will call methods on {@link GetRevisionRequest.Builder} to create a request.
     * @return Result of the GetRevision operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.GetRevision
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/GetRevision" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRevisionResponse getRevision(Consumer<GetRevisionRequest.Builder> getRevisionRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, DataExchangeException {
        return getRevision(GetRevisionRequest.builder().applyMutation(getRevisionRequest).build());
    }

    /**
     * <p>
     * This operation lists a data set's revisions sorted by CreatedAt in descending order.
     * </p>
     *
     * @param listDataSetRevisionsRequest
     * @return Result of the ListDataSetRevisions operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.ListDataSetRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListDataSetRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataSetRevisionsResponse listDataSetRevisions(ListDataSetRevisionsRequest listDataSetRevisionsRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, DataExchangeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation lists a data set's revisions sorted by CreatedAt in descending order.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSetRevisionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataSetRevisionsRequest#builder()}
     * </p>
     *
     * @param listDataSetRevisionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDataSetRevisionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListDataSetRevisions operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.ListDataSetRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListDataSetRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataSetRevisionsResponse listDataSetRevisions(
            Consumer<ListDataSetRevisionsRequest.Builder> listDataSetRevisionsRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            DataExchangeException {
        return listDataSetRevisions(ListDataSetRevisionsRequest.builder().applyMutation(listDataSetRevisionsRequest).build());
    }

    /**
     * <p>
     * This operation lists a data set's revisions sorted by CreatedAt in descending order.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataSetRevisions(software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dataexchange.paginators.ListDataSetRevisionsIterable responses = client.listDataSetRevisionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.dataexchange.paginators.ListDataSetRevisionsIterable responses = client
     *             .listDataSetRevisionsPaginator(request);
     *     for (software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dataexchange.paginators.ListDataSetRevisionsIterable responses = client.listDataSetRevisionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSetRevisions(software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataSetRevisionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.ListDataSetRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListDataSetRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataSetRevisionsIterable listDataSetRevisionsPaginator(ListDataSetRevisionsRequest listDataSetRevisionsRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, DataExchangeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation lists a data set's revisions sorted by CreatedAt in descending order.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataSetRevisions(software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dataexchange.paginators.ListDataSetRevisionsIterable responses = client.listDataSetRevisionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.dataexchange.paginators.ListDataSetRevisionsIterable responses = client
     *             .listDataSetRevisionsPaginator(request);
     *     for (software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dataexchange.paginators.ListDataSetRevisionsIterable responses = client.listDataSetRevisionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSetRevisions(software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSetRevisionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataSetRevisionsRequest#builder()}
     * </p>
     *
     * @param listDataSetRevisionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDataSetRevisionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.ListDataSetRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListDataSetRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataSetRevisionsIterable listDataSetRevisionsPaginator(
            Consumer<ListDataSetRevisionsRequest.Builder> listDataSetRevisionsRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            DataExchangeException {
        return listDataSetRevisionsPaginator(ListDataSetRevisionsRequest.builder().applyMutation(listDataSetRevisionsRequest)
                .build());
    }

    /**
     * <p>
     * This operation lists your data sets. When listing by origin OWNED, results are sorted by CreatedAt in descending
     * order. When listing by origin ENTITLED, there is no order and the maxResults parameter is ignored.
     * </p>
     *
     * @param listDataSetsRequest
     * @return Result of the ListDataSets operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.ListDataSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListDataSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSetsResponse listDataSets(ListDataSetsRequest listDataSetsRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            DataExchangeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation lists your data sets. When listing by origin OWNED, results are sorted by CreatedAt in descending
     * order. When listing by origin ENTITLED, there is no order and the maxResults parameter is ignored.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDataSetsRequest#builder()}
     * </p>
     *
     * @param listDataSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListDataSetsRequest.Builder} to create a request.
     * @return Result of the ListDataSets operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.ListDataSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListDataSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSetsResponse listDataSets(Consumer<ListDataSetsRequest.Builder> listDataSetsRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, DataExchangeException {
        return listDataSets(ListDataSetsRequest.builder().applyMutation(listDataSetsRequest).build());
    }

    /**
     * <p>
     * This operation lists your data sets. When listing by origin OWNED, results are sorted by CreatedAt in descending
     * order. When listing by origin ENTITLED, there is no order and the maxResults parameter is ignored.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataSets(software.amazon.awssdk.services.dataexchange.model.ListDataSetsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dataexchange.paginators.ListDataSetsIterable responses = client.listDataSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.dataexchange.paginators.ListDataSetsIterable responses = client
     *             .listDataSetsPaginator(request);
     *     for (software.amazon.awssdk.services.dataexchange.model.ListDataSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dataexchange.paginators.ListDataSetsIterable responses = client.listDataSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSets(software.amazon.awssdk.services.dataexchange.model.ListDataSetsRequest)} operation.</b>
     * </p>
     *
     * @param listDataSetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.ListDataSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListDataSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSetsIterable listDataSetsPaginator(ListDataSetsRequest listDataSetsRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            DataExchangeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation lists your data sets. When listing by origin OWNED, results are sorted by CreatedAt in descending
     * order. When listing by origin ENTITLED, there is no order and the maxResults parameter is ignored.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataSets(software.amazon.awssdk.services.dataexchange.model.ListDataSetsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dataexchange.paginators.ListDataSetsIterable responses = client.listDataSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.dataexchange.paginators.ListDataSetsIterable responses = client
     *             .listDataSetsPaginator(request);
     *     for (software.amazon.awssdk.services.dataexchange.model.ListDataSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dataexchange.paginators.ListDataSetsIterable responses = client.listDataSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSets(software.amazon.awssdk.services.dataexchange.model.ListDataSetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDataSetsRequest#builder()}
     * </p>
     *
     * @param listDataSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListDataSetsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.ListDataSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListDataSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSetsIterable listDataSetsPaginator(Consumer<ListDataSetsRequest.Builder> listDataSetsRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, DataExchangeException {
        return listDataSetsPaginator(ListDataSetsRequest.builder().applyMutation(listDataSetsRequest).build());
    }

    /**
     * <p>
     * This operation lists your jobs sorted by CreatedAt in descending order.
     * </p>
     *
     * @param listJobsRequest
     * @return Result of the ListJobs operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.ListJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws ResourceNotFoundException, ThrottlingException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, DataExchangeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation lists your jobs sorted by CreatedAt in descending order.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobsRequest#builder()}
     * </p>
     *
     * @param listJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListJobsRequest.Builder} to create a request.
     * @return Result of the ListJobs operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.ListJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsResponse listJobs(Consumer<ListJobsRequest.Builder> listJobsRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            DataExchangeException {
        return listJobs(ListJobsRequest.builder().applyMutation(listJobsRequest).build());
    }

    /**
     * <p>
     * This operation lists your jobs sorted by CreatedAt in descending order.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listJobs(software.amazon.awssdk.services.dataexchange.model.ListJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dataexchange.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.dataexchange.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     *     for (software.amazon.awssdk.services.dataexchange.model.ListJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dataexchange.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobs(software.amazon.awssdk.services.dataexchange.model.ListJobsRequest)} operation.</b>
     * </p>
     *
     * @param listJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.ListJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsIterable listJobsPaginator(ListJobsRequest listJobsRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            DataExchangeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation lists your jobs sorted by CreatedAt in descending order.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listJobs(software.amazon.awssdk.services.dataexchange.model.ListJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dataexchange.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.dataexchange.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     *     for (software.amazon.awssdk.services.dataexchange.model.ListJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dataexchange.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobs(software.amazon.awssdk.services.dataexchange.model.ListJobsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobsRequest#builder()}
     * </p>
     *
     * @param listJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListJobsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.ListJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsIterable listJobsPaginator(Consumer<ListJobsRequest.Builder> listJobsRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, DataExchangeException {
        return listJobsPaginator(ListJobsRequest.builder().applyMutation(listJobsRequest).build());
    }

    /**
     * <p>
     * This operation lists a revision's assets sorted alphabetically in descending order.
     * </p>
     *
     * @param listRevisionAssetsRequest
     * @return Result of the ListRevisionAssets operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.ListRevisionAssets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListRevisionAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRevisionAssetsResponse listRevisionAssets(ListRevisionAssetsRequest listRevisionAssetsRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, DataExchangeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation lists a revision's assets sorted alphabetically in descending order.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRevisionAssetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRevisionAssetsRequest#builder()}
     * </p>
     *
     * @param listRevisionAssetsRequest
     *        A {@link Consumer} that will call methods on {@link ListRevisionAssetsRequest.Builder} to create a
     *        request.
     * @return Result of the ListRevisionAssets operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.ListRevisionAssets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListRevisionAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRevisionAssetsResponse listRevisionAssets(Consumer<ListRevisionAssetsRequest.Builder> listRevisionAssetsRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, DataExchangeException {
        return listRevisionAssets(ListRevisionAssetsRequest.builder().applyMutation(listRevisionAssetsRequest).build());
    }

    /**
     * <p>
     * This operation lists a revision's assets sorted alphabetically in descending order.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRevisionAssets(software.amazon.awssdk.services.dataexchange.model.ListRevisionAssetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dataexchange.paginators.ListRevisionAssetsIterable responses = client.listRevisionAssetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.dataexchange.paginators.ListRevisionAssetsIterable responses = client
     *             .listRevisionAssetsPaginator(request);
     *     for (software.amazon.awssdk.services.dataexchange.model.ListRevisionAssetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dataexchange.paginators.ListRevisionAssetsIterable responses = client.listRevisionAssetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRevisionAssets(software.amazon.awssdk.services.dataexchange.model.ListRevisionAssetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRevisionAssetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.ListRevisionAssets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListRevisionAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRevisionAssetsIterable listRevisionAssetsPaginator(ListRevisionAssetsRequest listRevisionAssetsRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, DataExchangeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation lists a revision's assets sorted alphabetically in descending order.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRevisionAssets(software.amazon.awssdk.services.dataexchange.model.ListRevisionAssetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dataexchange.paginators.ListRevisionAssetsIterable responses = client.listRevisionAssetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.dataexchange.paginators.ListRevisionAssetsIterable responses = client
     *             .listRevisionAssetsPaginator(request);
     *     for (software.amazon.awssdk.services.dataexchange.model.ListRevisionAssetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dataexchange.paginators.ListRevisionAssetsIterable responses = client.listRevisionAssetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRevisionAssets(software.amazon.awssdk.services.dataexchange.model.ListRevisionAssetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRevisionAssetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRevisionAssetsRequest#builder()}
     * </p>
     *
     * @param listRevisionAssetsRequest
     *        A {@link Consumer} that will call methods on {@link ListRevisionAssetsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.ListRevisionAssets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListRevisionAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRevisionAssetsIterable listRevisionAssetsPaginator(
            Consumer<ListRevisionAssetsRequest.Builder> listRevisionAssetsRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            DataExchangeException {
        return listRevisionAssetsPaginator(ListRevisionAssetsRequest.builder().applyMutation(listRevisionAssetsRequest).build());
    }

    /**
     * <p>
     * This operation lists the tags on the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws AwsServiceException, SdkClientException, DataExchangeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation lists the tags on the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws AwsServiceException,
            SdkClientException, DataExchangeException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * This operation starts a job.
     * </p>
     *
     * @param startJobRequest
     * @return Result of the StartJob operation returned by the service.
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws AccessDeniedException
     *         403 response
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ConflictException
     *         409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.StartJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/StartJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StartJobResponse startJob(StartJobRequest startJobRequest) throws ValidationException, InternalServerException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException, AwsServiceException,
            SdkClientException, DataExchangeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation starts a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartJobRequest.Builder} avoiding the need to
     * create one manually via {@link StartJobRequest#builder()}
     * </p>
     *
     * @param startJobRequest
     *        A {@link Consumer} that will call methods on {@link StartJobRequest.Builder} to create a request.
     * @return Result of the StartJob operation returned by the service.
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws AccessDeniedException
     *         403 response
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ConflictException
     *         409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.StartJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/StartJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StartJobResponse startJob(Consumer<StartJobRequest.Builder> startJobRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException,
            AwsServiceException, SdkClientException, DataExchangeException {
        return startJob(StartJobRequest.builder().applyMutation(startJobRequest).build());
    }

    /**
     * <p>
     * This operation tags a resource.
     * </p>
     *
     * @param tagResourceRequest
     *        The request body for TagResource.
     * @return Result of the TagResource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AwsServiceException,
            SdkClientException, DataExchangeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation tags a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request. The
     *        request body for TagResource.
     * @return Result of the TagResource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws AwsServiceException,
            SdkClientException, DataExchangeException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * This operation removes one or more tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AwsServiceException,
            SdkClientException, DataExchangeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation removes one or more tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws AwsServiceException, SdkClientException, DataExchangeException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * This operation updates an asset.
     * </p>
     *
     * @param updateAssetRequest
     *        The request body for UpdateAsset.
     * @return Result of the UpdateAsset operation returned by the service.
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws AccessDeniedException
     *         403 response
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ConflictException
     *         409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.UpdateAsset
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/UpdateAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAssetResponse updateAsset(UpdateAssetRequest updateAssetRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException,
            AwsServiceException, SdkClientException, DataExchangeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation updates an asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAssetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAssetRequest#builder()}
     * </p>
     *
     * @param updateAssetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAssetRequest.Builder} to create a request. The
     *        request body for UpdateAsset.
     * @return Result of the UpdateAsset operation returned by the service.
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws AccessDeniedException
     *         403 response
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ConflictException
     *         409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.UpdateAsset
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/UpdateAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAssetResponse updateAsset(Consumer<UpdateAssetRequest.Builder> updateAssetRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException,
            AwsServiceException, SdkClientException, DataExchangeException {
        return updateAsset(UpdateAssetRequest.builder().applyMutation(updateAssetRequest).build());
    }

    /**
     * <p>
     * This operation updates a data set.
     * </p>
     *
     * @param updateDataSetRequest
     *        The request body for UpdateDataSet.
     * @return Result of the UpdateDataSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws AccessDeniedException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.UpdateDataSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/UpdateDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDataSetResponse updateDataSet(UpdateDataSetRequest updateDataSetRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException,
            SdkClientException, DataExchangeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation updates a data set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataSetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateDataSetRequest#builder()}
     * </p>
     *
     * @param updateDataSetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDataSetRequest.Builder} to create a request. The
     *        request body for UpdateDataSet.
     * @return Result of the UpdateDataSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws AccessDeniedException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.UpdateDataSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/UpdateDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDataSetResponse updateDataSet(Consumer<UpdateDataSetRequest.Builder> updateDataSetRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException,
            AccessDeniedException, AwsServiceException, SdkClientException, DataExchangeException {
        return updateDataSet(UpdateDataSetRequest.builder().applyMutation(updateDataSetRequest).build());
    }

    /**
     * <p>
     * This operation updates a revision.
     * </p>
     *
     * @param updateRevisionRequest
     *        The request body for UpdateRevision.
     * @return Result of the UpdateRevision operation returned by the service.
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws AccessDeniedException
     *         403 response
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ConflictException
     *         409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.UpdateRevision
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/UpdateRevision" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateRevisionResponse updateRevision(UpdateRevisionRequest updateRevisionRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ConflictException,
            AwsServiceException, SdkClientException, DataExchangeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation updates a revision.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRevisionRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateRevisionRequest#builder()}
     * </p>
     *
     * @param updateRevisionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRevisionRequest.Builder} to create a request.
     *        The request body for UpdateRevision.
     * @return Result of the UpdateRevision operation returned by the service.
     * @throws ValidationException
     *         400 response
     * @throws InternalServerException
     *         500 response
     * @throws AccessDeniedException
     *         403 response
     * @throws ResourceNotFoundException
     *         404 response
     * @throws ThrottlingException
     *         429 response
     * @throws ConflictException
     *         409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DataExchangeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DataExchangeClient.UpdateRevision
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/UpdateRevision" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateRevisionResponse updateRevision(Consumer<UpdateRevisionRequest.Builder> updateRevisionRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, ConflictException, AwsServiceException, SdkClientException, DataExchangeException {
        return updateRevision(UpdateRevisionRequest.builder().applyMutation(updateRevisionRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("dataexchange");
    }
}
