/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dataexchange.model.ExportServerSideEncryption;
import software.amazon.awssdk.services.dataexchange.model.ListOfRevisionDestinationEntryCopier;
import software.amazon.awssdk.services.dataexchange.model.RevisionDestinationEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportRevisionsToS3RequestDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportRevisionsToS3RequestDetails> {
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetId").getter(ExportRevisionsToS3RequestDetails.getter(ExportRevisionsToS3RequestDetails::dataSetId)).setter(ExportRevisionsToS3RequestDetails.setter(Builder::dataSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()}).build();
    private static final SdkField<ExportServerSideEncryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(ExportRevisionsToS3RequestDetails.getter(ExportRevisionsToS3RequestDetails::encryption)).setter(ExportRevisionsToS3RequestDetails.setter(Builder::encryption)).constructor(ExportServerSideEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encryption").build()}).build();
    private static final SdkField<List<RevisionDestinationEntry>> REVISION_DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RevisionDestinations").getter(ExportRevisionsToS3RequestDetails.getter(ExportRevisionsToS3RequestDetails::revisionDestinations)).setter(ExportRevisionsToS3RequestDetails.setter(Builder::revisionDestinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionDestinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RevisionDestinationEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_ID_FIELD, ENCRYPTION_FIELD, REVISION_DESTINATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dataSetId;
    private final ExportServerSideEncryption encryption;
    private final List<RevisionDestinationEntry> revisionDestinations;

    private ExportRevisionsToS3RequestDetails(BuilderImpl builder) {
        this.dataSetId = builder.dataSetId;
        this.encryption = builder.encryption;
        this.revisionDestinations = builder.revisionDestinations;
    }

    public final String dataSetId() {
        return this.dataSetId;
    }

    public final ExportServerSideEncryption encryption() {
        return this.encryption;
    }

    public final boolean hasRevisionDestinations() {
        return this.revisionDestinations != null && !(this.revisionDestinations instanceof SdkAutoConstructList);
    }

    public final List<RevisionDestinationEntry> revisionDestinations() {
        return this.revisionDestinations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRevisionDestinations() ? this.revisionDestinations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportRevisionsToS3RequestDetails)) {
            return false;
        }
        ExportRevisionsToS3RequestDetails other = (ExportRevisionsToS3RequestDetails)obj;
        return Objects.equals(this.dataSetId(), other.dataSetId()) && Objects.equals(this.encryption(), other.encryption()) && this.hasRevisionDestinations() == other.hasRevisionDestinations() && Objects.equals(this.revisionDestinations(), other.revisionDestinations());
    }

    public final String toString() {
        return ToString.builder((String)"ExportRevisionsToS3RequestDetails").add("DataSetId", (Object)this.dataSetId()).add("Encryption", (Object)this.encryption()).add("RevisionDestinations", this.hasRevisionDestinations() ? this.revisionDestinations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSetId": {
                return Optional.ofNullable(clazz.cast(this.dataSetId()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "RevisionDestinations": {
                return Optional.ofNullable(clazz.cast(this.revisionDestinations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportRevisionsToS3RequestDetails, T> g) {
        return obj -> g.apply((ExportRevisionsToS3RequestDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSetId;
        private ExportServerSideEncryption encryption;
        private List<RevisionDestinationEntry> revisionDestinations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExportRevisionsToS3RequestDetails model) {
            this.dataSetId(model.dataSetId);
            this.encryption(model.encryption);
            this.revisionDestinations(model.revisionDestinations);
        }

        public final String getDataSetId() {
            return this.dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        public final ExportServerSideEncryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(ExportServerSideEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(ExportServerSideEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Collection<RevisionDestinationEntry.Builder> getRevisionDestinations() {
            if (this.revisionDestinations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.revisionDestinations != null ? (Collection)this.revisionDestinations.stream().map(RevisionDestinationEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder revisionDestinations(Collection<RevisionDestinationEntry> revisionDestinations) {
            this.revisionDestinations = ListOfRevisionDestinationEntryCopier.copy(revisionDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisionDestinations(RevisionDestinationEntry ... revisionDestinations) {
            this.revisionDestinations(Arrays.asList(revisionDestinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisionDestinations(Consumer<RevisionDestinationEntry.Builder> ... revisionDestinations) {
            this.revisionDestinations(Stream.of(revisionDestinations).map(c -> (RevisionDestinationEntry)((RevisionDestinationEntry.Builder)RevisionDestinationEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRevisionDestinations(Collection<RevisionDestinationEntry.BuilderImpl> revisionDestinations) {
            this.revisionDestinations = ListOfRevisionDestinationEntryCopier.copyFromBuilder(revisionDestinations);
        }

        public ExportRevisionsToS3RequestDetails build() {
            return new ExportRevisionsToS3RequestDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportRevisionsToS3RequestDetails> {
        public Builder dataSetId(String var1);

        public Builder encryption(ExportServerSideEncryption var1);

        default public Builder encryption(Consumer<ExportServerSideEncryption.Builder> encryption) {
            return this.encryption((ExportServerSideEncryption)((ExportServerSideEncryption.Builder)ExportServerSideEncryption.builder().applyMutation(encryption)).build());
        }

        public Builder revisionDestinations(Collection<RevisionDestinationEntry> var1);

        public Builder revisionDestinations(RevisionDestinationEntry ... var1);

        public Builder revisionDestinations(Consumer<RevisionDestinationEntry.Builder> ... var1);
    }
}

