/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dataexchange.model.ExportAssetToSignedUrlRequestDetails;
import software.amazon.awssdk.services.dataexchange.model.ExportAssetsToS3RequestDetails;
import software.amazon.awssdk.services.dataexchange.model.ImportAssetFromSignedUrlRequestDetails;
import software.amazon.awssdk.services.dataexchange.model.ImportAssetsFromS3RequestDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RequestDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RequestDetails> {
    private static final SdkField<ExportAssetToSignedUrlRequestDetails> EXPORT_ASSET_TO_SIGNED_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportAssetToSignedUrl").getter(RequestDetails.getter(RequestDetails::exportAssetToSignedUrl)).setter(RequestDetails.setter(Builder::exportAssetToSignedUrl)).constructor(ExportAssetToSignedUrlRequestDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportAssetToSignedUrl").build()}).build();
    private static final SdkField<ExportAssetsToS3RequestDetails> EXPORT_ASSETS_TO_S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportAssetsToS3").getter(RequestDetails.getter(RequestDetails::exportAssetsToS3)).setter(RequestDetails.setter(Builder::exportAssetsToS3)).constructor(ExportAssetsToS3RequestDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportAssetsToS3").build()}).build();
    private static final SdkField<ImportAssetFromSignedUrlRequestDetails> IMPORT_ASSET_FROM_SIGNED_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImportAssetFromSignedUrl").getter(RequestDetails.getter(RequestDetails::importAssetFromSignedUrl)).setter(RequestDetails.setter(Builder::importAssetFromSignedUrl)).constructor(ImportAssetFromSignedUrlRequestDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportAssetFromSignedUrl").build()}).build();
    private static final SdkField<ImportAssetsFromS3RequestDetails> IMPORT_ASSETS_FROM_S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImportAssetsFromS3").getter(RequestDetails.getter(RequestDetails::importAssetsFromS3)).setter(RequestDetails.setter(Builder::importAssetsFromS3)).constructor(ImportAssetsFromS3RequestDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportAssetsFromS3").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_ASSET_TO_SIGNED_URL_FIELD, EXPORT_ASSETS_TO_S3_FIELD, IMPORT_ASSET_FROM_SIGNED_URL_FIELD, IMPORT_ASSETS_FROM_S3_FIELD));
    private static final long serialVersionUID = 1L;
    private final ExportAssetToSignedUrlRequestDetails exportAssetToSignedUrl;
    private final ExportAssetsToS3RequestDetails exportAssetsToS3;
    private final ImportAssetFromSignedUrlRequestDetails importAssetFromSignedUrl;
    private final ImportAssetsFromS3RequestDetails importAssetsFromS3;

    private RequestDetails(BuilderImpl builder) {
        this.exportAssetToSignedUrl = builder.exportAssetToSignedUrl;
        this.exportAssetsToS3 = builder.exportAssetsToS3;
        this.importAssetFromSignedUrl = builder.importAssetFromSignedUrl;
        this.importAssetsFromS3 = builder.importAssetsFromS3;
    }

    public ExportAssetToSignedUrlRequestDetails exportAssetToSignedUrl() {
        return this.exportAssetToSignedUrl;
    }

    public ExportAssetsToS3RequestDetails exportAssetsToS3() {
        return this.exportAssetsToS3;
    }

    public ImportAssetFromSignedUrlRequestDetails importAssetFromSignedUrl() {
        return this.importAssetFromSignedUrl;
    }

    public ImportAssetsFromS3RequestDetails importAssetsFromS3() {
        return this.importAssetsFromS3;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exportAssetToSignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportAssetsToS3());
        hashCode = 31 * hashCode + Objects.hashCode(this.importAssetFromSignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.importAssetsFromS3());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestDetails)) {
            return false;
        }
        RequestDetails other = (RequestDetails)obj;
        return Objects.equals(this.exportAssetToSignedUrl(), other.exportAssetToSignedUrl()) && Objects.equals(this.exportAssetsToS3(), other.exportAssetsToS3()) && Objects.equals(this.importAssetFromSignedUrl(), other.importAssetFromSignedUrl()) && Objects.equals(this.importAssetsFromS3(), other.importAssetsFromS3());
    }

    public String toString() {
        return ToString.builder((String)"RequestDetails").add("ExportAssetToSignedUrl", (Object)this.exportAssetToSignedUrl()).add("ExportAssetsToS3", (Object)this.exportAssetsToS3()).add("ImportAssetFromSignedUrl", (Object)this.importAssetFromSignedUrl()).add("ImportAssetsFromS3", (Object)this.importAssetsFromS3()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExportAssetToSignedUrl": {
                return Optional.ofNullable(clazz.cast(this.exportAssetToSignedUrl()));
            }
            case "ExportAssetsToS3": {
                return Optional.ofNullable(clazz.cast(this.exportAssetsToS3()));
            }
            case "ImportAssetFromSignedUrl": {
                return Optional.ofNullable(clazz.cast(this.importAssetFromSignedUrl()));
            }
            case "ImportAssetsFromS3": {
                return Optional.ofNullable(clazz.cast(this.importAssetsFromS3()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestDetails, T> g) {
        return obj -> g.apply((RequestDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ExportAssetToSignedUrlRequestDetails exportAssetToSignedUrl;
        private ExportAssetsToS3RequestDetails exportAssetsToS3;
        private ImportAssetFromSignedUrlRequestDetails importAssetFromSignedUrl;
        private ImportAssetsFromS3RequestDetails importAssetsFromS3;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestDetails model) {
            this.exportAssetToSignedUrl(model.exportAssetToSignedUrl);
            this.exportAssetsToS3(model.exportAssetsToS3);
            this.importAssetFromSignedUrl(model.importAssetFromSignedUrl);
            this.importAssetsFromS3(model.importAssetsFromS3);
        }

        public final ExportAssetToSignedUrlRequestDetails.Builder getExportAssetToSignedUrl() {
            return this.exportAssetToSignedUrl != null ? this.exportAssetToSignedUrl.toBuilder() : null;
        }

        @Override
        public final Builder exportAssetToSignedUrl(ExportAssetToSignedUrlRequestDetails exportAssetToSignedUrl) {
            this.exportAssetToSignedUrl = exportAssetToSignedUrl;
            return this;
        }

        public final void setExportAssetToSignedUrl(ExportAssetToSignedUrlRequestDetails.BuilderImpl exportAssetToSignedUrl) {
            this.exportAssetToSignedUrl = exportAssetToSignedUrl != null ? exportAssetToSignedUrl.build() : null;
        }

        public final ExportAssetsToS3RequestDetails.Builder getExportAssetsToS3() {
            return this.exportAssetsToS3 != null ? this.exportAssetsToS3.toBuilder() : null;
        }

        @Override
        public final Builder exportAssetsToS3(ExportAssetsToS3RequestDetails exportAssetsToS3) {
            this.exportAssetsToS3 = exportAssetsToS3;
            return this;
        }

        public final void setExportAssetsToS3(ExportAssetsToS3RequestDetails.BuilderImpl exportAssetsToS3) {
            this.exportAssetsToS3 = exportAssetsToS3 != null ? exportAssetsToS3.build() : null;
        }

        public final ImportAssetFromSignedUrlRequestDetails.Builder getImportAssetFromSignedUrl() {
            return this.importAssetFromSignedUrl != null ? this.importAssetFromSignedUrl.toBuilder() : null;
        }

        @Override
        public final Builder importAssetFromSignedUrl(ImportAssetFromSignedUrlRequestDetails importAssetFromSignedUrl) {
            this.importAssetFromSignedUrl = importAssetFromSignedUrl;
            return this;
        }

        public final void setImportAssetFromSignedUrl(ImportAssetFromSignedUrlRequestDetails.BuilderImpl importAssetFromSignedUrl) {
            this.importAssetFromSignedUrl = importAssetFromSignedUrl != null ? importAssetFromSignedUrl.build() : null;
        }

        public final ImportAssetsFromS3RequestDetails.Builder getImportAssetsFromS3() {
            return this.importAssetsFromS3 != null ? this.importAssetsFromS3.toBuilder() : null;
        }

        @Override
        public final Builder importAssetsFromS3(ImportAssetsFromS3RequestDetails importAssetsFromS3) {
            this.importAssetsFromS3 = importAssetsFromS3;
            return this;
        }

        public final void setImportAssetsFromS3(ImportAssetsFromS3RequestDetails.BuilderImpl importAssetsFromS3) {
            this.importAssetsFromS3 = importAssetsFromS3 != null ? importAssetsFromS3.build() : null;
        }

        public RequestDetails build() {
            return new RequestDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RequestDetails> {
        public Builder exportAssetToSignedUrl(ExportAssetToSignedUrlRequestDetails var1);

        default public Builder exportAssetToSignedUrl(Consumer<ExportAssetToSignedUrlRequestDetails.Builder> exportAssetToSignedUrl) {
            return this.exportAssetToSignedUrl((ExportAssetToSignedUrlRequestDetails)((ExportAssetToSignedUrlRequestDetails.Builder)ExportAssetToSignedUrlRequestDetails.builder().applyMutation(exportAssetToSignedUrl)).build());
        }

        public Builder exportAssetsToS3(ExportAssetsToS3RequestDetails var1);

        default public Builder exportAssetsToS3(Consumer<ExportAssetsToS3RequestDetails.Builder> exportAssetsToS3) {
            return this.exportAssetsToS3((ExportAssetsToS3RequestDetails)((ExportAssetsToS3RequestDetails.Builder)ExportAssetsToS3RequestDetails.builder().applyMutation(exportAssetsToS3)).build());
        }

        public Builder importAssetFromSignedUrl(ImportAssetFromSignedUrlRequestDetails var1);

        default public Builder importAssetFromSignedUrl(Consumer<ImportAssetFromSignedUrlRequestDetails.Builder> importAssetFromSignedUrl) {
            return this.importAssetFromSignedUrl((ImportAssetFromSignedUrlRequestDetails)((ImportAssetFromSignedUrlRequestDetails.Builder)ImportAssetFromSignedUrlRequestDetails.builder().applyMutation(importAssetFromSignedUrl)).build());
        }

        public Builder importAssetsFromS3(ImportAssetsFromS3RequestDetails var1);

        default public Builder importAssetsFromS3(Consumer<ImportAssetsFromS3RequestDetails.Builder> importAssetsFromS3) {
            return this.importAssetsFromS3((ImportAssetsFromS3RequestDetails)((ImportAssetsFromS3RequestDetails.Builder)ImportAssetsFromS3RequestDetails.builder().applyMutation(importAssetsFromS3)).build());
        }
    }
}

