/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDataSetsResponse extends DataExchangeResponse implements
        ToCopyableBuilder<ListDataSetsResponse.Builder, ListDataSetsResponse> {
    private static final SdkField<List<DataSetEntry>> DATA_SETS_FIELD = SdkField
            .<List<DataSetEntry>> builder(MarshallingType.LIST)
            .getter(getter(ListDataSetsResponse::dataSets))
            .setter(setter(Builder::dataSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSetEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSetEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDataSetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SETS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DataSetEntry> dataSets;

    private final String nextToken;

    private ListDataSetsResponse(BuilderImpl builder) {
        super(builder);
        this.dataSets = builder.dataSets;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the DataSets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDataSets() {
        return dataSets != null && !(dataSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data set objects listed by the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDataSets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The data set objects listed by the request.
     */
    public List<DataSetEntry> dataSets() {
        return dataSets;
    }

    /**
     * <p>
     * The token value retrieved from a previous call to access the next page of results.
     * </p>
     * 
     * @return The token value retrieved from a previous call to access the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataSets());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSetsResponse)) {
            return false;
        }
        ListDataSetsResponse other = (ListDataSetsResponse) obj;
        return Objects.equals(dataSets(), other.dataSets()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDataSetsResponse").add("DataSets", dataSets()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSets":
            return Optional.ofNullable(clazz.cast(dataSets()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDataSetsResponse, T> g) {
        return obj -> g.apply((ListDataSetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataExchangeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDataSetsResponse> {
        /**
         * <p>
         * The data set objects listed by the request.
         * </p>
         * 
         * @param dataSets
         *        The data set objects listed by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSets(Collection<DataSetEntry> dataSets);

        /**
         * <p>
         * The data set objects listed by the request.
         * </p>
         * 
         * @param dataSets
         *        The data set objects listed by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSets(DataSetEntry... dataSets);

        /**
         * <p>
         * The data set objects listed by the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DataSetEntry>.Builder} avoiding the need to
         * create one manually via {@link List<DataSetEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataSetEntry>.Builder#build()} is called immediately and its
         * result is passed to {@link #dataSets(List<DataSetEntry>)}.
         * 
         * @param dataSets
         *        a consumer that will call methods on {@link List<DataSetEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSets(List<DataSetEntry>)
         */
        Builder dataSets(Consumer<DataSetEntry.Builder>... dataSets);

        /**
         * <p>
         * The token value retrieved from a previous call to access the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token value retrieved from a previous call to access the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DataExchangeResponse.BuilderImpl implements Builder {
        private List<DataSetEntry> dataSets = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataSetsResponse model) {
            super(model);
            dataSets(model.dataSets);
            nextToken(model.nextToken);
        }

        public final Collection<DataSetEntry.Builder> getDataSets() {
            return dataSets != null ? dataSets.stream().map(DataSetEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dataSets(Collection<DataSetEntry> dataSets) {
            this.dataSets = ListOfDataSetEntryCopier.copy(dataSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(DataSetEntry... dataSets) {
            dataSets(Arrays.asList(dataSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(Consumer<DataSetEntry.Builder>... dataSets) {
            dataSets(Stream.of(dataSets).map(c -> DataSetEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDataSets(Collection<DataSetEntry.BuilderImpl> dataSets) {
            this.dataSets = ListOfDataSetEntryCopier.copyFromBuilder(dataSets);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDataSetsResponse build() {
            return new ListDataSetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
