/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDataSetRevisionsResponse extends DataExchangeResponse implements
        ToCopyableBuilder<ListDataSetRevisionsResponse.Builder, ListDataSetRevisionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDataSetRevisionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<RevisionEntry>> REVISIONS_FIELD = SdkField
            .<List<RevisionEntry>> builder(MarshallingType.LIST)
            .getter(getter(ListDataSetRevisionsResponse::revisions))
            .setter(setter(Builder::revisions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Revisions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RevisionEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(RevisionEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            REVISIONS_FIELD));

    private final String nextToken;

    private final List<RevisionEntry> revisions;

    private ListDataSetRevisionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.revisions = builder.revisions;
    }

    /**
     * <p>
     * The token value retrieved from a previous call to access the next page of results.
     * </p>
     * 
     * @return The token value retrieved from a previous call to access the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Revisions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRevisions() {
        return revisions != null && !(revisions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The asset objects listed by the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRevisions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The asset objects listed by the request.
     */
    public List<RevisionEntry> revisions() {
        return revisions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(revisions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSetRevisionsResponse)) {
            return false;
        }
        ListDataSetRevisionsResponse other = (ListDataSetRevisionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(revisions(), other.revisions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDataSetRevisionsResponse").add("NextToken", nextToken()).add("Revisions", revisions())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Revisions":
            return Optional.ofNullable(clazz.cast(revisions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDataSetRevisionsResponse, T> g) {
        return obj -> g.apply((ListDataSetRevisionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataExchangeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDataSetRevisionsResponse> {
        /**
         * <p>
         * The token value retrieved from a previous call to access the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token value retrieved from a previous call to access the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The asset objects listed by the request.
         * </p>
         * 
         * @param revisions
         *        The asset objects listed by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisions(Collection<RevisionEntry> revisions);

        /**
         * <p>
         * The asset objects listed by the request.
         * </p>
         * 
         * @param revisions
         *        The asset objects listed by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisions(RevisionEntry... revisions);

        /**
         * <p>
         * The asset objects listed by the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RevisionEntry>.Builder} avoiding the need
         * to create one manually via {@link List<RevisionEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RevisionEntry>.Builder#build()} is called immediately and
         * its result is passed to {@link #revisions(List<RevisionEntry>)}.
         * 
         * @param revisions
         *        a consumer that will call methods on {@link List<RevisionEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revisions(List<RevisionEntry>)
         */
        Builder revisions(Consumer<RevisionEntry.Builder>... revisions);
    }

    static final class BuilderImpl extends DataExchangeResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<RevisionEntry> revisions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataSetRevisionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            revisions(model.revisions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<RevisionEntry.Builder> getRevisions() {
            return revisions != null ? revisions.stream().map(RevisionEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder revisions(Collection<RevisionEntry> revisions) {
            this.revisions = ListOfRevisionEntryCopier.copy(revisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(RevisionEntry... revisions) {
            revisions(Arrays.asList(revisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(Consumer<RevisionEntry.Builder>... revisions) {
            revisions(Stream.of(revisions).map(c -> RevisionEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRevisions(Collection<RevisionEntry.BuilderImpl> revisions) {
            this.revisions = ListOfRevisionEntryCopier.copyFromBuilder(revisions);
        }

        @Override
        public ListDataSetRevisionsResponse build() {
            return new ListDataSetRevisionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
