/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetJobResponse extends DataExchangeResponse implements
        ToCopyableBuilder<GetJobResponse.Builder, GetJobResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetJobResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetJobResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<ResponseDetails> DETAILS_FIELD = SdkField.<ResponseDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetJobResponse::details)).setter(setter(Builder::details)).constructor(ResponseDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()).build();

    private static final SdkField<List<JobError>> ERRORS_FIELD = SdkField
            .<List<JobError>> builder(MarshallingType.LIST)
            .getter(getter(GetJobResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobError> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetJobResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetJobResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetJobResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetJobResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            DETAILS_FIELD, ERRORS_FIELD, ID_FIELD, STATE_FIELD, TYPE_FIELD, UPDATED_AT_FIELD));

    private final String arn;

    private final Instant createdAt;

    private final ResponseDetails details;

    private final List<JobError> errors;

    private final String id;

    private final String state;

    private final String type;

    private final Instant updatedAt;

    private GetJobResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.details = builder.details;
        this.errors = builder.errors;
        this.id = builder.id;
        this.state = builder.state;
        this.type = builder.type;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The ARN for the job.
     * </p>
     * 
     * @return The ARN for the job.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time that the job was created, in ISO 8601 format.
     * </p>
     * 
     * @return The date and time that the job was created, in ISO 8601 format.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Details about the job.
     * </p>
     * 
     * @return Details about the job.
     */
    public ResponseDetails details() {
        return details;
    }

    /**
     * Returns true if the Errors property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The errors associated with jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The errors associated with jobs.
     */
    public List<JobError> errors() {
        return errors;
    }

    /**
     * <p>
     * The unique identifier for the job.
     * </p>
     * 
     * @return The unique identifier for the job.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The state of the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the job.
     * @see State
     */
    public State state() {
        return State.fromValue(state);
    }

    /**
     * <p>
     * The state of the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the job.
     * @see State
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The job type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The job type.
     * @see Type
     */
    public Type type() {
        return Type.fromValue(type);
    }

    /**
     * <p>
     * The job type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The job type.
     * @see Type
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The date and time that the job was last updated, in ISO 8601 format.
     * </p>
     * 
     * @return The date and time that the job was last updated, in ISO 8601 format.
     */
    public Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        hashCode = 31 * hashCode + Objects.hashCode(errors());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobResponse)) {
            return false;
        }
        GetJobResponse other = (GetJobResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(details(), other.details()) && Objects.equals(errors(), other.errors())
                && Objects.equals(id(), other.id()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetJobResponse").add("Arn", arn()).add("CreatedAt", createdAt()).add("Details", details())
                .add("Errors", errors()).add("Id", id()).add("State", stateAsString()).add("Type", typeAsString())
                .add("UpdatedAt", updatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Details":
            return Optional.ofNullable(clazz.cast(details()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetJobResponse, T> g) {
        return obj -> g.apply((GetJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataExchangeResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetJobResponse> {
        /**
         * <p>
         * The ARN for the job.
         * </p>
         * 
         * @param arn
         *        The ARN for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time that the job was created, in ISO 8601 format.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the job was created, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Details about the job.
         * </p>
         * 
         * @param details
         *        Details about the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(ResponseDetails details);

        /**
         * <p>
         * Details about the job.
         * </p>
         * This is a convenience that creates an instance of the {@link ResponseDetails.Builder} avoiding the need to
         * create one manually via {@link ResponseDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResponseDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #details(ResponseDetails)}.
         * 
         * @param details
         *        a consumer that will call methods on {@link ResponseDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(ResponseDetails)
         */
        default Builder details(Consumer<ResponseDetails.Builder> details) {
            return details(ResponseDetails.builder().applyMutation(details).build());
        }

        /**
         * <p>
         * The errors associated with jobs.
         * </p>
         * 
         * @param errors
         *        The errors associated with jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<JobError> errors);

        /**
         * <p>
         * The errors associated with jobs.
         * </p>
         * 
         * @param errors
         *        The errors associated with jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(JobError... errors);

        /**
         * <p>
         * The errors associated with jobs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobError>.Builder} avoiding the need to
         * create one manually via {@link List<JobError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobError>.Builder#build()} is called immediately and its
         * result is passed to {@link #errors(List<JobError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on {@link List<JobError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(List<JobError>)
         */
        Builder errors(Consumer<JobError.Builder>... errors);

        /**
         * <p>
         * The unique identifier for the job.
         * </p>
         * 
         * @param id
         *        The unique identifier for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The state of the job.
         * </p>
         * 
         * @param state
         *        The state of the job.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the job.
         * </p>
         * 
         * @param state
         *        The state of the job.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(State state);

        /**
         * <p>
         * The job type.
         * </p>
         * 
         * @param type
         *        The job type.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * <p>
         * The job type.
         * </p>
         * 
         * @param type
         *        The job type.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);

        /**
         * <p>
         * The date and time that the job was last updated, in ISO 8601 format.
         * </p>
         * 
         * @param updatedAt
         *        The date and time that the job was last updated, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl extends DataExchangeResponse.BuilderImpl implements Builder {
        private String arn;

        private Instant createdAt;

        private ResponseDetails details;

        private List<JobError> errors = DefaultSdkAutoConstructList.getInstance();

        private String id;

        private String state;

        private String type;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobResponse model) {
            super(model);
            arn(model.arn);
            createdAt(model.createdAt);
            details(model.details);
            errors(model.errors);
            id(model.id);
            state(model.state);
            type(model.type);
            updatedAt(model.updatedAt);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResponseDetails.Builder getDetails() {
            return details != null ? details.toBuilder() : null;
        }

        @Override
        public final Builder details(ResponseDetails details) {
            this.details = details;
            return this;
        }

        public final void setDetails(ResponseDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        public final Collection<JobError.Builder> getErrors() {
            return errors != null ? errors.stream().map(JobError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<JobError> errors) {
            this.errors = ListOfJobErrorCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(JobError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<JobError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> JobError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<JobError.BuilderImpl> errors) {
            this.errors = ListOfJobErrorCopier.copyFromBuilder(errors);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public GetJobResponse build() {
            return new GetJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
