/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class Details implements SdkPojo, Serializable, ToCopyableBuilder<Details.Builder, Details> {
    private static final SdkField<ImportAssetFromSignedUrlJobErrorDetails> IMPORT_ASSET_FROM_SIGNED_URL_JOB_ERROR_DETAILS_FIELD = SdkField
            .<ImportAssetFromSignedUrlJobErrorDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(Details::importAssetFromSignedUrlJobErrorDetails))
            .setter(setter(Builder::importAssetFromSignedUrlJobErrorDetails))
            .constructor(ImportAssetFromSignedUrlJobErrorDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ImportAssetFromSignedUrlJobErrorDetails").build()).build();

    private static final SdkField<List<AssetSourceEntry>> IMPORT_ASSETS_FROM_S3_JOB_ERROR_DETAILS_FIELD = SdkField
            .<List<AssetSourceEntry>> builder(MarshallingType.LIST)
            .getter(getter(Details::importAssetsFromS3JobErrorDetails))
            .setter(setter(Builder::importAssetsFromS3JobErrorDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportAssetsFromS3JobErrorDetails")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetSourceEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetSourceEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IMPORT_ASSET_FROM_SIGNED_URL_JOB_ERROR_DETAILS_FIELD, IMPORT_ASSETS_FROM_S3_JOB_ERROR_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ImportAssetFromSignedUrlJobErrorDetails importAssetFromSignedUrlJobErrorDetails;

    private final List<AssetSourceEntry> importAssetsFromS3JobErrorDetails;

    private Details(BuilderImpl builder) {
        this.importAssetFromSignedUrlJobErrorDetails = builder.importAssetFromSignedUrlJobErrorDetails;
        this.importAssetsFromS3JobErrorDetails = builder.importAssetsFromS3JobErrorDetails;
    }

    /**
     * Returns the value of the ImportAssetFromSignedUrlJobErrorDetails property for this object.
     * 
     * @return The value of the ImportAssetFromSignedUrlJobErrorDetails property for this object.
     */
    public ImportAssetFromSignedUrlJobErrorDetails importAssetFromSignedUrlJobErrorDetails() {
        return importAssetFromSignedUrlJobErrorDetails;
    }

    /**
     * Returns true if the ImportAssetsFromS3JobErrorDetails property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasImportAssetsFromS3JobErrorDetails() {
        return importAssetsFromS3JobErrorDetails != null && !(importAssetsFromS3JobErrorDetails instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the ImportAssetsFromS3JobErrorDetails property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasImportAssetsFromS3JobErrorDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the ImportAssetsFromS3JobErrorDetails property for this object.
     */
    public List<AssetSourceEntry> importAssetsFromS3JobErrorDetails() {
        return importAssetsFromS3JobErrorDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(importAssetFromSignedUrlJobErrorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(importAssetsFromS3JobErrorDetails());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Details)) {
            return false;
        }
        Details other = (Details) obj;
        return Objects.equals(importAssetFromSignedUrlJobErrorDetails(), other.importAssetFromSignedUrlJobErrorDetails())
                && Objects.equals(importAssetsFromS3JobErrorDetails(), other.importAssetsFromS3JobErrorDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Details")
                .add("ImportAssetFromSignedUrlJobErrorDetails", importAssetFromSignedUrlJobErrorDetails())
                .add("ImportAssetsFromS3JobErrorDetails", importAssetsFromS3JobErrorDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImportAssetFromSignedUrlJobErrorDetails":
            return Optional.ofNullable(clazz.cast(importAssetFromSignedUrlJobErrorDetails()));
        case "ImportAssetsFromS3JobErrorDetails":
            return Optional.ofNullable(clazz.cast(importAssetsFromS3JobErrorDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Details, T> g) {
        return obj -> g.apply((Details) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Details> {
        /**
         * Sets the value of the ImportAssetFromSignedUrlJobErrorDetails property for this object.
         *
         * @param importAssetFromSignedUrlJobErrorDetails
         *        The new value for the ImportAssetFromSignedUrlJobErrorDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importAssetFromSignedUrlJobErrorDetails(
                ImportAssetFromSignedUrlJobErrorDetails importAssetFromSignedUrlJobErrorDetails);

        /**
         * Sets the value of the ImportAssetFromSignedUrlJobErrorDetails property for this object.
         *
         * This is a convenience that creates an instance of the {@link ImportAssetFromSignedUrlJobErrorDetails.Builder}
         * avoiding the need to create one manually via {@link ImportAssetFromSignedUrlJobErrorDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImportAssetFromSignedUrlJobErrorDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #importAssetFromSignedUrlJobErrorDetails(ImportAssetFromSignedUrlJobErrorDetails)}.
         * 
         * @param importAssetFromSignedUrlJobErrorDetails
         *        a consumer that will call methods on {@link ImportAssetFromSignedUrlJobErrorDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importAssetFromSignedUrlJobErrorDetails(ImportAssetFromSignedUrlJobErrorDetails)
         */
        default Builder importAssetFromSignedUrlJobErrorDetails(
                Consumer<ImportAssetFromSignedUrlJobErrorDetails.Builder> importAssetFromSignedUrlJobErrorDetails) {
            return importAssetFromSignedUrlJobErrorDetails(ImportAssetFromSignedUrlJobErrorDetails.builder()
                    .applyMutation(importAssetFromSignedUrlJobErrorDetails).build());
        }

        /**
         * Sets the value of the ImportAssetsFromS3JobErrorDetails property for this object.
         *
         * @param importAssetsFromS3JobErrorDetails
         *        The new value for the ImportAssetsFromS3JobErrorDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importAssetsFromS3JobErrorDetails(Collection<AssetSourceEntry> importAssetsFromS3JobErrorDetails);

        /**
         * Sets the value of the ImportAssetsFromS3JobErrorDetails property for this object.
         *
         * @param importAssetsFromS3JobErrorDetails
         *        The new value for the ImportAssetsFromS3JobErrorDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importAssetsFromS3JobErrorDetails(AssetSourceEntry... importAssetsFromS3JobErrorDetails);

        /**
         * Sets the value of the ImportAssetsFromS3JobErrorDetails property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<AssetSourceEntry>.Builder} avoiding the
         * need to create one manually via {@link List<AssetSourceEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssetSourceEntry>.Builder#build()} is called immediately and
         * its result is passed to {@link #importAssetsFromS3JobErrorDetails(List<AssetSourceEntry>)}.
         * 
         * @param importAssetsFromS3JobErrorDetails
         *        a consumer that will call methods on {@link List<AssetSourceEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importAssetsFromS3JobErrorDetails(List<AssetSourceEntry>)
         */
        Builder importAssetsFromS3JobErrorDetails(Consumer<AssetSourceEntry.Builder>... importAssetsFromS3JobErrorDetails);
    }

    static final class BuilderImpl implements Builder {
        private ImportAssetFromSignedUrlJobErrorDetails importAssetFromSignedUrlJobErrorDetails;

        private List<AssetSourceEntry> importAssetsFromS3JobErrorDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Details model) {
            importAssetFromSignedUrlJobErrorDetails(model.importAssetFromSignedUrlJobErrorDetails);
            importAssetsFromS3JobErrorDetails(model.importAssetsFromS3JobErrorDetails);
        }

        public final ImportAssetFromSignedUrlJobErrorDetails.Builder getImportAssetFromSignedUrlJobErrorDetails() {
            return importAssetFromSignedUrlJobErrorDetails != null ? importAssetFromSignedUrlJobErrorDetails.toBuilder() : null;
        }

        @Override
        public final Builder importAssetFromSignedUrlJobErrorDetails(
                ImportAssetFromSignedUrlJobErrorDetails importAssetFromSignedUrlJobErrorDetails) {
            this.importAssetFromSignedUrlJobErrorDetails = importAssetFromSignedUrlJobErrorDetails;
            return this;
        }

        public final void setImportAssetFromSignedUrlJobErrorDetails(
                ImportAssetFromSignedUrlJobErrorDetails.BuilderImpl importAssetFromSignedUrlJobErrorDetails) {
            this.importAssetFromSignedUrlJobErrorDetails = importAssetFromSignedUrlJobErrorDetails != null ? importAssetFromSignedUrlJobErrorDetails
                    .build() : null;
        }

        public final Collection<AssetSourceEntry.Builder> getImportAssetsFromS3JobErrorDetails() {
            return importAssetsFromS3JobErrorDetails != null ? importAssetsFromS3JobErrorDetails.stream()
                    .map(AssetSourceEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder importAssetsFromS3JobErrorDetails(Collection<AssetSourceEntry> importAssetsFromS3JobErrorDetails) {
            this.importAssetsFromS3JobErrorDetails = ListOfAssetSourceEntryCopier.copy(importAssetsFromS3JobErrorDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importAssetsFromS3JobErrorDetails(AssetSourceEntry... importAssetsFromS3JobErrorDetails) {
            importAssetsFromS3JobErrorDetails(Arrays.asList(importAssetsFromS3JobErrorDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importAssetsFromS3JobErrorDetails(
                Consumer<AssetSourceEntry.Builder>... importAssetsFromS3JobErrorDetails) {
            importAssetsFromS3JobErrorDetails(Stream.of(importAssetsFromS3JobErrorDetails)
                    .map(c -> AssetSourceEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setImportAssetsFromS3JobErrorDetails(
                Collection<AssetSourceEntry.BuilderImpl> importAssetsFromS3JobErrorDetails) {
            this.importAssetsFromS3JobErrorDetails = ListOfAssetSourceEntryCopier
                    .copyFromBuilder(importAssetsFromS3JobErrorDetails);
        }

        @Override
        public Details build() {
            return new Details(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
