/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A data set is an AWS resource with one or more revisions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSetEntry implements SdkPojo, Serializable, ToCopyableBuilder<DataSetEntry.Builder, DataSetEntry> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataSetEntry::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ASSET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataSetEntry::assetTypeAsString)).setter(setter(Builder::assetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetType").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DataSetEntry::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataSetEntry::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataSetEntry::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataSetEntry::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ORIGIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataSetEntry::originAsString)).setter(setter(Builder::origin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin").build()).build();

    private static final SdkField<OriginDetails> ORIGIN_DETAILS_FIELD = SdkField
            .<OriginDetails> builder(MarshallingType.SDK_POJO).getter(getter(DataSetEntry::originDetails))
            .setter(setter(Builder::originDetails)).constructor(OriginDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginDetails").build()).build();

    private static final SdkField<String> SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataSetEntry::sourceId)).setter(setter(Builder::sourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceId").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DataSetEntry::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ASSET_TYPE_FIELD,
            CREATED_AT_FIELD, DESCRIPTION_FIELD, ID_FIELD, NAME_FIELD, ORIGIN_FIELD, ORIGIN_DETAILS_FIELD, SOURCE_ID_FIELD,
            UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String assetType;

    private final Instant createdAt;

    private final String description;

    private final String id;

    private final String name;

    private final String origin;

    private final OriginDetails originDetails;

    private final String sourceId;

    private final Instant updatedAt;

    private DataSetEntry(BuilderImpl builder) {
        this.arn = builder.arn;
        this.assetType = builder.assetType;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.id = builder.id;
        this.name = builder.name;
        this.origin = builder.origin;
        this.originDetails = builder.originDetails;
        this.sourceId = builder.sourceId;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The ARN for the data set.
     * </p>
     * 
     * @return The ARN for the data set.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The type of file your data is stored in. Currently, the supported asset type is S3_SNAPSHOT.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assetType} will
     * return {@link AssetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #assetTypeAsString}.
     * </p>
     * 
     * @return The type of file your data is stored in. Currently, the supported asset type is S3_SNAPSHOT.
     * @see AssetType
     */
    public AssetType assetType() {
        return AssetType.fromValue(assetType);
    }

    /**
     * <p>
     * The type of file your data is stored in. Currently, the supported asset type is S3_SNAPSHOT.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assetType} will
     * return {@link AssetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #assetTypeAsString}.
     * </p>
     * 
     * @return The type of file your data is stored in. Currently, the supported asset type is S3_SNAPSHOT.
     * @see AssetType
     */
    public String assetTypeAsString() {
        return assetType;
    }

    /**
     * <p>
     * The date and time that the data set was created, in ISO 8601 format.
     * </p>
     * 
     * @return The date and time that the data set was created, in ISO 8601 format.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The description for the data set.
     * </p>
     * 
     * @return The description for the data set.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier for the data set.
     * </p>
     * 
     * @return The unique identifier for the data set.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The name of the data set.
     * </p>
     * 
     * @return The name of the data set.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for
     * subscribers).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #origin} will
     * return {@link Origin#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #originAsString}.
     * </p>
     * 
     * @return A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account
     *         (for subscribers).
     * @see Origin
     */
    public Origin origin() {
        return Origin.fromValue(origin);
    }

    /**
     * <p>
     * A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for
     * subscribers).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #origin} will
     * return {@link Origin#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #originAsString}.
     * </p>
     * 
     * @return A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account
     *         (for subscribers).
     * @see Origin
     */
    public String originAsString() {
        return origin;
    }

    /**
     * <p>
     * If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.
     * </p>
     * 
     * @return If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.
     */
    public OriginDetails originDetails() {
        return originDetails;
    }

    /**
     * <p>
     * The data set ID of the owned data set corresponding to the entitled data set being viewed. This parameter is
     * returned when a data set owner is viewing the entitled copy of its owned data set.
     * </p>
     * 
     * @return The data set ID of the owned data set corresponding to the entitled data set being viewed. This parameter
     *         is returned when a data set owner is viewing the entitled copy of its owned data set.
     */
    public String sourceId() {
        return sourceId;
    }

    /**
     * <p>
     * The date and time that the data set was last updated, in ISO 8601 format.
     * </p>
     * 
     * @return The date and time that the data set was last updated, in ISO 8601 format.
     */
    public Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(assetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(originAsString());
        hashCode = 31 * hashCode + Objects.hashCode(originDetails());
        hashCode = 31 * hashCode + Objects.hashCode(sourceId());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetEntry)) {
            return false;
        }
        DataSetEntry other = (DataSetEntry) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(assetTypeAsString(), other.assetTypeAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(description(), other.description())
                && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(originAsString(), other.originAsString())
                && Objects.equals(originDetails(), other.originDetails()) && Objects.equals(sourceId(), other.sourceId())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DataSetEntry").add("Arn", arn()).add("AssetType", assetTypeAsString())
                .add("CreatedAt", createdAt()).add("Description", description()).add("Id", id()).add("Name", name())
                .add("Origin", originAsString()).add("OriginDetails", originDetails()).add("SourceId", sourceId())
                .add("UpdatedAt", updatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "AssetType":
            return Optional.ofNullable(clazz.cast(assetTypeAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Origin":
            return Optional.ofNullable(clazz.cast(originAsString()));
        case "OriginDetails":
            return Optional.ofNullable(clazz.cast(originDetails()));
        case "SourceId":
            return Optional.ofNullable(clazz.cast(sourceId()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSetEntry, T> g) {
        return obj -> g.apply((DataSetEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSetEntry> {
        /**
         * <p>
         * The ARN for the data set.
         * </p>
         * 
         * @param arn
         *        The ARN for the data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The type of file your data is stored in. Currently, the supported asset type is S3_SNAPSHOT.
         * </p>
         * 
         * @param assetType
         *        The type of file your data is stored in. Currently, the supported asset type is S3_SNAPSHOT.
         * @see AssetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetType
         */
        Builder assetType(String assetType);

        /**
         * <p>
         * The type of file your data is stored in. Currently, the supported asset type is S3_SNAPSHOT.
         * </p>
         * 
         * @param assetType
         *        The type of file your data is stored in. Currently, the supported asset type is S3_SNAPSHOT.
         * @see AssetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetType
         */
        Builder assetType(AssetType assetType);

        /**
         * <p>
         * The date and time that the data set was created, in ISO 8601 format.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the data set was created, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The description for the data set.
         * </p>
         * 
         * @param description
         *        The description for the data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier for the data set.
         * </p>
         * 
         * @param id
         *        The unique identifier for the data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the data set.
         * </p>
         * 
         * @param name
         *        The name of the data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for
         * subscribers).
         * </p>
         * 
         * @param origin
         *        A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the
         *        account (for subscribers).
         * @see Origin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Origin
         */
        Builder origin(String origin);

        /**
         * <p>
         * A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for
         * subscribers).
         * </p>
         * 
         * @param origin
         *        A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the
         *        account (for subscribers).
         * @see Origin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Origin
         */
        Builder origin(Origin origin);

        /**
         * <p>
         * If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.
         * </p>
         * 
         * @param originDetails
         *        If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originDetails(OriginDetails originDetails);

        /**
         * <p>
         * If the origin of this data set is ENTITLED, includes the details for the product on AWS Marketplace.
         * </p>
         * This is a convenience that creates an instance of the {@link OriginDetails.Builder} avoiding the need to
         * create one manually via {@link OriginDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link OriginDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #originDetails(OriginDetails)}.
         * 
         * @param originDetails
         *        a consumer that will call methods on {@link OriginDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #originDetails(OriginDetails)
         */
        default Builder originDetails(Consumer<OriginDetails.Builder> originDetails) {
            return originDetails(OriginDetails.builder().applyMutation(originDetails).build());
        }

        /**
         * <p>
         * The data set ID of the owned data set corresponding to the entitled data set being viewed. This parameter is
         * returned when a data set owner is viewing the entitled copy of its owned data set.
         * </p>
         * 
         * @param sourceId
         *        The data set ID of the owned data set corresponding to the entitled data set being viewed. This
         *        parameter is returned when a data set owner is viewing the entitled copy of its owned data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceId(String sourceId);

        /**
         * <p>
         * The date and time that the data set was last updated, in ISO 8601 format.
         * </p>
         * 
         * @param updatedAt
         *        The date and time that the data set was last updated, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String assetType;

        private Instant createdAt;

        private String description;

        private String id;

        private String name;

        private String origin;

        private OriginDetails originDetails;

        private String sourceId;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetEntry model) {
            arn(model.arn);
            assetType(model.assetType);
            createdAt(model.createdAt);
            description(model.description);
            id(model.id);
            name(model.name);
            origin(model.origin);
            originDetails(model.originDetails);
            sourceId(model.sourceId);
            updatedAt(model.updatedAt);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getAssetType() {
            return assetType;
        }

        @Override
        public final Builder assetType(String assetType) {
            this.assetType = assetType;
            return this;
        }

        @Override
        public final Builder assetType(AssetType assetType) {
            this.assetType(assetType == null ? null : assetType.toString());
            return this;
        }

        public final void setAssetType(String assetType) {
            this.assetType = assetType;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOrigin() {
            return origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(Origin origin) {
            this.origin(origin == null ? null : origin.toString());
            return this;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        public final OriginDetails.Builder getOriginDetails() {
            return originDetails != null ? originDetails.toBuilder() : null;
        }

        @Override
        public final Builder originDetails(OriginDetails originDetails) {
            this.originDetails = originDetails;
            return this;
        }

        public final void setOriginDetails(OriginDetails.BuilderImpl originDetails) {
            this.originDetails = originDetails != null ? originDetails.build() : null;
        }

        public final String getSourceId() {
            return sourceId;
        }

        @Override
        public final Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public final void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public DataSetEntry build() {
            return new DataSetEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
