/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dataexchange.model.AssetDetails;
import software.amazon.awssdk.services.dataexchange.model.AssetType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetEntry> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssetEntry.getter(AssetEntry::arn)).setter(AssetEntry.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<AssetDetails> ASSET_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AssetEntry.getter(AssetEntry::assetDetails)).setter(AssetEntry.setter(Builder::assetDetails)).constructor(AssetDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetDetails").build()}).build();
    private static final SdkField<String> ASSET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssetEntry.getter(AssetEntry::assetTypeAsString)).setter(AssetEntry.setter(Builder::assetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetType").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AssetEntry.getter(AssetEntry::createdAt)).setter(AssetEntry.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssetEntry.getter(AssetEntry::dataSetId)).setter(AssetEntry.setter(Builder::dataSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssetEntry.getter(AssetEntry::id)).setter(AssetEntry.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssetEntry.getter(AssetEntry::name)).setter(AssetEntry.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssetEntry.getter(AssetEntry::revisionId)).setter(AssetEntry.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()}).build();
    private static final SdkField<String> SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssetEntry.getter(AssetEntry::sourceId)).setter(AssetEntry.setter(Builder::sourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceId").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AssetEntry.getter(AssetEntry::updatedAt)).setter(AssetEntry.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ASSET_DETAILS_FIELD, ASSET_TYPE_FIELD, CREATED_AT_FIELD, DATA_SET_ID_FIELD, ID_FIELD, NAME_FIELD, REVISION_ID_FIELD, SOURCE_ID_FIELD, UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final AssetDetails assetDetails;
    private final String assetType;
    private final Instant createdAt;
    private final String dataSetId;
    private final String id;
    private final String name;
    private final String revisionId;
    private final String sourceId;
    private final Instant updatedAt;

    private AssetEntry(BuilderImpl builder) {
        this.arn = builder.arn;
        this.assetDetails = builder.assetDetails;
        this.assetType = builder.assetType;
        this.createdAt = builder.createdAt;
        this.dataSetId = builder.dataSetId;
        this.id = builder.id;
        this.name = builder.name;
        this.revisionId = builder.revisionId;
        this.sourceId = builder.sourceId;
        this.updatedAt = builder.updatedAt;
    }

    public String arn() {
        return this.arn;
    }

    public AssetDetails assetDetails() {
        return this.assetDetails;
    }

    public AssetType assetType() {
        return AssetType.fromValue(this.assetType);
    }

    public String assetTypeAsString() {
        return this.assetType;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public String dataSetId() {
        return this.dataSetId;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String revisionId() {
        return this.revisionId;
    }

    public String sourceId() {
        return this.sourceId;
    }

    public Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetEntry)) {
            return false;
        }
        AssetEntry other = (AssetEntry)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.assetDetails(), other.assetDetails()) && Objects.equals(this.assetTypeAsString(), other.assetTypeAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.dataSetId(), other.dataSetId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.revisionId(), other.revisionId()) && Objects.equals(this.sourceId(), other.sourceId()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public String toString() {
        return ToString.builder((String)"AssetEntry").add("Arn", (Object)this.arn()).add("AssetDetails", (Object)this.assetDetails()).add("AssetType", (Object)this.assetTypeAsString()).add("CreatedAt", (Object)this.createdAt()).add("DataSetId", (Object)this.dataSetId()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("RevisionId", (Object)this.revisionId()).add("SourceId", (Object)this.sourceId()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AssetDetails": {
                return Optional.ofNullable(clazz.cast(this.assetDetails()));
            }
            case "AssetType": {
                return Optional.ofNullable(clazz.cast(this.assetTypeAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "DataSetId": {
                return Optional.ofNullable(clazz.cast(this.dataSetId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RevisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
            case "SourceId": {
                return Optional.ofNullable(clazz.cast(this.sourceId()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetEntry, T> g) {
        return obj -> g.apply((AssetEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private AssetDetails assetDetails;
        private String assetType;
        private Instant createdAt;
        private String dataSetId;
        private String id;
        private String name;
        private String revisionId;
        private String sourceId;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetEntry model) {
            this.arn(model.arn);
            this.assetDetails(model.assetDetails);
            this.assetType(model.assetType);
            this.createdAt(model.createdAt);
            this.dataSetId(model.dataSetId);
            this.id(model.id);
            this.name(model.name);
            this.revisionId(model.revisionId);
            this.sourceId(model.sourceId);
            this.updatedAt(model.updatedAt);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final AssetDetails.Builder getAssetDetails() {
            return this.assetDetails != null ? this.assetDetails.toBuilder() : null;
        }

        @Override
        public final Builder assetDetails(AssetDetails assetDetails) {
            this.assetDetails = assetDetails;
            return this;
        }

        public final void setAssetDetails(AssetDetails.BuilderImpl assetDetails) {
            this.assetDetails = assetDetails != null ? assetDetails.build() : null;
        }

        public final String getAssetTypeAsString() {
            return this.assetType;
        }

        @Override
        public final Builder assetType(String assetType) {
            this.assetType = assetType;
            return this;
        }

        @Override
        public final Builder assetType(AssetType assetType) {
            this.assetType(assetType == null ? null : assetType.toString());
            return this;
        }

        public final void setAssetType(String assetType) {
            this.assetType = assetType;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDataSetId() {
            return this.dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        public final String getSourceId() {
            return this.sourceId;
        }

        @Override
        public final Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public final void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        public AssetEntry build() {
            return new AssetEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetEntry> {
        public Builder arn(String var1);

        public Builder assetDetails(AssetDetails var1);

        default public Builder assetDetails(Consumer<AssetDetails.Builder> assetDetails) {
            return this.assetDetails((AssetDetails)((AssetDetails.Builder)AssetDetails.builder().applyMutation(assetDetails)).build());
        }

        public Builder assetType(String var1);

        public Builder assetType(AssetType var1);

        public Builder createdAt(Instant var1);

        public Builder dataSetId(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder revisionId(String var1);

        public Builder sourceId(String var1);

        public Builder updatedAt(Instant var1);
    }
}

