/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportAssetToSignedUrlRequestDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportAssetToSignedUrlRequestDetails> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExportAssetToSignedUrlRequestDetails.getter(ExportAssetToSignedUrlRequestDetails::assetId)).setter(ExportAssetToSignedUrlRequestDetails.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetId").build()}).build();
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExportAssetToSignedUrlRequestDetails.getter(ExportAssetToSignedUrlRequestDetails::dataSetId)).setter(ExportAssetToSignedUrlRequestDetails.setter(Builder::dataSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExportAssetToSignedUrlRequestDetails.getter(ExportAssetToSignedUrlRequestDetails::revisionId)).setter(ExportAssetToSignedUrlRequestDetails.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD, DATA_SET_ID_FIELD, REVISION_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String assetId;
    private final String dataSetId;
    private final String revisionId;

    private ExportAssetToSignedUrlRequestDetails(BuilderImpl builder) {
        this.assetId = builder.assetId;
        this.dataSetId = builder.dataSetId;
        this.revisionId = builder.revisionId;
    }

    public String assetId() {
        return this.assetId;
    }

    public String dataSetId() {
        return this.dataSetId;
    }

    public String revisionId() {
        return this.revisionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportAssetToSignedUrlRequestDetails)) {
            return false;
        }
        ExportAssetToSignedUrlRequestDetails other = (ExportAssetToSignedUrlRequestDetails)obj;
        return Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.dataSetId(), other.dataSetId()) && Objects.equals(this.revisionId(), other.revisionId());
    }

    public String toString() {
        return ToString.builder((String)"ExportAssetToSignedUrlRequestDetails").add("AssetId", (Object)this.assetId()).add("DataSetId", (Object)this.dataSetId()).add("RevisionId", (Object)this.revisionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "DataSetId": {
                return Optional.ofNullable(clazz.cast(this.dataSetId()));
            }
            case "RevisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportAssetToSignedUrlRequestDetails, T> g) {
        return obj -> g.apply((ExportAssetToSignedUrlRequestDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String assetId;
        private String dataSetId;
        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportAssetToSignedUrlRequestDetails model) {
            this.assetId(model.assetId);
            this.dataSetId(model.dataSetId);
            this.revisionId(model.revisionId);
        }

        public final String getAssetId() {
            return this.assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        public final String getDataSetId() {
            return this.dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        public ExportAssetToSignedUrlRequestDetails build() {
            return new ExportAssetToSignedUrlRequestDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportAssetToSignedUrlRequestDetails> {
        public Builder assetId(String var1);

        public Builder dataSetId(String var1);

        public Builder revisionId(String var1);
    }
}

