/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request body for UpdateRevision.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRevisionRequest extends DataExchangeRequest implements
        ToCopyableBuilder<UpdateRevisionRequest.Builder, UpdateRevisionRequest> {
    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateRevisionRequest::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").build()).build();

    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateRevisionRequest::dataSetId)).setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataSetId").build()).build();

    private static final SdkField<Boolean> FINALIZED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateRevisionRequest::finalized)).setter(setter(Builder::finalized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Finalized").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateRevisionRequest::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("RevisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_FIELD,
            DATA_SET_ID_FIELD, FINALIZED_FIELD, REVISION_ID_FIELD));

    private final String comment;

    private final String dataSetId;

    private final Boolean finalized;

    private final String revisionId;

    private UpdateRevisionRequest(BuilderImpl builder) {
        super(builder);
        this.comment = builder.comment;
        this.dataSetId = builder.dataSetId;
        this.finalized = builder.finalized;
        this.revisionId = builder.revisionId;
    }

    /**
     * <p>
     * An optional comment about the revision.
     * </p>
     * 
     * @return An optional comment about the revision.
     */
    public String comment() {
        return comment;
    }

    /**
     * <p>
     * The unique identifier for a data set.
     * </p>
     * 
     * @return The unique identifier for a data set.
     */
    public String dataSetId() {
        return dataSetId;
    }

    /**
     * <p>
     * Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After
     * it's in this read-only state, you can publish the revision to your products.
     * </p>
     * 
     * @return Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are
     *         complete. After it's in this read-only state, you can publish the revision to your products.
     */
    public Boolean finalized() {
        return finalized;
    }

    /**
     * <p>
     * The unique identifier for a revision.
     * </p>
     * 
     * @return The unique identifier for a revision.
     */
    public String revisionId() {
        return revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(finalized());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRevisionRequest)) {
            return false;
        }
        UpdateRevisionRequest other = (UpdateRevisionRequest) obj;
        return Objects.equals(comment(), other.comment()) && Objects.equals(dataSetId(), other.dataSetId())
                && Objects.equals(finalized(), other.finalized()) && Objects.equals(revisionId(), other.revisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateRevisionRequest").add("Comment", comment()).add("DataSetId", dataSetId())
                .add("Finalized", finalized()).add("RevisionId", revisionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "Finalized":
            return Optional.ofNullable(clazz.cast(finalized()));
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRevisionRequest, T> g) {
        return obj -> g.apply((UpdateRevisionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataExchangeRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRevisionRequest> {
        /**
         * <p>
         * An optional comment about the revision.
         * </p>
         * 
         * @param comment
         *        An optional comment about the revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The unique identifier for a data set.
         * </p>
         * 
         * @param dataSetId
         *        The unique identifier for a data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete.
         * After it's in this read-only state, you can publish the revision to your products.
         * </p>
         * 
         * @param finalized
         *        Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are
         *        complete. After it's in this read-only state, you can publish the revision to your products.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalized(Boolean finalized);

        /**
         * <p>
         * The unique identifier for a revision.
         * </p>
         * 
         * @param revisionId
         *        The unique identifier for a revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataExchangeRequest.BuilderImpl implements Builder {
        private String comment;

        private String dataSetId;

        private Boolean finalized;

        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRevisionRequest model) {
            super(model);
            comment(model.comment);
            dataSetId(model.dataSetId);
            finalized(model.finalized);
            revisionId(model.revisionId);
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        public final Boolean getFinalized() {
            return finalized;
        }

        @Override
        public final Builder finalized(Boolean finalized) {
            this.finalized = finalized;
            return this;
        }

        public final void setFinalized(Boolean finalized) {
            this.finalized = finalized;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRevisionRequest build() {
            return new UpdateRevisionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
