/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the export to Amazon S3 response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportAssetsToS3ResponseDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportAssetsToS3ResponseDetails.Builder, ExportAssetsToS3ResponseDetails> {
    private static final SdkField<List<AssetDestinationEntry>> ASSET_DESTINATIONS_FIELD = SdkField
            .<List<AssetDestinationEntry>> builder(MarshallingType.LIST)
            .getter(getter(ExportAssetsToS3ResponseDetails::assetDestinations))
            .setter(setter(Builder::assetDestinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetDestinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetDestinationEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetDestinationEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportAssetsToS3ResponseDetails::dataSetId)).setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportAssetsToS3ResponseDetails::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_DESTINATIONS_FIELD,
            DATA_SET_ID_FIELD, REVISION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AssetDestinationEntry> assetDestinations;

    private final String dataSetId;

    private final String revisionId;

    private ExportAssetsToS3ResponseDetails(BuilderImpl builder) {
        this.assetDestinations = builder.assetDestinations;
        this.dataSetId = builder.dataSetId;
        this.revisionId = builder.revisionId;
    }

    /**
     * Returns true if the AssetDestinations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAssetDestinations() {
        return assetDestinations != null && !(assetDestinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The destination in Amazon S3 where the asset is exported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAssetDestinations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The destination in Amazon S3 where the asset is exported.
     */
    public List<AssetDestinationEntry> assetDestinations() {
        return assetDestinations;
    }

    /**
     * <p>
     * The unique identifier for the data set associated with this export job.
     * </p>
     * 
     * @return The unique identifier for the data set associated with this export job.
     */
    public String dataSetId() {
        return dataSetId;
    }

    /**
     * <p>
     * The unique identifier for the revision associated with this export response.
     * </p>
     * 
     * @return The unique identifier for the revision associated with this export response.
     */
    public String revisionId() {
        return revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetDestinations());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportAssetsToS3ResponseDetails)) {
            return false;
        }
        ExportAssetsToS3ResponseDetails other = (ExportAssetsToS3ResponseDetails) obj;
        return Objects.equals(assetDestinations(), other.assetDestinations()) && Objects.equals(dataSetId(), other.dataSetId())
                && Objects.equals(revisionId(), other.revisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ExportAssetsToS3ResponseDetails").add("AssetDestinations", assetDestinations())
                .add("DataSetId", dataSetId()).add("RevisionId", revisionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssetDestinations":
            return Optional.ofNullable(clazz.cast(assetDestinations()));
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportAssetsToS3ResponseDetails, T> g) {
        return obj -> g.apply((ExportAssetsToS3ResponseDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportAssetsToS3ResponseDetails> {
        /**
         * <p>
         * The destination in Amazon S3 where the asset is exported.
         * </p>
         * 
         * @param assetDestinations
         *        The destination in Amazon S3 where the asset is exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetDestinations(Collection<AssetDestinationEntry> assetDestinations);

        /**
         * <p>
         * The destination in Amazon S3 where the asset is exported.
         * </p>
         * 
         * @param assetDestinations
         *        The destination in Amazon S3 where the asset is exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetDestinations(AssetDestinationEntry... assetDestinations);

        /**
         * <p>
         * The destination in Amazon S3 where the asset is exported.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AssetDestinationEntry>.Builder} avoiding
         * the need to create one manually via {@link List<AssetDestinationEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssetDestinationEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #assetDestinations(List<AssetDestinationEntry>)}.
         * 
         * @param assetDestinations
         *        a consumer that will call methods on {@link List<AssetDestinationEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetDestinations(List<AssetDestinationEntry>)
         */
        Builder assetDestinations(Consumer<AssetDestinationEntry.Builder>... assetDestinations);

        /**
         * <p>
         * The unique identifier for the data set associated with this export job.
         * </p>
         * 
         * @param dataSetId
         *        The unique identifier for the data set associated with this export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * The unique identifier for the revision associated with this export response.
         * </p>
         * 
         * @param revisionId
         *        The unique identifier for the revision associated with this export response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);
    }

    static final class BuilderImpl implements Builder {
        private List<AssetDestinationEntry> assetDestinations = DefaultSdkAutoConstructList.getInstance();

        private String dataSetId;

        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportAssetsToS3ResponseDetails model) {
            assetDestinations(model.assetDestinations);
            dataSetId(model.dataSetId);
            revisionId(model.revisionId);
        }

        public final Collection<AssetDestinationEntry.Builder> getAssetDestinations() {
            return assetDestinations != null ? assetDestinations.stream().map(AssetDestinationEntry::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder assetDestinations(Collection<AssetDestinationEntry> assetDestinations) {
            this.assetDestinations = ListOfAssetDestinationEntryCopier.copy(assetDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetDestinations(AssetDestinationEntry... assetDestinations) {
            assetDestinations(Arrays.asList(assetDestinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetDestinations(Consumer<AssetDestinationEntry.Builder>... assetDestinations) {
            assetDestinations(Stream.of(assetDestinations).map(c -> AssetDestinationEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAssetDestinations(Collection<AssetDestinationEntry.BuilderImpl> assetDestinations) {
            this.assetDestinations = ListOfAssetDestinationEntryCopier.copyFromBuilder(assetDestinations);
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public ExportAssetsToS3ResponseDetails build() {
            return new ExportAssetsToS3ResponseDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
