/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetDetails implements SdkPojo, Serializable, ToCopyableBuilder<AssetDetails.Builder, AssetDetails> {
    private static final SdkField<S3SnapshotAsset> S3_SNAPSHOT_ASSET_FIELD = SdkField
            .<S3SnapshotAsset> builder(MarshallingType.SDK_POJO).getter(getter(AssetDetails::s3SnapshotAsset))
            .setter(setter(Builder::s3SnapshotAsset)).constructor(S3SnapshotAsset::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3SnapshotAsset").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_SNAPSHOT_ASSET_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3SnapshotAsset s3SnapshotAsset;

    private AssetDetails(BuilderImpl builder) {
        this.s3SnapshotAsset = builder.s3SnapshotAsset;
    }

    /**
     * Returns the value of the S3SnapshotAsset property for this object.
     * 
     * @return The value of the S3SnapshotAsset property for this object.
     */
    public S3SnapshotAsset s3SnapshotAsset() {
        return s3SnapshotAsset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3SnapshotAsset());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetDetails)) {
            return false;
        }
        AssetDetails other = (AssetDetails) obj;
        return Objects.equals(s3SnapshotAsset(), other.s3SnapshotAsset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssetDetails").add("S3SnapshotAsset", s3SnapshotAsset()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3SnapshotAsset":
            return Optional.ofNullable(clazz.cast(s3SnapshotAsset()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetDetails, T> g) {
        return obj -> g.apply((AssetDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetDetails> {
        /**
         * Sets the value of the S3SnapshotAsset property for this object.
         *
         * @param s3SnapshotAsset
         *        The new value for the S3SnapshotAsset property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3SnapshotAsset(S3SnapshotAsset s3SnapshotAsset);

        /**
         * Sets the value of the S3SnapshotAsset property for this object.
         *
         * This is a convenience that creates an instance of the {@link S3SnapshotAsset.Builder} avoiding the need to
         * create one manually via {@link S3SnapshotAsset#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3SnapshotAsset.Builder#build()} is called immediately and its
         * result is passed to {@link #s3SnapshotAsset(S3SnapshotAsset)}.
         * 
         * @param s3SnapshotAsset
         *        a consumer that will call methods on {@link S3SnapshotAsset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3SnapshotAsset(S3SnapshotAsset)
         */
        default Builder s3SnapshotAsset(Consumer<S3SnapshotAsset.Builder> s3SnapshotAsset) {
            return s3SnapshotAsset(S3SnapshotAsset.builder().applyMutation(s3SnapshotAsset).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3SnapshotAsset s3SnapshotAsset;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetDetails model) {
            s3SnapshotAsset(model.s3SnapshotAsset);
        }

        public final S3SnapshotAsset.Builder getS3SnapshotAsset() {
            return s3SnapshotAsset != null ? s3SnapshotAsset.toBuilder() : null;
        }

        @Override
        public final Builder s3SnapshotAsset(S3SnapshotAsset s3SnapshotAsset) {
            this.s3SnapshotAsset = s3SnapshotAsset;
            return this;
        }

        public final void setS3SnapshotAsset(S3SnapshotAsset.BuilderImpl s3SnapshotAsset) {
            this.s3SnapshotAsset = s3SnapshotAsset != null ? s3SnapshotAsset.build() : null;
        }

        @Override
        public AssetDetails build() {
            return new AssetDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
