/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dataexchange.model.AssetType;
import software.amazon.awssdk.services.dataexchange.model.DataExchangeResponse;
import software.amazon.awssdk.services.dataexchange.model.MapOf__stringCopier;
import software.amazon.awssdk.services.dataexchange.model.Origin;
import software.amazon.awssdk.services.dataexchange.model.OriginDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataSetResponse
extends DataExchangeResponse
implements ToCopyableBuilder<Builder, CreateDataSetResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDataSetResponse.getter(CreateDataSetResponse::arn)).setter(CreateDataSetResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ASSET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDataSetResponse.getter(CreateDataSetResponse::assetTypeAsString)).setter(CreateDataSetResponse.setter(Builder::assetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetType").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CreateDataSetResponse.getter(CreateDataSetResponse::createdAt)).setter(CreateDataSetResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDataSetResponse.getter(CreateDataSetResponse::description)).setter(CreateDataSetResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDataSetResponse.getter(CreateDataSetResponse::id)).setter(CreateDataSetResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDataSetResponse.getter(CreateDataSetResponse::name)).setter(CreateDataSetResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDataSetResponse.getter(CreateDataSetResponse::originAsString)).setter(CreateDataSetResponse.setter(Builder::origin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin").build()}).build();
    private static final SdkField<OriginDetails> ORIGIN_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateDataSetResponse.getter(CreateDataSetResponse::originDetails)).setter(CreateDataSetResponse.setter(Builder::originDetails)).constructor(OriginDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginDetails").build()}).build();
    private static final SdkField<String> SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDataSetResponse.getter(CreateDataSetResponse::sourceId)).setter(CreateDataSetResponse.setter(Builder::sourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateDataSetResponse.getter(CreateDataSetResponse::tags)).setter(CreateDataSetResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CreateDataSetResponse.getter(CreateDataSetResponse::updatedAt)).setter(CreateDataSetResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ASSET_TYPE_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, ID_FIELD, NAME_FIELD, ORIGIN_FIELD, ORIGIN_DETAILS_FIELD, SOURCE_ID_FIELD, TAGS_FIELD, UPDATED_AT_FIELD));
    private final String arn;
    private final String assetType;
    private final Instant createdAt;
    private final String description;
    private final String id;
    private final String name;
    private final String origin;
    private final OriginDetails originDetails;
    private final String sourceId;
    private final Map<String, String> tags;
    private final Instant updatedAt;

    private CreateDataSetResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.assetType = builder.assetType;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.id = builder.id;
        this.name = builder.name;
        this.origin = builder.origin;
        this.originDetails = builder.originDetails;
        this.sourceId = builder.sourceId;
        this.tags = builder.tags;
        this.updatedAt = builder.updatedAt;
    }

    public String arn() {
        return this.arn;
    }

    public AssetType assetType() {
        return AssetType.fromValue(this.assetType);
    }

    public String assetTypeAsString() {
        return this.assetType;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public String description() {
        return this.description;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public Origin origin() {
        return Origin.fromValue(this.origin);
    }

    public String originAsString() {
        return this.origin;
    }

    public OriginDetails originDetails() {
        return this.originDetails;
    }

    public String sourceId() {
        return this.sourceId;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.originAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.originDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSetResponse)) {
            return false;
        }
        CreateDataSetResponse other = (CreateDataSetResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.assetTypeAsString(), other.assetTypeAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.originAsString(), other.originAsString()) && Objects.equals(this.originDetails(), other.originDetails()) && Objects.equals(this.sourceId(), other.sourceId()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public String toString() {
        return ToString.builder((String)"CreateDataSetResponse").add("Arn", (Object)this.arn()).add("AssetType", (Object)this.assetTypeAsString()).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)this.description()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Origin", (Object)this.originAsString()).add("OriginDetails", (Object)this.originDetails()).add("SourceId", (Object)this.sourceId()).add("Tags", this.tags()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AssetType": {
                return Optional.ofNullable(clazz.cast(this.assetTypeAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Origin": {
                return Optional.ofNullable(clazz.cast(this.originAsString()));
            }
            case "OriginDetails": {
                return Optional.ofNullable(clazz.cast(this.originDetails()));
            }
            case "SourceId": {
                return Optional.ofNullable(clazz.cast(this.sourceId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataSetResponse, T> g) {
        return obj -> g.apply((CreateDataSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataExchangeResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String assetType;
        private Instant createdAt;
        private String description;
        private String id;
        private String name;
        private String origin;
        private OriginDetails originDetails;
        private String sourceId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSetResponse model) {
            super(model);
            this.arn(model.arn);
            this.assetType(model.assetType);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.id(model.id);
            this.name(model.name);
            this.origin(model.origin);
            this.originDetails(model.originDetails);
            this.sourceId(model.sourceId);
            this.tags(model.tags);
            this.updatedAt(model.updatedAt);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getAssetTypeAsString() {
            return this.assetType;
        }

        @Override
        public final Builder assetType(String assetType) {
            this.assetType = assetType;
            return this;
        }

        @Override
        public final Builder assetType(AssetType assetType) {
            this.assetType(assetType == null ? null : assetType.toString());
            return this;
        }

        public final void setAssetType(String assetType) {
            this.assetType = assetType;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOriginAsString() {
            return this.origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(Origin origin) {
            this.origin(origin == null ? null : origin.toString());
            return this;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        public final OriginDetails.Builder getOriginDetails() {
            return this.originDetails != null ? this.originDetails.toBuilder() : null;
        }

        @Override
        public final Builder originDetails(OriginDetails originDetails) {
            this.originDetails = originDetails;
            return this;
        }

        public final void setOriginDetails(OriginDetails.BuilderImpl originDetails) {
            this.originDetails = originDetails != null ? originDetails.build() : null;
        }

        public final String getSourceId() {
            return this.sourceId;
        }

        @Override
        public final Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public final void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public CreateDataSetResponse build() {
            return new CreateDataSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataExchangeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataSetResponse> {
        public Builder arn(String var1);

        public Builder assetType(String var1);

        public Builder assetType(AssetType var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder origin(String var1);

        public Builder origin(Origin var1);

        public Builder originDetails(OriginDetails var1);

        default public Builder originDetails(Consumer<OriginDetails.Builder> originDetails) {
            return this.originDetails((OriginDetails)((OriginDetails.Builder)OriginDetails.builder().applyMutation(originDetails)).build());
        }

        public Builder sourceId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder updatedAt(Instant var1);
    }
}

