/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databrew.model.ValidationMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ValidationConfiguration> {
    private static final SdkField<String> RULESET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RulesetArn").getter(ValidationConfiguration.getter(ValidationConfiguration::rulesetArn)).setter(ValidationConfiguration.setter(Builder::rulesetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RulesetArn").build()}).build();
    private static final SdkField<String> VALIDATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationMode").getter(ValidationConfiguration.getter(ValidationConfiguration::validationModeAsString)).setter(ValidationConfiguration.setter(Builder::validationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULESET_ARN_FIELD, VALIDATION_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String rulesetArn;
    private final String validationMode;

    private ValidationConfiguration(BuilderImpl builder) {
        this.rulesetArn = builder.rulesetArn;
        this.validationMode = builder.validationMode;
    }

    public final String rulesetArn() {
        return this.rulesetArn;
    }

    public final ValidationMode validationMode() {
        return ValidationMode.fromValue(this.validationMode);
    }

    public final String validationModeAsString() {
        return this.validationMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rulesetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationConfiguration)) {
            return false;
        }
        ValidationConfiguration other = (ValidationConfiguration)obj;
        return Objects.equals(this.rulesetArn(), other.rulesetArn()) && Objects.equals(this.validationModeAsString(), other.validationModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ValidationConfiguration").add("RulesetArn", (Object)this.rulesetArn()).add("ValidationMode", (Object)this.validationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RulesetArn": {
                return Optional.ofNullable(clazz.cast(this.rulesetArn()));
            }
            case "ValidationMode": {
                return Optional.ofNullable(clazz.cast(this.validationModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidationConfiguration, T> g) {
        return obj -> g.apply((ValidationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String rulesetArn;
        private String validationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationConfiguration model) {
            this.rulesetArn(model.rulesetArn);
            this.validationMode(model.validationMode);
        }

        public final String getRulesetArn() {
            return this.rulesetArn;
        }

        public final void setRulesetArn(String rulesetArn) {
            this.rulesetArn = rulesetArn;
        }

        @Override
        public final Builder rulesetArn(String rulesetArn) {
            this.rulesetArn = rulesetArn;
            return this;
        }

        public final String getValidationMode() {
            return this.validationMode;
        }

        public final void setValidationMode(String validationMode) {
            this.validationMode = validationMode;
        }

        @Override
        public final Builder validationMode(String validationMode) {
            this.validationMode = validationMode;
            return this;
        }

        @Override
        public final Builder validationMode(ValidationMode validationMode) {
            this.validationMode(validationMode == null ? null : validationMode.toString());
            return this;
        }

        public ValidationConfiguration build() {
            return new ValidationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ValidationConfiguration> {
        public Builder rulesetArn(String var1);

        public Builder validationMode(String var1);

        public Builder validationMode(ValidationMode var1);
    }
}

