/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.databrew.DataBrewClient;
import software.amazon.awssdk.services.databrew.DataBrewClientBuilder;
import software.amazon.awssdk.services.databrew.DataBrewServiceClientConfiguration;
import software.amazon.awssdk.services.databrew.DefaultDataBrewBaseClientBuilder;
import software.amazon.awssdk.services.databrew.DefaultDataBrewClient;
import software.amazon.awssdk.services.databrew.endpoints.DataBrewEndpointProvider;

@SdkInternalApi
final class DefaultDataBrewClientBuilder
extends DefaultDataBrewBaseClientBuilder<DataBrewClientBuilder, DataBrewClient>
implements DataBrewClientBuilder {
    DefaultDataBrewClientBuilder() {
    }

    @Override
    public DefaultDataBrewClientBuilder endpointProvider(DataBrewEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DataBrewClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultDataBrewClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        DataBrewServiceClientConfiguration serviceClientConfiguration = DataBrewServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultDataBrewClient(serviceClientConfiguration, clientConfiguration);
    }
}

