/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SampleType {
    FIRST_N("FIRST_N"),
    LAST_N("LAST_N"),
    RANDOM("RANDOM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SampleType> VALUE_MAP;
    private final String value;

    private SampleType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SampleType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SampleType> knownValues() {
        EnumSet<SampleType> knownValues = EnumSet.allOf(SampleType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SampleType.class, SampleType::toString);
    }
}

