/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.MessageFormatValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KinesisSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KinesisSettings> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(KinesisSettings.getter(KinesisSettings::streamArn)).setter(KinesisSettings.setter(Builder::streamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamArn").build()}).build();
    private static final SdkField<String> MESSAGE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(KinesisSettings.getter(KinesisSettings::messageFormatAsString)).setter(KinesisSettings.setter(Builder::messageFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageFormat").build()}).build();
    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(KinesisSettings.getter(KinesisSettings::serviceAccessRoleArn)).setter(KinesisSettings.setter(Builder::serviceAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD, MESSAGE_FORMAT_FIELD, SERVICE_ACCESS_ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String streamArn;
    private final String messageFormat;
    private final String serviceAccessRoleArn;

    private KinesisSettings(BuilderImpl builder) {
        this.streamArn = builder.streamArn;
        this.messageFormat = builder.messageFormat;
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
    }

    public String streamArn() {
        return this.streamArn;
    }

    public MessageFormatValue messageFormat() {
        return MessageFormatValue.fromValue(this.messageFormat);
    }

    public String messageFormatAsString() {
        return this.messageFormat;
    }

    public String serviceAccessRoleArn() {
        return this.serviceAccessRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccessRoleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisSettings)) {
            return false;
        }
        KinesisSettings other = (KinesisSettings)obj;
        return Objects.equals(this.streamArn(), other.streamArn()) && Objects.equals(this.messageFormatAsString(), other.messageFormatAsString()) && Objects.equals(this.serviceAccessRoleArn(), other.serviceAccessRoleArn());
    }

    public String toString() {
        return ToString.builder((String)"KinesisSettings").add("StreamArn", (Object)this.streamArn()).add("MessageFormat", (Object)this.messageFormatAsString()).add("ServiceAccessRoleArn", (Object)this.serviceAccessRoleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamArn": {
                return Optional.ofNullable(clazz.cast(this.streamArn()));
            }
            case "MessageFormat": {
                return Optional.ofNullable(clazz.cast(this.messageFormatAsString()));
            }
            case "ServiceAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceAccessRoleArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KinesisSettings, T> g) {
        return obj -> g.apply((KinesisSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String streamArn;
        private String messageFormat;
        private String serviceAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisSettings model) {
            this.streamArn(model.streamArn);
            this.messageFormat(model.messageFormat);
            this.serviceAccessRoleArn(model.serviceAccessRoleArn);
        }

        public final String getStreamArn() {
            return this.streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        public final String getMessageFormatAsString() {
            return this.messageFormat;
        }

        @Override
        public final Builder messageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
            return this;
        }

        @Override
        public final Builder messageFormat(MessageFormatValue messageFormat) {
            this.messageFormat(messageFormat.toString());
            return this;
        }

        public final void setMessageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
        }

        public final String getServiceAccessRoleArn() {
            return this.serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        public KinesisSettings build() {
            return new KinesisSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KinesisSettings> {
        public Builder streamArn(String var1);

        public Builder messageFormat(String var1);

        public Builder messageFormat(MessageFormatValue var1);

        public Builder serviceAccessRoleArn(String var1);
    }
}

