/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.CompressionTypeValue;
import software.amazon.awssdk.services.databasemigration.model.DataFormatValue;
import software.amazon.awssdk.services.databasemigration.model.EncodingTypeValue;
import software.amazon.awssdk.services.databasemigration.model.EncryptionModeValue;
import software.amazon.awssdk.services.databasemigration.model.ParquetVersionValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Settings> {
    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Settings.getter(S3Settings::serviceAccessRoleArn)).setter(S3Settings.setter(Builder::serviceAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build()}).build();
    private static final SdkField<String> EXTERNAL_TABLE_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Settings.getter(S3Settings::externalTableDefinition)).setter(S3Settings.setter(Builder::externalTableDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalTableDefinition").build()}).build();
    private static final SdkField<String> CSV_ROW_DELIMITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Settings.getter(S3Settings::csvRowDelimiter)).setter(S3Settings.setter(Builder::csvRowDelimiter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvRowDelimiter").build()}).build();
    private static final SdkField<String> CSV_DELIMITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Settings.getter(S3Settings::csvDelimiter)).setter(S3Settings.setter(Builder::csvDelimiter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvDelimiter").build()}).build();
    private static final SdkField<String> BUCKET_FOLDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Settings.getter(S3Settings::bucketFolder)).setter(S3Settings.setter(Builder::bucketFolder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketFolder").build()}).build();
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Settings.getter(S3Settings::bucketName)).setter(S3Settings.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()}).build();
    private static final SdkField<String> COMPRESSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Settings.getter(S3Settings::compressionTypeAsString)).setter(S3Settings.setter(Builder::compressionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompressionType").build()}).build();
    private static final SdkField<String> ENCRYPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Settings.getter(S3Settings::encryptionModeAsString)).setter(S3Settings.setter(Builder::encryptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionMode").build()}).build();
    private static final SdkField<String> SERVER_SIDE_ENCRYPTION_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Settings.getter(S3Settings::serverSideEncryptionKmsKeyId)).setter(S3Settings.setter(Builder::serverSideEncryptionKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideEncryptionKmsKeyId").build()}).build();
    private static final SdkField<String> DATA_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Settings.getter(S3Settings::dataFormatAsString)).setter(S3Settings.setter(Builder::dataFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormat").build()}).build();
    private static final SdkField<String> ENCODING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Settings.getter(S3Settings::encodingTypeAsString)).setter(S3Settings.setter(Builder::encodingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncodingType").build()}).build();
    private static final SdkField<Integer> DICT_PAGE_SIZE_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(S3Settings.getter(S3Settings::dictPageSizeLimit)).setter(S3Settings.setter(Builder::dictPageSizeLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DictPageSizeLimit").build()}).build();
    private static final SdkField<Integer> ROW_GROUP_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(S3Settings.getter(S3Settings::rowGroupLength)).setter(S3Settings.setter(Builder::rowGroupLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowGroupLength").build()}).build();
    private static final SdkField<Integer> DATA_PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(S3Settings.getter(S3Settings::dataPageSize)).setter(S3Settings.setter(Builder::dataPageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPageSize").build()}).build();
    private static final SdkField<String> PARQUET_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Settings.getter(S3Settings::parquetVersionAsString)).setter(S3Settings.setter(Builder::parquetVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParquetVersion").build()}).build();
    private static final SdkField<Boolean> ENABLE_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(S3Settings.getter(S3Settings::enableStatistics)).setter(S3Settings.setter(Builder::enableStatistics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableStatistics").build()}).build();
    private static final SdkField<Boolean> INCLUDE_OP_FOR_FULL_LOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(S3Settings.getter(S3Settings::includeOpForFullLoad)).setter(S3Settings.setter(Builder::includeOpForFullLoad)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeOpForFullLoad").build()}).build();
    private static final SdkField<Boolean> CDC_INSERTS_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(S3Settings.getter(S3Settings::cdcInsertsOnly)).setter(S3Settings.setter(Builder::cdcInsertsOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcInsertsOnly").build()}).build();
    private static final SdkField<String> TIMESTAMP_COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Settings.getter(S3Settings::timestampColumnName)).setter(S3Settings.setter(Builder::timestampColumnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampColumnName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACCESS_ROLE_ARN_FIELD, EXTERNAL_TABLE_DEFINITION_FIELD, CSV_ROW_DELIMITER_FIELD, CSV_DELIMITER_FIELD, BUCKET_FOLDER_FIELD, BUCKET_NAME_FIELD, COMPRESSION_TYPE_FIELD, ENCRYPTION_MODE_FIELD, SERVER_SIDE_ENCRYPTION_KMS_KEY_ID_FIELD, DATA_FORMAT_FIELD, ENCODING_TYPE_FIELD, DICT_PAGE_SIZE_LIMIT_FIELD, ROW_GROUP_LENGTH_FIELD, DATA_PAGE_SIZE_FIELD, PARQUET_VERSION_FIELD, ENABLE_STATISTICS_FIELD, INCLUDE_OP_FOR_FULL_LOAD_FIELD, CDC_INSERTS_ONLY_FIELD, TIMESTAMP_COLUMN_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serviceAccessRoleArn;
    private final String externalTableDefinition;
    private final String csvRowDelimiter;
    private final String csvDelimiter;
    private final String bucketFolder;
    private final String bucketName;
    private final String compressionType;
    private final String encryptionMode;
    private final String serverSideEncryptionKmsKeyId;
    private final String dataFormat;
    private final String encodingType;
    private final Integer dictPageSizeLimit;
    private final Integer rowGroupLength;
    private final Integer dataPageSize;
    private final String parquetVersion;
    private final Boolean enableStatistics;
    private final Boolean includeOpForFullLoad;
    private final Boolean cdcInsertsOnly;
    private final String timestampColumnName;

    private S3Settings(BuilderImpl builder) {
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.externalTableDefinition = builder.externalTableDefinition;
        this.csvRowDelimiter = builder.csvRowDelimiter;
        this.csvDelimiter = builder.csvDelimiter;
        this.bucketFolder = builder.bucketFolder;
        this.bucketName = builder.bucketName;
        this.compressionType = builder.compressionType;
        this.encryptionMode = builder.encryptionMode;
        this.serverSideEncryptionKmsKeyId = builder.serverSideEncryptionKmsKeyId;
        this.dataFormat = builder.dataFormat;
        this.encodingType = builder.encodingType;
        this.dictPageSizeLimit = builder.dictPageSizeLimit;
        this.rowGroupLength = builder.rowGroupLength;
        this.dataPageSize = builder.dataPageSize;
        this.parquetVersion = builder.parquetVersion;
        this.enableStatistics = builder.enableStatistics;
        this.includeOpForFullLoad = builder.includeOpForFullLoad;
        this.cdcInsertsOnly = builder.cdcInsertsOnly;
        this.timestampColumnName = builder.timestampColumnName;
    }

    public String serviceAccessRoleArn() {
        return this.serviceAccessRoleArn;
    }

    public String externalTableDefinition() {
        return this.externalTableDefinition;
    }

    public String csvRowDelimiter() {
        return this.csvRowDelimiter;
    }

    public String csvDelimiter() {
        return this.csvDelimiter;
    }

    public String bucketFolder() {
        return this.bucketFolder;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public CompressionTypeValue compressionType() {
        return CompressionTypeValue.fromValue(this.compressionType);
    }

    public String compressionTypeAsString() {
        return this.compressionType;
    }

    public EncryptionModeValue encryptionMode() {
        return EncryptionModeValue.fromValue(this.encryptionMode);
    }

    public String encryptionModeAsString() {
        return this.encryptionMode;
    }

    public String serverSideEncryptionKmsKeyId() {
        return this.serverSideEncryptionKmsKeyId;
    }

    public DataFormatValue dataFormat() {
        return DataFormatValue.fromValue(this.dataFormat);
    }

    public String dataFormatAsString() {
        return this.dataFormat;
    }

    public EncodingTypeValue encodingType() {
        return EncodingTypeValue.fromValue(this.encodingType);
    }

    public String encodingTypeAsString() {
        return this.encodingType;
    }

    public Integer dictPageSizeLimit() {
        return this.dictPageSizeLimit;
    }

    public Integer rowGroupLength() {
        return this.rowGroupLength;
    }

    public Integer dataPageSize() {
        return this.dataPageSize;
    }

    public ParquetVersionValue parquetVersion() {
        return ParquetVersionValue.fromValue(this.parquetVersion);
    }

    public String parquetVersionAsString() {
        return this.parquetVersion;
    }

    public Boolean enableStatistics() {
        return this.enableStatistics;
    }

    public Boolean includeOpForFullLoad() {
        return this.includeOpForFullLoad;
    }

    public Boolean cdcInsertsOnly() {
        return this.cdcInsertsOnly;
    }

    public String timestampColumnName() {
        return this.timestampColumnName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalTableDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.csvRowDelimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.csvDelimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketFolder());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideEncryptionKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encodingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dictPageSizeLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowGroupLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataPageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.parquetVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeOpForFullLoad());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcInsertsOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampColumnName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Settings)) {
            return false;
        }
        S3Settings other = (S3Settings)obj;
        return Objects.equals(this.serviceAccessRoleArn(), other.serviceAccessRoleArn()) && Objects.equals(this.externalTableDefinition(), other.externalTableDefinition()) && Objects.equals(this.csvRowDelimiter(), other.csvRowDelimiter()) && Objects.equals(this.csvDelimiter(), other.csvDelimiter()) && Objects.equals(this.bucketFolder(), other.bucketFolder()) && Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.compressionTypeAsString(), other.compressionTypeAsString()) && Objects.equals(this.encryptionModeAsString(), other.encryptionModeAsString()) && Objects.equals(this.serverSideEncryptionKmsKeyId(), other.serverSideEncryptionKmsKeyId()) && Objects.equals(this.dataFormatAsString(), other.dataFormatAsString()) && Objects.equals(this.encodingTypeAsString(), other.encodingTypeAsString()) && Objects.equals(this.dictPageSizeLimit(), other.dictPageSizeLimit()) && Objects.equals(this.rowGroupLength(), other.rowGroupLength()) && Objects.equals(this.dataPageSize(), other.dataPageSize()) && Objects.equals(this.parquetVersionAsString(), other.parquetVersionAsString()) && Objects.equals(this.enableStatistics(), other.enableStatistics()) && Objects.equals(this.includeOpForFullLoad(), other.includeOpForFullLoad()) && Objects.equals(this.cdcInsertsOnly(), other.cdcInsertsOnly()) && Objects.equals(this.timestampColumnName(), other.timestampColumnName());
    }

    public String toString() {
        return ToString.builder((String)"S3Settings").add("ServiceAccessRoleArn", (Object)this.serviceAccessRoleArn()).add("ExternalTableDefinition", (Object)this.externalTableDefinition()).add("CsvRowDelimiter", (Object)this.csvRowDelimiter()).add("CsvDelimiter", (Object)this.csvDelimiter()).add("BucketFolder", (Object)this.bucketFolder()).add("BucketName", (Object)this.bucketName()).add("CompressionType", (Object)this.compressionTypeAsString()).add("EncryptionMode", (Object)this.encryptionModeAsString()).add("ServerSideEncryptionKmsKeyId", (Object)this.serverSideEncryptionKmsKeyId()).add("DataFormat", (Object)this.dataFormatAsString()).add("EncodingType", (Object)this.encodingTypeAsString()).add("DictPageSizeLimit", (Object)this.dictPageSizeLimit()).add("RowGroupLength", (Object)this.rowGroupLength()).add("DataPageSize", (Object)this.dataPageSize()).add("ParquetVersion", (Object)this.parquetVersionAsString()).add("EnableStatistics", (Object)this.enableStatistics()).add("IncludeOpForFullLoad", (Object)this.includeOpForFullLoad()).add("CdcInsertsOnly", (Object)this.cdcInsertsOnly()).add("TimestampColumnName", (Object)this.timestampColumnName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceAccessRoleArn()));
            }
            case "ExternalTableDefinition": {
                return Optional.ofNullable(clazz.cast(this.externalTableDefinition()));
            }
            case "CsvRowDelimiter": {
                return Optional.ofNullable(clazz.cast(this.csvRowDelimiter()));
            }
            case "CsvDelimiter": {
                return Optional.ofNullable(clazz.cast(this.csvDelimiter()));
            }
            case "BucketFolder": {
                return Optional.ofNullable(clazz.cast(this.bucketFolder()));
            }
            case "BucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "CompressionType": {
                return Optional.ofNullable(clazz.cast(this.compressionTypeAsString()));
            }
            case "EncryptionMode": {
                return Optional.ofNullable(clazz.cast(this.encryptionModeAsString()));
            }
            case "ServerSideEncryptionKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.serverSideEncryptionKmsKeyId()));
            }
            case "DataFormat": {
                return Optional.ofNullable(clazz.cast(this.dataFormatAsString()));
            }
            case "EncodingType": {
                return Optional.ofNullable(clazz.cast(this.encodingTypeAsString()));
            }
            case "DictPageSizeLimit": {
                return Optional.ofNullable(clazz.cast(this.dictPageSizeLimit()));
            }
            case "RowGroupLength": {
                return Optional.ofNullable(clazz.cast(this.rowGroupLength()));
            }
            case "DataPageSize": {
                return Optional.ofNullable(clazz.cast(this.dataPageSize()));
            }
            case "ParquetVersion": {
                return Optional.ofNullable(clazz.cast(this.parquetVersionAsString()));
            }
            case "EnableStatistics": {
                return Optional.ofNullable(clazz.cast(this.enableStatistics()));
            }
            case "IncludeOpForFullLoad": {
                return Optional.ofNullable(clazz.cast(this.includeOpForFullLoad()));
            }
            case "CdcInsertsOnly": {
                return Optional.ofNullable(clazz.cast(this.cdcInsertsOnly()));
            }
            case "TimestampColumnName": {
                return Optional.ofNullable(clazz.cast(this.timestampColumnName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Settings, T> g) {
        return obj -> g.apply((S3Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceAccessRoleArn;
        private String externalTableDefinition;
        private String csvRowDelimiter;
        private String csvDelimiter;
        private String bucketFolder;
        private String bucketName;
        private String compressionType;
        private String encryptionMode;
        private String serverSideEncryptionKmsKeyId;
        private String dataFormat;
        private String encodingType;
        private Integer dictPageSizeLimit;
        private Integer rowGroupLength;
        private Integer dataPageSize;
        private String parquetVersion;
        private Boolean enableStatistics;
        private Boolean includeOpForFullLoad;
        private Boolean cdcInsertsOnly;
        private String timestampColumnName;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Settings model) {
            this.serviceAccessRoleArn(model.serviceAccessRoleArn);
            this.externalTableDefinition(model.externalTableDefinition);
            this.csvRowDelimiter(model.csvRowDelimiter);
            this.csvDelimiter(model.csvDelimiter);
            this.bucketFolder(model.bucketFolder);
            this.bucketName(model.bucketName);
            this.compressionType(model.compressionType);
            this.encryptionMode(model.encryptionMode);
            this.serverSideEncryptionKmsKeyId(model.serverSideEncryptionKmsKeyId);
            this.dataFormat(model.dataFormat);
            this.encodingType(model.encodingType);
            this.dictPageSizeLimit(model.dictPageSizeLimit);
            this.rowGroupLength(model.rowGroupLength);
            this.dataPageSize(model.dataPageSize);
            this.parquetVersion(model.parquetVersion);
            this.enableStatistics(model.enableStatistics);
            this.includeOpForFullLoad(model.includeOpForFullLoad);
            this.cdcInsertsOnly(model.cdcInsertsOnly);
            this.timestampColumnName(model.timestampColumnName);
        }

        public final String getServiceAccessRoleArn() {
            return this.serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        public final String getExternalTableDefinition() {
            return this.externalTableDefinition;
        }

        @Override
        public final Builder externalTableDefinition(String externalTableDefinition) {
            this.externalTableDefinition = externalTableDefinition;
            return this;
        }

        public final void setExternalTableDefinition(String externalTableDefinition) {
            this.externalTableDefinition = externalTableDefinition;
        }

        public final String getCsvRowDelimiter() {
            return this.csvRowDelimiter;
        }

        @Override
        public final Builder csvRowDelimiter(String csvRowDelimiter) {
            this.csvRowDelimiter = csvRowDelimiter;
            return this;
        }

        public final void setCsvRowDelimiter(String csvRowDelimiter) {
            this.csvRowDelimiter = csvRowDelimiter;
        }

        public final String getCsvDelimiter() {
            return this.csvDelimiter;
        }

        @Override
        public final Builder csvDelimiter(String csvDelimiter) {
            this.csvDelimiter = csvDelimiter;
            return this;
        }

        public final void setCsvDelimiter(String csvDelimiter) {
            this.csvDelimiter = csvDelimiter;
        }

        public final String getBucketFolder() {
            return this.bucketFolder;
        }

        @Override
        public final Builder bucketFolder(String bucketFolder) {
            this.bucketFolder = bucketFolder;
            return this;
        }

        public final void setBucketFolder(String bucketFolder) {
            this.bucketFolder = bucketFolder;
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getCompressionTypeAsString() {
            return this.compressionType;
        }

        @Override
        public final Builder compressionType(String compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        @Override
        public final Builder compressionType(CompressionTypeValue compressionType) {
            this.compressionType(compressionType == null ? null : compressionType.toString());
            return this;
        }

        public final void setCompressionType(String compressionType) {
            this.compressionType = compressionType;
        }

        public final String getEncryptionModeAsString() {
            return this.encryptionMode;
        }

        @Override
        public final Builder encryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
            return this;
        }

        @Override
        public final Builder encryptionMode(EncryptionModeValue encryptionMode) {
            this.encryptionMode(encryptionMode == null ? null : encryptionMode.toString());
            return this;
        }

        public final void setEncryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
        }

        public final String getServerSideEncryptionKmsKeyId() {
            return this.serverSideEncryptionKmsKeyId;
        }

        @Override
        public final Builder serverSideEncryptionKmsKeyId(String serverSideEncryptionKmsKeyId) {
            this.serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId;
            return this;
        }

        public final void setServerSideEncryptionKmsKeyId(String serverSideEncryptionKmsKeyId) {
            this.serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId;
        }

        public final String getDataFormatAsString() {
            return this.dataFormat;
        }

        @Override
        public final Builder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        public final Builder dataFormat(DataFormatValue dataFormat) {
            this.dataFormat(dataFormat == null ? null : dataFormat.toString());
            return this;
        }

        public final void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        public final String getEncodingTypeAsString() {
            return this.encodingType;
        }

        @Override
        public final Builder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        @Override
        public final Builder encodingType(EncodingTypeValue encodingType) {
            this.encodingType(encodingType == null ? null : encodingType.toString());
            return this;
        }

        public final void setEncodingType(String encodingType) {
            this.encodingType = encodingType;
        }

        public final Integer getDictPageSizeLimit() {
            return this.dictPageSizeLimit;
        }

        @Override
        public final Builder dictPageSizeLimit(Integer dictPageSizeLimit) {
            this.dictPageSizeLimit = dictPageSizeLimit;
            return this;
        }

        public final void setDictPageSizeLimit(Integer dictPageSizeLimit) {
            this.dictPageSizeLimit = dictPageSizeLimit;
        }

        public final Integer getRowGroupLength() {
            return this.rowGroupLength;
        }

        @Override
        public final Builder rowGroupLength(Integer rowGroupLength) {
            this.rowGroupLength = rowGroupLength;
            return this;
        }

        public final void setRowGroupLength(Integer rowGroupLength) {
            this.rowGroupLength = rowGroupLength;
        }

        public final Integer getDataPageSize() {
            return this.dataPageSize;
        }

        @Override
        public final Builder dataPageSize(Integer dataPageSize) {
            this.dataPageSize = dataPageSize;
            return this;
        }

        public final void setDataPageSize(Integer dataPageSize) {
            this.dataPageSize = dataPageSize;
        }

        public final String getParquetVersionAsString() {
            return this.parquetVersion;
        }

        @Override
        public final Builder parquetVersion(String parquetVersion) {
            this.parquetVersion = parquetVersion;
            return this;
        }

        @Override
        public final Builder parquetVersion(ParquetVersionValue parquetVersion) {
            this.parquetVersion(parquetVersion == null ? null : parquetVersion.toString());
            return this;
        }

        public final void setParquetVersion(String parquetVersion) {
            this.parquetVersion = parquetVersion;
        }

        public final Boolean getEnableStatistics() {
            return this.enableStatistics;
        }

        @Override
        public final Builder enableStatistics(Boolean enableStatistics) {
            this.enableStatistics = enableStatistics;
            return this;
        }

        public final void setEnableStatistics(Boolean enableStatistics) {
            this.enableStatistics = enableStatistics;
        }

        public final Boolean getIncludeOpForFullLoad() {
            return this.includeOpForFullLoad;
        }

        @Override
        public final Builder includeOpForFullLoad(Boolean includeOpForFullLoad) {
            this.includeOpForFullLoad = includeOpForFullLoad;
            return this;
        }

        public final void setIncludeOpForFullLoad(Boolean includeOpForFullLoad) {
            this.includeOpForFullLoad = includeOpForFullLoad;
        }

        public final Boolean getCdcInsertsOnly() {
            return this.cdcInsertsOnly;
        }

        @Override
        public final Builder cdcInsertsOnly(Boolean cdcInsertsOnly) {
            this.cdcInsertsOnly = cdcInsertsOnly;
            return this;
        }

        public final void setCdcInsertsOnly(Boolean cdcInsertsOnly) {
            this.cdcInsertsOnly = cdcInsertsOnly;
        }

        public final String getTimestampColumnName() {
            return this.timestampColumnName;
        }

        @Override
        public final Builder timestampColumnName(String timestampColumnName) {
            this.timestampColumnName = timestampColumnName;
            return this;
        }

        public final void setTimestampColumnName(String timestampColumnName) {
            this.timestampColumnName = timestampColumnName;
        }

        public S3Settings build() {
            return new S3Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Settings> {
        public Builder serviceAccessRoleArn(String var1);

        public Builder externalTableDefinition(String var1);

        public Builder csvRowDelimiter(String var1);

        public Builder csvDelimiter(String var1);

        public Builder bucketFolder(String var1);

        public Builder bucketName(String var1);

        public Builder compressionType(String var1);

        public Builder compressionType(CompressionTypeValue var1);

        public Builder encryptionMode(String var1);

        public Builder encryptionMode(EncryptionModeValue var1);

        public Builder serverSideEncryptionKmsKeyId(String var1);

        public Builder dataFormat(String var1);

        public Builder dataFormat(DataFormatValue var1);

        public Builder encodingType(String var1);

        public Builder encodingType(EncodingTypeValue var1);

        public Builder dictPageSizeLimit(Integer var1);

        public Builder rowGroupLength(Integer var1);

        public Builder dataPageSize(Integer var1);

        public Builder parquetVersion(String var1);

        public Builder parquetVersion(ParquetVersionValue var1);

        public Builder enableStatistics(Boolean var1);

        public Builder includeOpForFullLoad(Boolean var1);

        public Builder cdcInsertsOnly(Boolean var1);

        public Builder timestampColumnName(String var1);
    }
}

