/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a schema in a Fleet Advisor collector inventory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchemaResponse implements SdkPojo, Serializable, ToCopyableBuilder<SchemaResponse.Builder, SchemaResponse> {
    private static final SdkField<Long> CODE_LINE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CodeLineCount").getter(getter(SchemaResponse::codeLineCount)).setter(setter(Builder::codeLineCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeLineCount").build()).build();

    private static final SdkField<Long> CODE_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("CodeSize")
            .getter(getter(SchemaResponse::codeSize)).setter(setter(Builder::codeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSize").build()).build();

    private static final SdkField<String> COMPLEXITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Complexity").getter(getter(SchemaResponse::complexity)).setter(setter(Builder::complexity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Complexity").build()).build();

    private static final SdkField<ServerShortInfoResponse> SERVER_FIELD = SdkField
            .<ServerShortInfoResponse> builder(MarshallingType.SDK_POJO).memberName("Server")
            .getter(getter(SchemaResponse::server)).setter(setter(Builder::server)).constructor(ServerShortInfoResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Server").build()).build();

    private static final SdkField<DatabaseShortInfoResponse> DATABASE_INSTANCE_FIELD = SdkField
            .<DatabaseShortInfoResponse> builder(MarshallingType.SDK_POJO).memberName("DatabaseInstance")
            .getter(getter(SchemaResponse::databaseInstance)).setter(setter(Builder::databaseInstance))
            .constructor(DatabaseShortInfoResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseInstance").build()).build();

    private static final SdkField<String> SCHEMA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaId").getter(getter(SchemaResponse::schemaId)).setter(setter(Builder::schemaId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaId").build()).build();

    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaName").getter(getter(SchemaResponse::schemaName)).setter(setter(Builder::schemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaName").build()).build();

    private static final SdkField<SchemaShortInfoResponse> ORIGINAL_SCHEMA_FIELD = SdkField
            .<SchemaShortInfoResponse> builder(MarshallingType.SDK_POJO).memberName("OriginalSchema")
            .getter(getter(SchemaResponse::originalSchema)).setter(setter(Builder::originalSchema))
            .constructor(SchemaShortInfoResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalSchema").build()).build();

    private static final SdkField<Double> SIMILARITY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Similarity").getter(getter(SchemaResponse::similarity)).setter(setter(Builder::similarity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Similarity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_LINE_COUNT_FIELD,
            CODE_SIZE_FIELD, COMPLEXITY_FIELD, SERVER_FIELD, DATABASE_INSTANCE_FIELD, SCHEMA_ID_FIELD, SCHEMA_NAME_FIELD,
            ORIGINAL_SCHEMA_FIELD, SIMILARITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long codeLineCount;

    private final Long codeSize;

    private final String complexity;

    private final ServerShortInfoResponse server;

    private final DatabaseShortInfoResponse databaseInstance;

    private final String schemaId;

    private final String schemaName;

    private final SchemaShortInfoResponse originalSchema;

    private final Double similarity;

    private SchemaResponse(BuilderImpl builder) {
        this.codeLineCount = builder.codeLineCount;
        this.codeSize = builder.codeSize;
        this.complexity = builder.complexity;
        this.server = builder.server;
        this.databaseInstance = builder.databaseInstance;
        this.schemaId = builder.schemaId;
        this.schemaName = builder.schemaName;
        this.originalSchema = builder.originalSchema;
        this.similarity = builder.similarity;
    }

    /**
     * <p>
     * The number of lines of code in a schema in a Fleet Advisor collector inventory.
     * </p>
     * 
     * @return The number of lines of code in a schema in a Fleet Advisor collector inventory.
     */
    public final Long codeLineCount() {
        return codeLineCount;
    }

    /**
     * <p>
     * The size level of the code in a schema in a Fleet Advisor collector inventory.
     * </p>
     * 
     * @return The size level of the code in a schema in a Fleet Advisor collector inventory.
     */
    public final Long codeSize() {
        return codeSize;
    }

    /**
     * <p>
     * The complexity level of the code in a schema in a Fleet Advisor collector inventory.
     * </p>
     * 
     * @return The complexity level of the code in a schema in a Fleet Advisor collector inventory.
     */
    public final String complexity() {
        return complexity;
    }

    /**
     * <p>
     * The database server for a schema in a Fleet Advisor collector inventory.
     * </p>
     * 
     * @return The database server for a schema in a Fleet Advisor collector inventory.
     */
    public final ServerShortInfoResponse server() {
        return server;
    }

    /**
     * <p>
     * The database for a schema in a Fleet Advisor collector inventory.
     * </p>
     * 
     * @return The database for a schema in a Fleet Advisor collector inventory.
     */
    public final DatabaseShortInfoResponse databaseInstance() {
        return databaseInstance;
    }

    /**
     * <p>
     * The ID of a schema in a Fleet Advisor collector inventory.
     * </p>
     * 
     * @return The ID of a schema in a Fleet Advisor collector inventory.
     */
    public final String schemaId() {
        return schemaId;
    }

    /**
     * <p>
     * The name of a schema in a Fleet Advisor collector inventory.
     * </p>
     * 
     * @return The name of a schema in a Fleet Advisor collector inventory.
     */
    public final String schemaName() {
        return schemaName;
    }

    /**
     * Returns the value of the OriginalSchema property for this object.
     * 
     * @return The value of the OriginalSchema property for this object.
     */
    public final SchemaShortInfoResponse originalSchema() {
        return originalSchema;
    }

    /**
     * <p>
     * The similarity value for a schema in a Fleet Advisor collector inventory. A higher similarity value indicates
     * that a schema is likely to be a duplicate.
     * </p>
     * 
     * @return The similarity value for a schema in a Fleet Advisor collector inventory. A higher similarity value
     *         indicates that a schema is likely to be a duplicate.
     */
    public final Double similarity() {
        return similarity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeLineCount());
        hashCode = 31 * hashCode + Objects.hashCode(codeSize());
        hashCode = 31 * hashCode + Objects.hashCode(complexity());
        hashCode = 31 * hashCode + Objects.hashCode(server());
        hashCode = 31 * hashCode + Objects.hashCode(databaseInstance());
        hashCode = 31 * hashCode + Objects.hashCode(schemaId());
        hashCode = 31 * hashCode + Objects.hashCode(schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(originalSchema());
        hashCode = 31 * hashCode + Objects.hashCode(similarity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaResponse)) {
            return false;
        }
        SchemaResponse other = (SchemaResponse) obj;
        return Objects.equals(codeLineCount(), other.codeLineCount()) && Objects.equals(codeSize(), other.codeSize())
                && Objects.equals(complexity(), other.complexity()) && Objects.equals(server(), other.server())
                && Objects.equals(databaseInstance(), other.databaseInstance()) && Objects.equals(schemaId(), other.schemaId())
                && Objects.equals(schemaName(), other.schemaName()) && Objects.equals(originalSchema(), other.originalSchema())
                && Objects.equals(similarity(), other.similarity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SchemaResponse").add("CodeLineCount", codeLineCount()).add("CodeSize", codeSize())
                .add("Complexity", complexity()).add("Server", server()).add("DatabaseInstance", databaseInstance())
                .add("SchemaId", schemaId()).add("SchemaName", schemaName()).add("OriginalSchema", originalSchema())
                .add("Similarity", similarity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeLineCount":
            return Optional.ofNullable(clazz.cast(codeLineCount()));
        case "CodeSize":
            return Optional.ofNullable(clazz.cast(codeSize()));
        case "Complexity":
            return Optional.ofNullable(clazz.cast(complexity()));
        case "Server":
            return Optional.ofNullable(clazz.cast(server()));
        case "DatabaseInstance":
            return Optional.ofNullable(clazz.cast(databaseInstance()));
        case "SchemaId":
            return Optional.ofNullable(clazz.cast(schemaId()));
        case "SchemaName":
            return Optional.ofNullable(clazz.cast(schemaName()));
        case "OriginalSchema":
            return Optional.ofNullable(clazz.cast(originalSchema()));
        case "Similarity":
            return Optional.ofNullable(clazz.cast(similarity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CodeLineCount", CODE_LINE_COUNT_FIELD);
        map.put("CodeSize", CODE_SIZE_FIELD);
        map.put("Complexity", COMPLEXITY_FIELD);
        map.put("Server", SERVER_FIELD);
        map.put("DatabaseInstance", DATABASE_INSTANCE_FIELD);
        map.put("SchemaId", SCHEMA_ID_FIELD);
        map.put("SchemaName", SCHEMA_NAME_FIELD);
        map.put("OriginalSchema", ORIGINAL_SCHEMA_FIELD);
        map.put("Similarity", SIMILARITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SchemaResponse, T> g) {
        return obj -> g.apply((SchemaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchemaResponse> {
        /**
         * <p>
         * The number of lines of code in a schema in a Fleet Advisor collector inventory.
         * </p>
         * 
         * @param codeLineCount
         *        The number of lines of code in a schema in a Fleet Advisor collector inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeLineCount(Long codeLineCount);

        /**
         * <p>
         * The size level of the code in a schema in a Fleet Advisor collector inventory.
         * </p>
         * 
         * @param codeSize
         *        The size level of the code in a schema in a Fleet Advisor collector inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSize(Long codeSize);

        /**
         * <p>
         * The complexity level of the code in a schema in a Fleet Advisor collector inventory.
         * </p>
         * 
         * @param complexity
         *        The complexity level of the code in a schema in a Fleet Advisor collector inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complexity(String complexity);

        /**
         * <p>
         * The database server for a schema in a Fleet Advisor collector inventory.
         * </p>
         * 
         * @param server
         *        The database server for a schema in a Fleet Advisor collector inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder server(ServerShortInfoResponse server);

        /**
         * <p>
         * The database server for a schema in a Fleet Advisor collector inventory.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServerShortInfoResponse.Builder} avoiding
         * the need to create one manually via {@link ServerShortInfoResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerShortInfoResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #server(ServerShortInfoResponse)}.
         * 
         * @param server
         *        a consumer that will call methods on {@link ServerShortInfoResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #server(ServerShortInfoResponse)
         */
        default Builder server(Consumer<ServerShortInfoResponse.Builder> server) {
            return server(ServerShortInfoResponse.builder().applyMutation(server).build());
        }

        /**
         * <p>
         * The database for a schema in a Fleet Advisor collector inventory.
         * </p>
         * 
         * @param databaseInstance
         *        The database for a schema in a Fleet Advisor collector inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseInstance(DatabaseShortInfoResponse databaseInstance);

        /**
         * <p>
         * The database for a schema in a Fleet Advisor collector inventory.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatabaseShortInfoResponse.Builder}
         * avoiding the need to create one manually via {@link DatabaseShortInfoResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatabaseShortInfoResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #databaseInstance(DatabaseShortInfoResponse)}.
         * 
         * @param databaseInstance
         *        a consumer that will call methods on {@link DatabaseShortInfoResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #databaseInstance(DatabaseShortInfoResponse)
         */
        default Builder databaseInstance(Consumer<DatabaseShortInfoResponse.Builder> databaseInstance) {
            return databaseInstance(DatabaseShortInfoResponse.builder().applyMutation(databaseInstance).build());
        }

        /**
         * <p>
         * The ID of a schema in a Fleet Advisor collector inventory.
         * </p>
         * 
         * @param schemaId
         *        The ID of a schema in a Fleet Advisor collector inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaId(String schemaId);

        /**
         * <p>
         * The name of a schema in a Fleet Advisor collector inventory.
         * </p>
         * 
         * @param schemaName
         *        The name of a schema in a Fleet Advisor collector inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaName(String schemaName);

        /**
         * Sets the value of the OriginalSchema property for this object.
         *
         * @param originalSchema
         *        The new value for the OriginalSchema property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalSchema(SchemaShortInfoResponse originalSchema);

        /**
         * Sets the value of the OriginalSchema property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SchemaShortInfoResponse.Builder} avoiding
         * the need to create one manually via {@link SchemaShortInfoResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchemaShortInfoResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #originalSchema(SchemaShortInfoResponse)}.
         * 
         * @param originalSchema
         *        a consumer that will call methods on {@link SchemaShortInfoResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #originalSchema(SchemaShortInfoResponse)
         */
        default Builder originalSchema(Consumer<SchemaShortInfoResponse.Builder> originalSchema) {
            return originalSchema(SchemaShortInfoResponse.builder().applyMutation(originalSchema).build());
        }

        /**
         * <p>
         * The similarity value for a schema in a Fleet Advisor collector inventory. A higher similarity value indicates
         * that a schema is likely to be a duplicate.
         * </p>
         * 
         * @param similarity
         *        The similarity value for a schema in a Fleet Advisor collector inventory. A higher similarity value
         *        indicates that a schema is likely to be a duplicate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder similarity(Double similarity);
    }

    static final class BuilderImpl implements Builder {
        private Long codeLineCount;

        private Long codeSize;

        private String complexity;

        private ServerShortInfoResponse server;

        private DatabaseShortInfoResponse databaseInstance;

        private String schemaId;

        private String schemaName;

        private SchemaShortInfoResponse originalSchema;

        private Double similarity;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaResponse model) {
            codeLineCount(model.codeLineCount);
            codeSize(model.codeSize);
            complexity(model.complexity);
            server(model.server);
            databaseInstance(model.databaseInstance);
            schemaId(model.schemaId);
            schemaName(model.schemaName);
            originalSchema(model.originalSchema);
            similarity(model.similarity);
        }

        public final Long getCodeLineCount() {
            return codeLineCount;
        }

        public final void setCodeLineCount(Long codeLineCount) {
            this.codeLineCount = codeLineCount;
        }

        @Override
        public final Builder codeLineCount(Long codeLineCount) {
            this.codeLineCount = codeLineCount;
            return this;
        }

        public final Long getCodeSize() {
            return codeSize;
        }

        public final void setCodeSize(Long codeSize) {
            this.codeSize = codeSize;
        }

        @Override
        public final Builder codeSize(Long codeSize) {
            this.codeSize = codeSize;
            return this;
        }

        public final String getComplexity() {
            return complexity;
        }

        public final void setComplexity(String complexity) {
            this.complexity = complexity;
        }

        @Override
        public final Builder complexity(String complexity) {
            this.complexity = complexity;
            return this;
        }

        public final ServerShortInfoResponse.Builder getServer() {
            return server != null ? server.toBuilder() : null;
        }

        public final void setServer(ServerShortInfoResponse.BuilderImpl server) {
            this.server = server != null ? server.build() : null;
        }

        @Override
        public final Builder server(ServerShortInfoResponse server) {
            this.server = server;
            return this;
        }

        public final DatabaseShortInfoResponse.Builder getDatabaseInstance() {
            return databaseInstance != null ? databaseInstance.toBuilder() : null;
        }

        public final void setDatabaseInstance(DatabaseShortInfoResponse.BuilderImpl databaseInstance) {
            this.databaseInstance = databaseInstance != null ? databaseInstance.build() : null;
        }

        @Override
        public final Builder databaseInstance(DatabaseShortInfoResponse databaseInstance) {
            this.databaseInstance = databaseInstance;
            return this;
        }

        public final String getSchemaId() {
            return schemaId;
        }

        public final void setSchemaId(String schemaId) {
            this.schemaId = schemaId;
        }

        @Override
        public final Builder schemaId(String schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public final String getSchemaName() {
            return schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final SchemaShortInfoResponse.Builder getOriginalSchema() {
            return originalSchema != null ? originalSchema.toBuilder() : null;
        }

        public final void setOriginalSchema(SchemaShortInfoResponse.BuilderImpl originalSchema) {
            this.originalSchema = originalSchema != null ? originalSchema.build() : null;
        }

        @Override
        public final Builder originalSchema(SchemaShortInfoResponse originalSchema) {
            this.originalSchema = originalSchema;
            return this;
        }

        public final Double getSimilarity() {
            return similarity;
        }

        public final void setSimilarity(Double similarity) {
            this.similarity = similarity;
        }

        @Override
        public final Builder similarity(Double similarity) {
            this.similarity = similarity;
            return this;
        }

        @Override
        public SchemaResponse build() {
            return new SchemaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
