/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about provisioning resources for an DMS serverless replication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionData implements SdkPojo, Serializable, ToCopyableBuilder<ProvisionData.Builder, ProvisionData> {
    private static final SdkField<String> PROVISION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisionState").getter(getter(ProvisionData::provisionState)).setter(setter(Builder::provisionState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionState").build()).build();

    private static final SdkField<Integer> PROVISIONED_CAPACITY_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ProvisionedCapacityUnits").getter(getter(ProvisionData::provisionedCapacityUnits))
            .setter(setter(Builder::provisionedCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedCapacityUnits").build())
            .build();

    private static final SdkField<Instant> DATE_PROVISIONED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DateProvisioned").getter(getter(ProvisionData::dateProvisioned))
            .setter(setter(Builder::dateProvisioned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateProvisioned").build()).build();

    private static final SdkField<Boolean> IS_NEW_PROVISIONING_AVAILABLE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsNewProvisioningAvailable")
            .getter(getter(ProvisionData::isNewProvisioningAvailable))
            .setter(setter(Builder::isNewProvisioningAvailable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsNewProvisioningAvailable").build())
            .build();

    private static final SdkField<Instant> DATE_NEW_PROVISIONING_DATA_AVAILABLE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("DateNewProvisioningDataAvailable")
            .getter(getter(ProvisionData::dateNewProvisioningDataAvailable))
            .setter(setter(Builder::dateNewProvisioningDataAvailable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateNewProvisioningDataAvailable")
                    .build()).build();

    private static final SdkField<String> REASON_FOR_NEW_PROVISIONING_DATA_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReasonForNewProvisioningData")
            .getter(getter(ProvisionData::reasonForNewProvisioningData))
            .setter(setter(Builder::reasonForNewProvisioningData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReasonForNewProvisioningData")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISION_STATE_FIELD,
            PROVISIONED_CAPACITY_UNITS_FIELD, DATE_PROVISIONED_FIELD, IS_NEW_PROVISIONING_AVAILABLE_FIELD,
            DATE_NEW_PROVISIONING_DATA_AVAILABLE_FIELD, REASON_FOR_NEW_PROVISIONING_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String provisionState;

    private final Integer provisionedCapacityUnits;

    private final Instant dateProvisioned;

    private final Boolean isNewProvisioningAvailable;

    private final Instant dateNewProvisioningDataAvailable;

    private final String reasonForNewProvisioningData;

    private ProvisionData(BuilderImpl builder) {
        this.provisionState = builder.provisionState;
        this.provisionedCapacityUnits = builder.provisionedCapacityUnits;
        this.dateProvisioned = builder.dateProvisioned;
        this.isNewProvisioningAvailable = builder.isNewProvisioningAvailable;
        this.dateNewProvisioningDataAvailable = builder.dateNewProvisioningDataAvailable;
        this.reasonForNewProvisioningData = builder.reasonForNewProvisioningData;
    }

    /**
     * <p>
     * The current provisioning state
     * </p>
     * 
     * @return The current provisioning state
     */
    public final String provisionState() {
        return provisionState;
    }

    /**
     * <p>
     * The number of capacity units the replication is using.
     * </p>
     * 
     * @return The number of capacity units the replication is using.
     */
    public final Integer provisionedCapacityUnits() {
        return provisionedCapacityUnits;
    }

    /**
     * <p>
     * The timestamp when DMS provisioned replication resources.
     * </p>
     * 
     * @return The timestamp when DMS provisioned replication resources.
     */
    public final Instant dateProvisioned() {
        return dateProvisioned;
    }

    /**
     * <p>
     * Whether the new provisioning is available to the replication.
     * </p>
     * 
     * @return Whether the new provisioning is available to the replication.
     */
    public final Boolean isNewProvisioningAvailable() {
        return isNewProvisioningAvailable;
    }

    /**
     * <p>
     * The timestamp when provisioning became available.
     * </p>
     * 
     * @return The timestamp when provisioning became available.
     */
    public final Instant dateNewProvisioningDataAvailable() {
        return dateNewProvisioningDataAvailable;
    }

    /**
     * <p>
     * A message describing the reason that DMS provisioned new resources for the serverless replication.
     * </p>
     * 
     * @return A message describing the reason that DMS provisioned new resources for the serverless replication.
     */
    public final String reasonForNewProvisioningData() {
        return reasonForNewProvisioningData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(provisionState());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(dateProvisioned());
        hashCode = 31 * hashCode + Objects.hashCode(isNewProvisioningAvailable());
        hashCode = 31 * hashCode + Objects.hashCode(dateNewProvisioningDataAvailable());
        hashCode = 31 * hashCode + Objects.hashCode(reasonForNewProvisioningData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionData)) {
            return false;
        }
        ProvisionData other = (ProvisionData) obj;
        return Objects.equals(provisionState(), other.provisionState())
                && Objects.equals(provisionedCapacityUnits(), other.provisionedCapacityUnits())
                && Objects.equals(dateProvisioned(), other.dateProvisioned())
                && Objects.equals(isNewProvisioningAvailable(), other.isNewProvisioningAvailable())
                && Objects.equals(dateNewProvisioningDataAvailable(), other.dateNewProvisioningDataAvailable())
                && Objects.equals(reasonForNewProvisioningData(), other.reasonForNewProvisioningData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisionData").add("ProvisionState", provisionState())
                .add("ProvisionedCapacityUnits", provisionedCapacityUnits()).add("DateProvisioned", dateProvisioned())
                .add("IsNewProvisioningAvailable", isNewProvisioningAvailable())
                .add("DateNewProvisioningDataAvailable", dateNewProvisioningDataAvailable())
                .add("ReasonForNewProvisioningData", reasonForNewProvisioningData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProvisionState":
            return Optional.ofNullable(clazz.cast(provisionState()));
        case "ProvisionedCapacityUnits":
            return Optional.ofNullable(clazz.cast(provisionedCapacityUnits()));
        case "DateProvisioned":
            return Optional.ofNullable(clazz.cast(dateProvisioned()));
        case "IsNewProvisioningAvailable":
            return Optional.ofNullable(clazz.cast(isNewProvisioningAvailable()));
        case "DateNewProvisioningDataAvailable":
            return Optional.ofNullable(clazz.cast(dateNewProvisioningDataAvailable()));
        case "ReasonForNewProvisioningData":
            return Optional.ofNullable(clazz.cast(reasonForNewProvisioningData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProvisionState", PROVISION_STATE_FIELD);
        map.put("ProvisionedCapacityUnits", PROVISIONED_CAPACITY_UNITS_FIELD);
        map.put("DateProvisioned", DATE_PROVISIONED_FIELD);
        map.put("IsNewProvisioningAvailable", IS_NEW_PROVISIONING_AVAILABLE_FIELD);
        map.put("DateNewProvisioningDataAvailable", DATE_NEW_PROVISIONING_DATA_AVAILABLE_FIELD);
        map.put("ReasonForNewProvisioningData", REASON_FOR_NEW_PROVISIONING_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisionData, T> g) {
        return obj -> g.apply((ProvisionData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisionData> {
        /**
         * <p>
         * The current provisioning state
         * </p>
         * 
         * @param provisionState
         *        The current provisioning state
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionState(String provisionState);

        /**
         * <p>
         * The number of capacity units the replication is using.
         * </p>
         * 
         * @param provisionedCapacityUnits
         *        The number of capacity units the replication is using.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedCapacityUnits(Integer provisionedCapacityUnits);

        /**
         * <p>
         * The timestamp when DMS provisioned replication resources.
         * </p>
         * 
         * @param dateProvisioned
         *        The timestamp when DMS provisioned replication resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateProvisioned(Instant dateProvisioned);

        /**
         * <p>
         * Whether the new provisioning is available to the replication.
         * </p>
         * 
         * @param isNewProvisioningAvailable
         *        Whether the new provisioning is available to the replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isNewProvisioningAvailable(Boolean isNewProvisioningAvailable);

        /**
         * <p>
         * The timestamp when provisioning became available.
         * </p>
         * 
         * @param dateNewProvisioningDataAvailable
         *        The timestamp when provisioning became available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateNewProvisioningDataAvailable(Instant dateNewProvisioningDataAvailable);

        /**
         * <p>
         * A message describing the reason that DMS provisioned new resources for the serverless replication.
         * </p>
         * 
         * @param reasonForNewProvisioningData
         *        A message describing the reason that DMS provisioned new resources for the serverless replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonForNewProvisioningData(String reasonForNewProvisioningData);
    }

    static final class BuilderImpl implements Builder {
        private String provisionState;

        private Integer provisionedCapacityUnits;

        private Instant dateProvisioned;

        private Boolean isNewProvisioningAvailable;

        private Instant dateNewProvisioningDataAvailable;

        private String reasonForNewProvisioningData;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionData model) {
            provisionState(model.provisionState);
            provisionedCapacityUnits(model.provisionedCapacityUnits);
            dateProvisioned(model.dateProvisioned);
            isNewProvisioningAvailable(model.isNewProvisioningAvailable);
            dateNewProvisioningDataAvailable(model.dateNewProvisioningDataAvailable);
            reasonForNewProvisioningData(model.reasonForNewProvisioningData);
        }

        public final String getProvisionState() {
            return provisionState;
        }

        public final void setProvisionState(String provisionState) {
            this.provisionState = provisionState;
        }

        @Override
        public final Builder provisionState(String provisionState) {
            this.provisionState = provisionState;
            return this;
        }

        public final Integer getProvisionedCapacityUnits() {
            return provisionedCapacityUnits;
        }

        public final void setProvisionedCapacityUnits(Integer provisionedCapacityUnits) {
            this.provisionedCapacityUnits = provisionedCapacityUnits;
        }

        @Override
        public final Builder provisionedCapacityUnits(Integer provisionedCapacityUnits) {
            this.provisionedCapacityUnits = provisionedCapacityUnits;
            return this;
        }

        public final Instant getDateProvisioned() {
            return dateProvisioned;
        }

        public final void setDateProvisioned(Instant dateProvisioned) {
            this.dateProvisioned = dateProvisioned;
        }

        @Override
        public final Builder dateProvisioned(Instant dateProvisioned) {
            this.dateProvisioned = dateProvisioned;
            return this;
        }

        public final Boolean getIsNewProvisioningAvailable() {
            return isNewProvisioningAvailable;
        }

        public final void setIsNewProvisioningAvailable(Boolean isNewProvisioningAvailable) {
            this.isNewProvisioningAvailable = isNewProvisioningAvailable;
        }

        @Override
        public final Builder isNewProvisioningAvailable(Boolean isNewProvisioningAvailable) {
            this.isNewProvisioningAvailable = isNewProvisioningAvailable;
            return this;
        }

        public final Instant getDateNewProvisioningDataAvailable() {
            return dateNewProvisioningDataAvailable;
        }

        public final void setDateNewProvisioningDataAvailable(Instant dateNewProvisioningDataAvailable) {
            this.dateNewProvisioningDataAvailable = dateNewProvisioningDataAvailable;
        }

        @Override
        public final Builder dateNewProvisioningDataAvailable(Instant dateNewProvisioningDataAvailable) {
            this.dateNewProvisioningDataAvailable = dateNewProvisioningDataAvailable;
            return this;
        }

        public final String getReasonForNewProvisioningData() {
            return reasonForNewProvisioningData;
        }

        public final void setReasonForNewProvisioningData(String reasonForNewProvisioningData) {
            this.reasonForNewProvisioningData = reasonForNewProvisioningData;
        }

        @Override
        public final Builder reasonForNewProvisioningData(String reasonForNewProvisioningData) {
            this.reasonForNewProvisioningData = reasonForNewProvisioningData;
            return this;
        }

        @Override
        public ProvisionData build() {
            return new ProvisionData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
