/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyReplicationInstanceRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<ModifyReplicationInstanceRequest.Builder, ModifyReplicationInstanceRequest> {
    private static final SdkField<String> REPLICATION_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationInstanceArn").getter(getter(ModifyReplicationInstanceRequest::replicationInstanceArn))
            .setter(setter(Builder::replicationInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceArn").build())
            .build();

    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocatedStorage").getter(getter(ModifyReplicationInstanceRequest::allocatedStorage))
            .setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()).build();

    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ApplyImmediately").getter(getter(ModifyReplicationInstanceRequest::applyImmediately))
            .setter(setter(Builder::applyImmediately))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()).build();

    private static final SdkField<String> REPLICATION_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationInstanceClass").getter(getter(ModifyReplicationInstanceRequest::replicationInstanceClass))
            .setter(setter(Builder::replicationInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceClass").build())
            .build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroupIds")
            .getter(getter(ModifyReplicationInstanceRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(ModifyReplicationInstanceRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAZ").getter(getter(ModifyReplicationInstanceRequest::multiAZ)).setter(setter(Builder::multiAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(ModifyReplicationInstanceRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Boolean> ALLOW_MAJOR_VERSION_UPGRADE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("AllowMajorVersionUpgrade")
            .getter(getter(ModifyReplicationInstanceRequest::allowMajorVersionUpgrade))
            .setter(setter(Builder::allowMajorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowMajorVersionUpgrade").build())
            .build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(ModifyReplicationInstanceRequest::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<String> REPLICATION_INSTANCE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReplicationInstanceIdentifier")
            .getter(getter(ModifyReplicationInstanceRequest::replicationInstanceIdentifier))
            .setter(setter(Builder::replicationInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceIdentifier")
                    .build()).build();

    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkType").getter(getter(ModifyReplicationInstanceRequest::networkType))
            .setter(setter(Builder::networkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()).build();

    private static final SdkField<KerberosAuthenticationSettings> KERBEROS_AUTHENTICATION_SETTINGS_FIELD = SdkField
            .<KerberosAuthenticationSettings> builder(MarshallingType.SDK_POJO)
            .memberName("KerberosAuthenticationSettings")
            .getter(getter(ModifyReplicationInstanceRequest::kerberosAuthenticationSettings))
            .setter(setter(Builder::kerberosAuthenticationSettings))
            .constructor(KerberosAuthenticationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KerberosAuthenticationSettings")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REPLICATION_INSTANCE_ARN_FIELD, ALLOCATED_STORAGE_FIELD, APPLY_IMMEDIATELY_FIELD, REPLICATION_INSTANCE_CLASS_FIELD,
            VPC_SECURITY_GROUP_IDS_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, MULTI_AZ_FIELD, ENGINE_VERSION_FIELD,
            ALLOW_MAJOR_VERSION_UPGRADE_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, REPLICATION_INSTANCE_IDENTIFIER_FIELD,
            NETWORK_TYPE_FIELD, KERBEROS_AUTHENTICATION_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String replicationInstanceArn;

    private final Integer allocatedStorage;

    private final Boolean applyImmediately;

    private final String replicationInstanceClass;

    private final List<String> vpcSecurityGroupIds;

    private final String preferredMaintenanceWindow;

    private final Boolean multiAZ;

    private final String engineVersion;

    private final Boolean allowMajorVersionUpgrade;

    private final Boolean autoMinorVersionUpgrade;

    private final String replicationInstanceIdentifier;

    private final String networkType;

    private final KerberosAuthenticationSettings kerberosAuthenticationSettings;

    private ModifyReplicationInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.replicationInstanceArn = builder.replicationInstanceArn;
        this.allocatedStorage = builder.allocatedStorage;
        this.applyImmediately = builder.applyImmediately;
        this.replicationInstanceClass = builder.replicationInstanceClass;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.multiAZ = builder.multiAZ;
        this.engineVersion = builder.engineVersion;
        this.allowMajorVersionUpgrade = builder.allowMajorVersionUpgrade;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.replicationInstanceIdentifier = builder.replicationInstanceIdentifier;
        this.networkType = builder.networkType;
        this.kerberosAuthenticationSettings = builder.kerberosAuthenticationSettings;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replication instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replication instance.
     */
    public final String replicationInstanceArn() {
        return replicationInstanceArn;
    }

    /**
     * <p>
     * The amount of storage (in gigabytes) to be allocated for the replication instance.
     * </p>
     * 
     * @return The amount of storage (in gigabytes) to be allocated for the replication instance.
     */
    public final Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * Indicates whether the changes should be applied immediately or during the next maintenance window.
     * </p>
     * 
     * @return Indicates whether the changes should be applied immediately or during the next maintenance window.
     */
    public final Boolean applyImmediately() {
        return applyImmediately;
    }

    /**
     * <p>
     * The compute and memory capacity of the replication instance as defined for the specified replication instance
     * class. For example to specify the instance class dms.c4.large, set this parameter to <code>"dms.c4.large"</code>.
     * </p>
     * <p>
     * For more information on the settings and capacities for the available replication instance classes, see <a href=
     * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth"
     * > Selecting the right DMS replication instance for your migration</a>.
     * </p>
     * 
     * @return The compute and memory capacity of the replication instance as defined for the specified replication
     *         instance class. For example to specify the instance class dms.c4.large, set this parameter to
     *         <code>"dms.c4.large"</code>.</p>
     *         <p>
     *         For more information on the settings and capacities for the available replication instance classes, see
     *         <a href=
     *         "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth"
     *         > Selecting the right DMS replication instance for your migration</a>.
     */
    public final String replicationInstanceClass() {
        return replicationInstanceClass;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the VPC security group to be used with the replication instance. The VPC security group must work with
     * the VPC containing the replication instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroupIds} method.
     * </p>
     * 
     * @return Specifies the VPC security group to be used with the replication instance. The VPC security group must
     *         work with the VPC containing the replication instance.
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * <p>
     * The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage.
     * Changing this parameter does not result in an outage, except in the following situation, and the change is
     * asynchronously applied as soon as possible. If moving this window to the current time, there must be at least 30
     * minutes between the current time and end of the window to ensure pending changes are applied.
     * </p>
     * <p>
     * Default: Uses existing setting
     * </p>
     * <p>
     * Format: ddd:hh24:mi-ddd:hh24:mi
     * </p>
     * <p>
     * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
     * </p>
     * <p>
     * Constraints: Must be at least 30 minutes
     * </p>
     * 
     * @return The weekly time range (in UTC) during which system maintenance can occur, which might result in an
     *         outage. Changing this parameter does not result in an outage, except in the following situation, and the
     *         change is asynchronously applied as soon as possible. If moving this window to the current time, there
     *         must be at least 30 minutes between the current time and end of the window to ensure pending changes are
     *         applied.</p>
     *         <p>
     *         Default: Uses existing setting
     *         </p>
     *         <p>
     *         Format: ddd:hh24:mi-ddd:hh24:mi
     *         </p>
     *         <p>
     *         Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
     *         </p>
     *         <p>
     *         Constraints: Must be at least 30 minutes
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
     * <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to <code>true</code>.
     * </p>
     * 
     * @return Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
     *         <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to <code>true</code>.
     */
    public final Boolean multiAZ() {
        return multiAZ;
    }

    /**
     * <p>
     * The engine version number of the replication instance.
     * </p>
     * <p>
     * When modifying a major engine version of an instance, also set <code>AllowMajorVersionUpgrade</code> to
     * <code>true</code>.
     * </p>
     * 
     * @return The engine version number of the replication instance.</p>
     *         <p>
     *         When modifying a major engine version of an instance, also set <code>AllowMajorVersionUpgrade</code> to
     *         <code>true</code>.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * Indicates that major version upgrades are allowed. Changing this parameter does not result in an outage, and the
     * change is asynchronously applied as soon as possible.
     * </p>
     * <p>
     * This parameter must be set to <code>true</code> when specifying a value for the <code>EngineVersion</code>
     * parameter that is a different major version than the replication instance's current version.
     * </p>
     * 
     * @return Indicates that major version upgrades are allowed. Changing this parameter does not result in an outage,
     *         and the change is asynchronously applied as soon as possible.</p>
     *         <p>
     *         This parameter must be set to <code>true</code> when specifying a value for the
     *         <code>EngineVersion</code> parameter that is a different major version than the replication instance's
     *         current version.
     */
    public final Boolean allowMajorVersionUpgrade() {
        return allowMajorVersionUpgrade;
    }

    /**
     * <p>
     * A value that indicates that minor version upgrades are applied automatically to the replication instance during
     * the maintenance window. Changing this parameter doesn't result in an outage, except in the case described
     * following. The change is asynchronously applied as soon as possible.
     * </p>
     * <p>
     * An outage does result if these factors apply:
     * </p>
     * <ul>
     * <li>
     * <p>
     * This parameter is set to <code>true</code> during the maintenance window.
     * </p>
     * </li>
     * <li>
     * <p>
     * A newer minor version is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * DMS has enabled automatic patching for the given engine version.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A value that indicates that minor version upgrades are applied automatically to the replication instance
     *         during the maintenance window. Changing this parameter doesn't result in an outage, except in the case
     *         described following. The change is asynchronously applied as soon as possible. </p>
     *         <p>
     *         An outage does result if these factors apply:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         This parameter is set to <code>true</code> during the maintenance window.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A newer minor version is available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DMS has enabled automatic patching for the given engine version.
     *         </p>
     *         </li>
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * The replication instance identifier. This parameter is stored as a lowercase string.
     * </p>
     * 
     * @return The replication instance identifier. This parameter is stored as a lowercase string.
     */
    public final String replicationInstanceIdentifier() {
        return replicationInstanceIdentifier;
    }

    /**
     * <p>
     * The type of IP address protocol used by a replication instance, such as IPv4 only or Dual-stack that supports
     * both IPv4 and IPv6 addressing. IPv6 only is not yet supported.
     * </p>
     * 
     * @return The type of IP address protocol used by a replication instance, such as IPv4 only or Dual-stack that
     *         supports both IPv4 and IPv6 addressing. IPv6 only is not yet supported.
     */
    public final String networkType() {
        return networkType;
    }

    /**
     * <p>
     * Specifies the settings required for kerberos authentication when modifying a replication instance.
     * </p>
     * 
     * @return Specifies the settings required for kerberos authentication when modifying a replication instance.
     */
    public final KerberosAuthenticationSettings kerberosAuthenticationSettings() {
        return kerberosAuthenticationSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(allowMajorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(networkType());
        hashCode = 31 * hashCode + Objects.hashCode(kerberosAuthenticationSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReplicationInstanceRequest)) {
            return false;
        }
        ModifyReplicationInstanceRequest other = (ModifyReplicationInstanceRequest) obj;
        return Objects.equals(replicationInstanceArn(), other.replicationInstanceArn())
                && Objects.equals(allocatedStorage(), other.allocatedStorage())
                && Objects.equals(applyImmediately(), other.applyImmediately())
                && Objects.equals(replicationInstanceClass(), other.replicationInstanceClass())
                && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(multiAZ(), other.multiAZ()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(allowMajorVersionUpgrade(), other.allowMajorVersionUpgrade())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(replicationInstanceIdentifier(), other.replicationInstanceIdentifier())
                && Objects.equals(networkType(), other.networkType())
                && Objects.equals(kerberosAuthenticationSettings(), other.kerberosAuthenticationSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyReplicationInstanceRequest").add("ReplicationInstanceArn", replicationInstanceArn())
                .add("AllocatedStorage", allocatedStorage()).add("ApplyImmediately", applyImmediately())
                .add("ReplicationInstanceClass", replicationInstanceClass())
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null)
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow()).add("MultiAZ", multiAZ())
                .add("EngineVersion", engineVersion()).add("AllowMajorVersionUpgrade", allowMajorVersionUpgrade())
                .add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade())
                .add("ReplicationInstanceIdentifier", replicationInstanceIdentifier()).add("NetworkType", networkType())
                .add("KerberosAuthenticationSettings", kerberosAuthenticationSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationInstanceArn":
            return Optional.ofNullable(clazz.cast(replicationInstanceArn()));
        case "AllocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "ApplyImmediately":
            return Optional.ofNullable(clazz.cast(applyImmediately()));
        case "ReplicationInstanceClass":
            return Optional.ofNullable(clazz.cast(replicationInstanceClass()));
        case "VpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "MultiAZ":
            return Optional.ofNullable(clazz.cast(multiAZ()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "AllowMajorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(allowMajorVersionUpgrade()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "ReplicationInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(replicationInstanceIdentifier()));
        case "NetworkType":
            return Optional.ofNullable(clazz.cast(networkType()));
        case "KerberosAuthenticationSettings":
            return Optional.ofNullable(clazz.cast(kerberosAuthenticationSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReplicationInstanceArn", REPLICATION_INSTANCE_ARN_FIELD);
        map.put("AllocatedStorage", ALLOCATED_STORAGE_FIELD);
        map.put("ApplyImmediately", APPLY_IMMEDIATELY_FIELD);
        map.put("ReplicationInstanceClass", REPLICATION_INSTANCE_CLASS_FIELD);
        map.put("VpcSecurityGroupIds", VPC_SECURITY_GROUP_IDS_FIELD);
        map.put("PreferredMaintenanceWindow", PREFERRED_MAINTENANCE_WINDOW_FIELD);
        map.put("MultiAZ", MULTI_AZ_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("AllowMajorVersionUpgrade", ALLOW_MAJOR_VERSION_UPGRADE_FIELD);
        map.put("AutoMinorVersionUpgrade", AUTO_MINOR_VERSION_UPGRADE_FIELD);
        map.put("ReplicationInstanceIdentifier", REPLICATION_INSTANCE_IDENTIFIER_FIELD);
        map.put("NetworkType", NETWORK_TYPE_FIELD);
        map.put("KerberosAuthenticationSettings", KERBEROS_AUTHENTICATION_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyReplicationInstanceRequest, T> g) {
        return obj -> g.apply((ModifyReplicationInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyReplicationInstanceRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replication instance.
         * </p>
         * 
         * @param replicationInstanceArn
         *        The Amazon Resource Name (ARN) of the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceArn(String replicationInstanceArn);

        /**
         * <p>
         * The amount of storage (in gigabytes) to be allocated for the replication instance.
         * </p>
         * 
         * @param allocatedStorage
         *        The amount of storage (in gigabytes) to be allocated for the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * Indicates whether the changes should be applied immediately or during the next maintenance window.
         * </p>
         * 
         * @param applyImmediately
         *        Indicates whether the changes should be applied immediately or during the next maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyImmediately(Boolean applyImmediately);

        /**
         * <p>
         * The compute and memory capacity of the replication instance as defined for the specified replication instance
         * class. For example to specify the instance class dms.c4.large, set this parameter to
         * <code>"dms.c4.large"</code>.
         * </p>
         * <p>
         * For more information on the settings and capacities for the available replication instance classes, see <a
         * href=
         * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth"
         * > Selecting the right DMS replication instance for your migration</a>.
         * </p>
         * 
         * @param replicationInstanceClass
         *        The compute and memory capacity of the replication instance as defined for the specified replication
         *        instance class. For example to specify the instance class dms.c4.large, set this parameter to
         *        <code>"dms.c4.large"</code>.</p>
         *        <p>
         *        For more information on the settings and capacities for the available replication instance classes,
         *        see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth"
         *        > Selecting the right DMS replication instance for your migration</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceClass(String replicationInstanceClass);

        /**
         * <p>
         * Specifies the VPC security group to be used with the replication instance. The VPC security group must work
         * with the VPC containing the replication instance.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        Specifies the VPC security group to be used with the replication instance. The VPC security group must
         *        work with the VPC containing the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * Specifies the VPC security group to be used with the replication instance. The VPC security group must work
         * with the VPC containing the replication instance.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        Specifies the VPC security group to be used with the replication instance. The VPC security group must
         *        work with the VPC containing the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * <p>
         * The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage.
         * Changing this parameter does not result in an outage, except in the following situation, and the change is
         * asynchronously applied as soon as possible. If moving this window to the current time, there must be at least
         * 30 minutes between the current time and end of the window to ensure pending changes are applied.
         * </p>
         * <p>
         * Default: Uses existing setting
         * </p>
         * <p>
         * Format: ddd:hh24:mi-ddd:hh24:mi
         * </p>
         * <p>
         * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
         * </p>
         * <p>
         * Constraints: Must be at least 30 minutes
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        The weekly time range (in UTC) during which system maintenance can occur, which might result in an
         *        outage. Changing this parameter does not result in an outage, except in the following situation, and
         *        the change is asynchronously applied as soon as possible. If moving this window to the current time,
         *        there must be at least 30 minutes between the current time and end of the window to ensure pending
         *        changes are applied.</p>
         *        <p>
         *        Default: Uses existing setting
         *        </p>
         *        <p>
         *        Format: ddd:hh24:mi-ddd:hh24:mi
         *        </p>
         *        <p>
         *        Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
         *        </p>
         *        <p>
         *        Constraints: Must be at least 30 minutes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
         * <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to <code>true</code>.
         * </p>
         * 
         * @param multiAZ
         *        Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
         *        <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZ(Boolean multiAZ);

        /**
         * <p>
         * The engine version number of the replication instance.
         * </p>
         * <p>
         * When modifying a major engine version of an instance, also set <code>AllowMajorVersionUpgrade</code> to
         * <code>true</code>.
         * </p>
         * 
         * @param engineVersion
         *        The engine version number of the replication instance.</p>
         *        <p>
         *        When modifying a major engine version of an instance, also set <code>AllowMajorVersionUpgrade</code>
         *        to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * Indicates that major version upgrades are allowed. Changing this parameter does not result in an outage, and
         * the change is asynchronously applied as soon as possible.
         * </p>
         * <p>
         * This parameter must be set to <code>true</code> when specifying a value for the <code>EngineVersion</code>
         * parameter that is a different major version than the replication instance's current version.
         * </p>
         * 
         * @param allowMajorVersionUpgrade
         *        Indicates that major version upgrades are allowed. Changing this parameter does not result in an
         *        outage, and the change is asynchronously applied as soon as possible.</p>
         *        <p>
         *        This parameter must be set to <code>true</code> when specifying a value for the
         *        <code>EngineVersion</code> parameter that is a different major version than the replication instance's
         *        current version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade);

        /**
         * <p>
         * A value that indicates that minor version upgrades are applied automatically to the replication instance
         * during the maintenance window. Changing this parameter doesn't result in an outage, except in the case
         * described following. The change is asynchronously applied as soon as possible.
         * </p>
         * <p>
         * An outage does result if these factors apply:
         * </p>
         * <ul>
         * <li>
         * <p>
         * This parameter is set to <code>true</code> during the maintenance window.
         * </p>
         * </li>
         * <li>
         * <p>
         * A newer minor version is available.
         * </p>
         * </li>
         * <li>
         * <p>
         * DMS has enabled automatic patching for the given engine version.
         * </p>
         * </li>
         * </ul>
         * 
         * @param autoMinorVersionUpgrade
         *        A value that indicates that minor version upgrades are applied automatically to the replication
         *        instance during the maintenance window. Changing this parameter doesn't result in an outage, except in
         *        the case described following. The change is asynchronously applied as soon as possible. </p>
         *        <p>
         *        An outage does result if these factors apply:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        This parameter is set to <code>true</code> during the maintenance window.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A newer minor version is available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DMS has enabled automatic patching for the given engine version.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * The replication instance identifier. This parameter is stored as a lowercase string.
         * </p>
         * 
         * @param replicationInstanceIdentifier
         *        The replication instance identifier. This parameter is stored as a lowercase string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceIdentifier(String replicationInstanceIdentifier);

        /**
         * <p>
         * The type of IP address protocol used by a replication instance, such as IPv4 only or Dual-stack that supports
         * both IPv4 and IPv6 addressing. IPv6 only is not yet supported.
         * </p>
         * 
         * @param networkType
         *        The type of IP address protocol used by a replication instance, such as IPv4 only or Dual-stack that
         *        supports both IPv4 and IPv6 addressing. IPv6 only is not yet supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkType(String networkType);

        /**
         * <p>
         * Specifies the settings required for kerberos authentication when modifying a replication instance.
         * </p>
         * 
         * @param kerberosAuthenticationSettings
         *        Specifies the settings required for kerberos authentication when modifying a replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kerberosAuthenticationSettings(KerberosAuthenticationSettings kerberosAuthenticationSettings);

        /**
         * <p>
         * Specifies the settings required for kerberos authentication when modifying a replication instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link KerberosAuthenticationSettings.Builder}
         * avoiding the need to create one manually via {@link KerberosAuthenticationSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KerberosAuthenticationSettings.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #kerberosAuthenticationSettings(KerberosAuthenticationSettings)}.
         * 
         * @param kerberosAuthenticationSettings
         *        a consumer that will call methods on {@link KerberosAuthenticationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kerberosAuthenticationSettings(KerberosAuthenticationSettings)
         */
        default Builder kerberosAuthenticationSettings(
                Consumer<KerberosAuthenticationSettings.Builder> kerberosAuthenticationSettings) {
            return kerberosAuthenticationSettings(KerberosAuthenticationSettings.builder()
                    .applyMutation(kerberosAuthenticationSettings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String replicationInstanceArn;

        private Integer allocatedStorage;

        private Boolean applyImmediately;

        private String replicationInstanceClass;

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String preferredMaintenanceWindow;

        private Boolean multiAZ;

        private String engineVersion;

        private Boolean allowMajorVersionUpgrade;

        private Boolean autoMinorVersionUpgrade;

        private String replicationInstanceIdentifier;

        private String networkType;

        private KerberosAuthenticationSettings kerberosAuthenticationSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyReplicationInstanceRequest model) {
            super(model);
            replicationInstanceArn(model.replicationInstanceArn);
            allocatedStorage(model.allocatedStorage);
            applyImmediately(model.applyImmediately);
            replicationInstanceClass(model.replicationInstanceClass);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            multiAZ(model.multiAZ);
            engineVersion(model.engineVersion);
            allowMajorVersionUpgrade(model.allowMajorVersionUpgrade);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            replicationInstanceIdentifier(model.replicationInstanceIdentifier);
            networkType(model.networkType);
            kerberosAuthenticationSettings(model.kerberosAuthenticationSettings);
        }

        public final String getReplicationInstanceArn() {
            return replicationInstanceArn;
        }

        public final void setReplicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
        }

        @Override
        public final Builder replicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
            return this;
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final Boolean getApplyImmediately() {
            return applyImmediately;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final String getReplicationInstanceClass() {
            return replicationInstanceClass;
        }

        public final void setReplicationInstanceClass(String replicationInstanceClass) {
            this.replicationInstanceClass = replicationInstanceClass;
        }

        @Override
        public final Builder replicationInstanceClass(String replicationInstanceClass) {
            this.replicationInstanceClass = replicationInstanceClass;
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final Boolean getMultiAZ() {
            return multiAZ;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Boolean getAllowMajorVersionUpgrade() {
            return allowMajorVersionUpgrade;
        }

        public final void setAllowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
            this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
        }

        @Override
        public final Builder allowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
            this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final String getReplicationInstanceIdentifier() {
            return replicationInstanceIdentifier;
        }

        public final void setReplicationInstanceIdentifier(String replicationInstanceIdentifier) {
            this.replicationInstanceIdentifier = replicationInstanceIdentifier;
        }

        @Override
        public final Builder replicationInstanceIdentifier(String replicationInstanceIdentifier) {
            this.replicationInstanceIdentifier = replicationInstanceIdentifier;
            return this;
        }

        public final String getNetworkType() {
            return networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        public final KerberosAuthenticationSettings.Builder getKerberosAuthenticationSettings() {
            return kerberosAuthenticationSettings != null ? kerberosAuthenticationSettings.toBuilder() : null;
        }

        public final void setKerberosAuthenticationSettings(
                KerberosAuthenticationSettings.BuilderImpl kerberosAuthenticationSettings) {
            this.kerberosAuthenticationSettings = kerberosAuthenticationSettings != null ? kerberosAuthenticationSettings.build()
                    : null;
        }

        @Override
        public final Builder kerberosAuthenticationSettings(KerberosAuthenticationSettings kerberosAuthenticationSettings) {
            this.kerberosAuthenticationSettings = kerberosAuthenticationSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyReplicationInstanceRequest build() {
            return new ModifyReplicationInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
