/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportMetadataModelAssessmentResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<ExportMetadataModelAssessmentResponse.Builder, ExportMetadataModelAssessmentResponse> {
    private static final SdkField<ExportMetadataModelAssessmentResultEntry> PDF_REPORT_FIELD = SdkField
            .<ExportMetadataModelAssessmentResultEntry> builder(MarshallingType.SDK_POJO).memberName("PdfReport")
            .getter(getter(ExportMetadataModelAssessmentResponse::pdfReport)).setter(setter(Builder::pdfReport))
            .constructor(ExportMetadataModelAssessmentResultEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PdfReport").build()).build();

    private static final SdkField<ExportMetadataModelAssessmentResultEntry> CSV_REPORT_FIELD = SdkField
            .<ExportMetadataModelAssessmentResultEntry> builder(MarshallingType.SDK_POJO).memberName("CsvReport")
            .getter(getter(ExportMetadataModelAssessmentResponse::csvReport)).setter(setter(Builder::csvReport))
            .constructor(ExportMetadataModelAssessmentResultEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvReport").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PDF_REPORT_FIELD,
            CSV_REPORT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ExportMetadataModelAssessmentResultEntry pdfReport;

    private final ExportMetadataModelAssessmentResultEntry csvReport;

    private ExportMetadataModelAssessmentResponse(BuilderImpl builder) {
        super(builder);
        this.pdfReport = builder.pdfReport;
        this.csvReport = builder.csvReport;
    }

    /**
     * <p>
     * The Amazon S3 details for an assessment exported in PDF format.
     * </p>
     * 
     * @return The Amazon S3 details for an assessment exported in PDF format.
     */
    public final ExportMetadataModelAssessmentResultEntry pdfReport() {
        return pdfReport;
    }

    /**
     * <p>
     * The Amazon S3 details for an assessment exported in CSV format.
     * </p>
     * 
     * @return The Amazon S3 details for an assessment exported in CSV format.
     */
    public final ExportMetadataModelAssessmentResultEntry csvReport() {
        return csvReport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pdfReport());
        hashCode = 31 * hashCode + Objects.hashCode(csvReport());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportMetadataModelAssessmentResponse)) {
            return false;
        }
        ExportMetadataModelAssessmentResponse other = (ExportMetadataModelAssessmentResponse) obj;
        return Objects.equals(pdfReport(), other.pdfReport()) && Objects.equals(csvReport(), other.csvReport());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportMetadataModelAssessmentResponse").add("PdfReport", pdfReport())
                .add("CsvReport", csvReport()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PdfReport":
            return Optional.ofNullable(clazz.cast(pdfReport()));
        case "CsvReport":
            return Optional.ofNullable(clazz.cast(csvReport()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PdfReport", PDF_REPORT_FIELD);
        map.put("CsvReport", CSV_REPORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportMetadataModelAssessmentResponse, T> g) {
        return obj -> g.apply((ExportMetadataModelAssessmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ExportMetadataModelAssessmentResponse> {
        /**
         * <p>
         * The Amazon S3 details for an assessment exported in PDF format.
         * </p>
         * 
         * @param pdfReport
         *        The Amazon S3 details for an assessment exported in PDF format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pdfReport(ExportMetadataModelAssessmentResultEntry pdfReport);

        /**
         * <p>
         * The Amazon S3 details for an assessment exported in PDF format.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ExportMetadataModelAssessmentResultEntry.Builder} avoiding the need to create one manually via
         * {@link ExportMetadataModelAssessmentResultEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportMetadataModelAssessmentResultEntry.Builder#build()} is
         * called immediately and its result is passed to {@link #pdfReport(ExportMetadataModelAssessmentResultEntry)}.
         * 
         * @param pdfReport
         *        a consumer that will call methods on {@link ExportMetadataModelAssessmentResultEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pdfReport(ExportMetadataModelAssessmentResultEntry)
         */
        default Builder pdfReport(Consumer<ExportMetadataModelAssessmentResultEntry.Builder> pdfReport) {
            return pdfReport(ExportMetadataModelAssessmentResultEntry.builder().applyMutation(pdfReport).build());
        }

        /**
         * <p>
         * The Amazon S3 details for an assessment exported in CSV format.
         * </p>
         * 
         * @param csvReport
         *        The Amazon S3 details for an assessment exported in CSV format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvReport(ExportMetadataModelAssessmentResultEntry csvReport);

        /**
         * <p>
         * The Amazon S3 details for an assessment exported in CSV format.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ExportMetadataModelAssessmentResultEntry.Builder} avoiding the need to create one manually via
         * {@link ExportMetadataModelAssessmentResultEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportMetadataModelAssessmentResultEntry.Builder#build()} is
         * called immediately and its result is passed to {@link #csvReport(ExportMetadataModelAssessmentResultEntry)}.
         * 
         * @param csvReport
         *        a consumer that will call methods on {@link ExportMetadataModelAssessmentResultEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #csvReport(ExportMetadataModelAssessmentResultEntry)
         */
        default Builder csvReport(Consumer<ExportMetadataModelAssessmentResultEntry.Builder> csvReport) {
            return csvReport(ExportMetadataModelAssessmentResultEntry.builder().applyMutation(csvReport).build());
        }
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private ExportMetadataModelAssessmentResultEntry pdfReport;

        private ExportMetadataModelAssessmentResultEntry csvReport;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportMetadataModelAssessmentResponse model) {
            super(model);
            pdfReport(model.pdfReport);
            csvReport(model.csvReport);
        }

        public final ExportMetadataModelAssessmentResultEntry.Builder getPdfReport() {
            return pdfReport != null ? pdfReport.toBuilder() : null;
        }

        public final void setPdfReport(ExportMetadataModelAssessmentResultEntry.BuilderImpl pdfReport) {
            this.pdfReport = pdfReport != null ? pdfReport.build() : null;
        }

        @Override
        public final Builder pdfReport(ExportMetadataModelAssessmentResultEntry pdfReport) {
            this.pdfReport = pdfReport;
            return this;
        }

        public final ExportMetadataModelAssessmentResultEntry.Builder getCsvReport() {
            return csvReport != null ? csvReport.toBuilder() : null;
        }

        public final void setCsvReport(ExportMetadataModelAssessmentResultEntry.BuilderImpl csvReport) {
            this.csvReport = csvReport != null ? csvReport.build() : null;
        }

        @Override
        public final Builder csvReport(ExportMetadataModelAssessmentResultEntry csvReport) {
            this.csvReport = csvReport;
            return this;
        }

        @Override
        public ExportMetadataModelAssessmentResponse build() {
            return new ExportMetadataModelAssessmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
