/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the data migration run, including start and stop time, latency, and migration progress.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataMigrationStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<DataMigrationStatistics.Builder, DataMigrationStatistics> {
    private static final SdkField<Integer> TABLES_LOADED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TablesLoaded").getter(getter(DataMigrationStatistics::tablesLoaded))
            .setter(setter(Builder::tablesLoaded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesLoaded").build()).build();

    private static final SdkField<Long> ELAPSED_TIME_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ElapsedTimeMillis").getter(getter(DataMigrationStatistics::elapsedTimeMillis))
            .setter(setter(Builder::elapsedTimeMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElapsedTimeMillis").build()).build();

    private static final SdkField<Integer> TABLES_LOADING_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TablesLoading").getter(getter(DataMigrationStatistics::tablesLoading))
            .setter(setter(Builder::tablesLoading))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesLoading").build()).build();

    private static final SdkField<Integer> FULL_LOAD_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FullLoadPercentage").getter(getter(DataMigrationStatistics::fullLoadPercentage))
            .setter(setter(Builder::fullLoadPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadPercentage").build())
            .build();

    private static final SdkField<Integer> CDC_LATENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CDCLatency").getter(getter(DataMigrationStatistics::cdcLatency)).setter(setter(Builder::cdcLatency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CDCLatency").build()).build();

    private static final SdkField<Integer> TABLES_QUEUED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TablesQueued").getter(getter(DataMigrationStatistics::tablesQueued))
            .setter(setter(Builder::tablesQueued))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesQueued").build()).build();

    private static final SdkField<Integer> TABLES_ERRORED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TablesErrored").getter(getter(DataMigrationStatistics::tablesErrored))
            .setter(setter(Builder::tablesErrored))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesErrored").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime")
            .getter(getter(DataMigrationStatistics::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> STOP_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StopTime")
            .getter(getter(DataMigrationStatistics::stopTime))
            .setter(setter(Builder::stopTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLES_LOADED_FIELD,
            ELAPSED_TIME_MILLIS_FIELD, TABLES_LOADING_FIELD, FULL_LOAD_PERCENTAGE_FIELD, CDC_LATENCY_FIELD, TABLES_QUEUED_FIELD,
            TABLES_ERRORED_FIELD, START_TIME_FIELD, STOP_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer tablesLoaded;

    private final Long elapsedTimeMillis;

    private final Integer tablesLoading;

    private final Integer fullLoadPercentage;

    private final Integer cdcLatency;

    private final Integer tablesQueued;

    private final Integer tablesErrored;

    private final Instant startTime;

    private final Instant stopTime;

    private DataMigrationStatistics(BuilderImpl builder) {
        this.tablesLoaded = builder.tablesLoaded;
        this.elapsedTimeMillis = builder.elapsedTimeMillis;
        this.tablesLoading = builder.tablesLoading;
        this.fullLoadPercentage = builder.fullLoadPercentage;
        this.cdcLatency = builder.cdcLatency;
        this.tablesQueued = builder.tablesQueued;
        this.tablesErrored = builder.tablesErrored;
        this.startTime = builder.startTime;
        this.stopTime = builder.stopTime;
    }

    /**
     * <p>
     * The number of tables loaded in the current data migration run.
     * </p>
     * 
     * @return The number of tables loaded in the current data migration run.
     */
    public final Integer tablesLoaded() {
        return tablesLoaded;
    }

    /**
     * <p>
     * The elapsed duration of the data migration run.
     * </p>
     * 
     * @return The elapsed duration of the data migration run.
     */
    public final Long elapsedTimeMillis() {
        return elapsedTimeMillis;
    }

    /**
     * <p>
     * The data migration's table loading progress.
     * </p>
     * 
     * @return The data migration's table loading progress.
     */
    public final Integer tablesLoading() {
        return tablesLoading;
    }

    /**
     * <p>
     * The data migration's progress in the full-load migration phase.
     * </p>
     * 
     * @return The data migration's progress in the full-load migration phase.
     */
    public final Integer fullLoadPercentage() {
        return fullLoadPercentage;
    }

    /**
     * <p>
     * The current latency of the change data capture (CDC) operation.
     * </p>
     * 
     * @return The current latency of the change data capture (CDC) operation.
     */
    public final Integer cdcLatency() {
        return cdcLatency;
    }

    /**
     * <p>
     * The number of tables that are waiting for processing.
     * </p>
     * 
     * @return The number of tables that are waiting for processing.
     */
    public final Integer tablesQueued() {
        return tablesQueued;
    }

    /**
     * <p>
     * The number of tables that DMS failed to process.
     * </p>
     * 
     * @return The number of tables that DMS failed to process.
     */
    public final Integer tablesErrored() {
        return tablesErrored;
    }

    /**
     * <p>
     * The time when the migration started.
     * </p>
     * 
     * @return The time when the migration started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time when the migration stopped or failed.
     * </p>
     * 
     * @return The time when the migration stopped or failed.
     */
    public final Instant stopTime() {
        return stopTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tablesLoaded());
        hashCode = 31 * hashCode + Objects.hashCode(elapsedTimeMillis());
        hashCode = 31 * hashCode + Objects.hashCode(tablesLoading());
        hashCode = 31 * hashCode + Objects.hashCode(fullLoadPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(cdcLatency());
        hashCode = 31 * hashCode + Objects.hashCode(tablesQueued());
        hashCode = 31 * hashCode + Objects.hashCode(tablesErrored());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(stopTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataMigrationStatistics)) {
            return false;
        }
        DataMigrationStatistics other = (DataMigrationStatistics) obj;
        return Objects.equals(tablesLoaded(), other.tablesLoaded())
                && Objects.equals(elapsedTimeMillis(), other.elapsedTimeMillis())
                && Objects.equals(tablesLoading(), other.tablesLoading())
                && Objects.equals(fullLoadPercentage(), other.fullLoadPercentage())
                && Objects.equals(cdcLatency(), other.cdcLatency()) && Objects.equals(tablesQueued(), other.tablesQueued())
                && Objects.equals(tablesErrored(), other.tablesErrored()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(stopTime(), other.stopTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataMigrationStatistics").add("TablesLoaded", tablesLoaded())
                .add("ElapsedTimeMillis", elapsedTimeMillis()).add("TablesLoading", tablesLoading())
                .add("FullLoadPercentage", fullLoadPercentage()).add("CDCLatency", cdcLatency())
                .add("TablesQueued", tablesQueued()).add("TablesErrored", tablesErrored()).add("StartTime", startTime())
                .add("StopTime", stopTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TablesLoaded":
            return Optional.ofNullable(clazz.cast(tablesLoaded()));
        case "ElapsedTimeMillis":
            return Optional.ofNullable(clazz.cast(elapsedTimeMillis()));
        case "TablesLoading":
            return Optional.ofNullable(clazz.cast(tablesLoading()));
        case "FullLoadPercentage":
            return Optional.ofNullable(clazz.cast(fullLoadPercentage()));
        case "CDCLatency":
            return Optional.ofNullable(clazz.cast(cdcLatency()));
        case "TablesQueued":
            return Optional.ofNullable(clazz.cast(tablesQueued()));
        case "TablesErrored":
            return Optional.ofNullable(clazz.cast(tablesErrored()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "StopTime":
            return Optional.ofNullable(clazz.cast(stopTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TablesLoaded", TABLES_LOADED_FIELD);
        map.put("ElapsedTimeMillis", ELAPSED_TIME_MILLIS_FIELD);
        map.put("TablesLoading", TABLES_LOADING_FIELD);
        map.put("FullLoadPercentage", FULL_LOAD_PERCENTAGE_FIELD);
        map.put("CDCLatency", CDC_LATENCY_FIELD);
        map.put("TablesQueued", TABLES_QUEUED_FIELD);
        map.put("TablesErrored", TABLES_ERRORED_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("StopTime", STOP_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataMigrationStatistics, T> g) {
        return obj -> g.apply((DataMigrationStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataMigrationStatistics> {
        /**
         * <p>
         * The number of tables loaded in the current data migration run.
         * </p>
         * 
         * @param tablesLoaded
         *        The number of tables loaded in the current data migration run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tablesLoaded(Integer tablesLoaded);

        /**
         * <p>
         * The elapsed duration of the data migration run.
         * </p>
         * 
         * @param elapsedTimeMillis
         *        The elapsed duration of the data migration run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elapsedTimeMillis(Long elapsedTimeMillis);

        /**
         * <p>
         * The data migration's table loading progress.
         * </p>
         * 
         * @param tablesLoading
         *        The data migration's table loading progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tablesLoading(Integer tablesLoading);

        /**
         * <p>
         * The data migration's progress in the full-load migration phase.
         * </p>
         * 
         * @param fullLoadPercentage
         *        The data migration's progress in the full-load migration phase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullLoadPercentage(Integer fullLoadPercentage);

        /**
         * <p>
         * The current latency of the change data capture (CDC) operation.
         * </p>
         * 
         * @param cdcLatency
         *        The current latency of the change data capture (CDC) operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcLatency(Integer cdcLatency);

        /**
         * <p>
         * The number of tables that are waiting for processing.
         * </p>
         * 
         * @param tablesQueued
         *        The number of tables that are waiting for processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tablesQueued(Integer tablesQueued);

        /**
         * <p>
         * The number of tables that DMS failed to process.
         * </p>
         * 
         * @param tablesErrored
         *        The number of tables that DMS failed to process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tablesErrored(Integer tablesErrored);

        /**
         * <p>
         * The time when the migration started.
         * </p>
         * 
         * @param startTime
         *        The time when the migration started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time when the migration stopped or failed.
         * </p>
         * 
         * @param stopTime
         *        The time when the migration stopped or failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopTime(Instant stopTime);
    }

    static final class BuilderImpl implements Builder {
        private Integer tablesLoaded;

        private Long elapsedTimeMillis;

        private Integer tablesLoading;

        private Integer fullLoadPercentage;

        private Integer cdcLatency;

        private Integer tablesQueued;

        private Integer tablesErrored;

        private Instant startTime;

        private Instant stopTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DataMigrationStatistics model) {
            tablesLoaded(model.tablesLoaded);
            elapsedTimeMillis(model.elapsedTimeMillis);
            tablesLoading(model.tablesLoading);
            fullLoadPercentage(model.fullLoadPercentage);
            cdcLatency(model.cdcLatency);
            tablesQueued(model.tablesQueued);
            tablesErrored(model.tablesErrored);
            startTime(model.startTime);
            stopTime(model.stopTime);
        }

        public final Integer getTablesLoaded() {
            return tablesLoaded;
        }

        public final void setTablesLoaded(Integer tablesLoaded) {
            this.tablesLoaded = tablesLoaded;
        }

        @Override
        public final Builder tablesLoaded(Integer tablesLoaded) {
            this.tablesLoaded = tablesLoaded;
            return this;
        }

        public final Long getElapsedTimeMillis() {
            return elapsedTimeMillis;
        }

        public final void setElapsedTimeMillis(Long elapsedTimeMillis) {
            this.elapsedTimeMillis = elapsedTimeMillis;
        }

        @Override
        public final Builder elapsedTimeMillis(Long elapsedTimeMillis) {
            this.elapsedTimeMillis = elapsedTimeMillis;
            return this;
        }

        public final Integer getTablesLoading() {
            return tablesLoading;
        }

        public final void setTablesLoading(Integer tablesLoading) {
            this.tablesLoading = tablesLoading;
        }

        @Override
        public final Builder tablesLoading(Integer tablesLoading) {
            this.tablesLoading = tablesLoading;
            return this;
        }

        public final Integer getFullLoadPercentage() {
            return fullLoadPercentage;
        }

        public final void setFullLoadPercentage(Integer fullLoadPercentage) {
            this.fullLoadPercentage = fullLoadPercentage;
        }

        @Override
        public final Builder fullLoadPercentage(Integer fullLoadPercentage) {
            this.fullLoadPercentage = fullLoadPercentage;
            return this;
        }

        public final Integer getCdcLatency() {
            return cdcLatency;
        }

        public final void setCdcLatency(Integer cdcLatency) {
            this.cdcLatency = cdcLatency;
        }

        @Override
        public final Builder cdcLatency(Integer cdcLatency) {
            this.cdcLatency = cdcLatency;
            return this;
        }

        public final Integer getTablesQueued() {
            return tablesQueued;
        }

        public final void setTablesQueued(Integer tablesQueued) {
            this.tablesQueued = tablesQueued;
        }

        @Override
        public final Builder tablesQueued(Integer tablesQueued) {
            this.tablesQueued = tablesQueued;
            return this;
        }

        public final Integer getTablesErrored() {
            return tablesErrored;
        }

        public final void setTablesErrored(Integer tablesErrored) {
            this.tablesErrored = tablesErrored;
        }

        @Override
        public final Builder tablesErrored(Integer tablesErrored) {
            this.tablesErrored = tablesErrored;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getStopTime() {
            return stopTime;
        }

        public final void setStopTime(Instant stopTime) {
            this.stopTime = stopTime;
        }

        @Override
        public final Builder stopTime(Instant stopTime) {
            this.stopTime = stopTime;
            return this;
        }

        @Override
        public DataMigrationStatistics build() {
            return new DataMigrationStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
