/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.ErrorDetails;
import software.amazon.awssdk.services.databasemigration.model.ExportSqlDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SchemaConversionRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SchemaConversionRequest> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(SchemaConversionRequest.getter(SchemaConversionRequest::status)).setter(SchemaConversionRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> REQUEST_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestIdentifier").getter(SchemaConversionRequest.getter(SchemaConversionRequest::requestIdentifier)).setter(SchemaConversionRequest.setter(Builder::requestIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestIdentifier").build()}).build();
    private static final SdkField<String> MIGRATION_PROJECT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MigrationProjectArn").getter(SchemaConversionRequest.getter(SchemaConversionRequest::migrationProjectArn)).setter(SchemaConversionRequest.setter(Builder::migrationProjectArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationProjectArn").build()}).build();
    private static final SdkField<ErrorDetails> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Error").getter(SchemaConversionRequest.getter(SchemaConversionRequest::error)).setter(SchemaConversionRequest.setter(Builder::error)).constructor(ErrorDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final SdkField<ExportSqlDetails> EXPORT_SQL_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportSqlDetails").getter(SchemaConversionRequest.getter(SchemaConversionRequest::exportSqlDetails)).setter(SchemaConversionRequest.setter(Builder::exportSqlDetails)).constructor(ExportSqlDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportSqlDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, REQUEST_IDENTIFIER_FIELD, MIGRATION_PROJECT_ARN_FIELD, ERROR_FIELD, EXPORT_SQL_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SchemaConversionRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String requestIdentifier;
    private final String migrationProjectArn;
    private final ErrorDetails error;
    private final ExportSqlDetails exportSqlDetails;

    private SchemaConversionRequest(BuilderImpl builder) {
        this.status = builder.status;
        this.requestIdentifier = builder.requestIdentifier;
        this.migrationProjectArn = builder.migrationProjectArn;
        this.error = builder.error;
        this.exportSqlDetails = builder.exportSqlDetails;
    }

    public final String status() {
        return this.status;
    }

    public final String requestIdentifier() {
        return this.requestIdentifier;
    }

    public final String migrationProjectArn() {
        return this.migrationProjectArn;
    }

    public final ErrorDetails error() {
        return this.error;
    }

    public final ExportSqlDetails exportSqlDetails() {
        return this.exportSqlDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationProjectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportSqlDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaConversionRequest)) {
            return false;
        }
        SchemaConversionRequest other = (SchemaConversionRequest)obj;
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.requestIdentifier(), other.requestIdentifier()) && Objects.equals(this.migrationProjectArn(), other.migrationProjectArn()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.exportSqlDetails(), other.exportSqlDetails());
    }

    public final String toString() {
        return ToString.builder((String)"SchemaConversionRequest").add("Status", (Object)this.status()).add("RequestIdentifier", (Object)this.requestIdentifier()).add("MigrationProjectArn", (Object)this.migrationProjectArn()).add("Error", (Object)this.error()).add("ExportSqlDetails", (Object)this.exportSqlDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "RequestIdentifier": {
                return Optional.ofNullable(clazz.cast(this.requestIdentifier()));
            }
            case "MigrationProjectArn": {
                return Optional.ofNullable(clazz.cast(this.migrationProjectArn()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "ExportSqlDetails": {
                return Optional.ofNullable(clazz.cast(this.exportSqlDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Status", STATUS_FIELD);
        map.put("RequestIdentifier", REQUEST_IDENTIFIER_FIELD);
        map.put("MigrationProjectArn", MIGRATION_PROJECT_ARN_FIELD);
        map.put("Error", ERROR_FIELD);
        map.put("ExportSqlDetails", EXPORT_SQL_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SchemaConversionRequest, T> g) {
        return obj -> g.apply((SchemaConversionRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String requestIdentifier;
        private String migrationProjectArn;
        private ErrorDetails error;
        private ExportSqlDetails exportSqlDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaConversionRequest model) {
            this.status(model.status);
            this.requestIdentifier(model.requestIdentifier);
            this.migrationProjectArn(model.migrationProjectArn);
            this.error(model.error);
            this.exportSqlDetails(model.exportSqlDetails);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getRequestIdentifier() {
            return this.requestIdentifier;
        }

        public final void setRequestIdentifier(String requestIdentifier) {
            this.requestIdentifier = requestIdentifier;
        }

        @Override
        public final Builder requestIdentifier(String requestIdentifier) {
            this.requestIdentifier = requestIdentifier;
            return this;
        }

        public final String getMigrationProjectArn() {
            return this.migrationProjectArn;
        }

        public final void setMigrationProjectArn(String migrationProjectArn) {
            this.migrationProjectArn = migrationProjectArn;
        }

        @Override
        public final Builder migrationProjectArn(String migrationProjectArn) {
            this.migrationProjectArn = migrationProjectArn;
            return this;
        }

        public final ErrorDetails.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ErrorDetails.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetails error) {
            this.error = error;
            return this;
        }

        public final ExportSqlDetails.Builder getExportSqlDetails() {
            return this.exportSqlDetails != null ? this.exportSqlDetails.toBuilder() : null;
        }

        public final void setExportSqlDetails(ExportSqlDetails.BuilderImpl exportSqlDetails) {
            this.exportSqlDetails = exportSqlDetails != null ? exportSqlDetails.build() : null;
        }

        @Override
        public final Builder exportSqlDetails(ExportSqlDetails exportSqlDetails) {
            this.exportSqlDetails = exportSqlDetails;
            return this;
        }

        public SchemaConversionRequest build() {
            return new SchemaConversionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SchemaConversionRequest> {
        public Builder status(String var1);

        public Builder requestIdentifier(String var1);

        public Builder migrationProjectArn(String var1);

        public Builder error(ErrorDetails var1);

        default public Builder error(Consumer<ErrorDetails.Builder> error) {
            return this.error((ErrorDetails)((ErrorDetails.Builder)ErrorDetails.builder().applyMutation(error)).build());
        }

        public Builder exportSqlDetails(ExportSqlDetails var1);

        default public Builder exportSqlDetails(Consumer<ExportSqlDetails.Builder> exportSqlDetails) {
            return this.exportSqlDetails((ExportSqlDetails)((ExportSqlDetails.Builder)ExportSqlDetails.builder().applyMutation(exportSqlDetails)).build());
        }
    }
}

