/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.Replication;
import software.amazon.awssdk.services.databasemigration.model.ReplicationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReplicationsResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeReplicationsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeReplicationsResponse.getter(DescribeReplicationsResponse::marker)).setter(DescribeReplicationsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<Replication>> REPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Replications").getter(DescribeReplicationsResponse.getter(DescribeReplicationsResponse::replications)).setter(DescribeReplicationsResponse.setter(Builder::replications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Replications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Replication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, REPLICATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeReplicationsResponse.memberNameToFieldInitializer();
    private final String marker;
    private final List<Replication> replications;

    private DescribeReplicationsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.replications = builder.replications;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasReplications() {
        return this.replications != null && !(this.replications instanceof SdkAutoConstructList);
    }

    public final List<Replication> replications() {
        return this.replications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplications() ? this.replications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationsResponse)) {
            return false;
        }
        DescribeReplicationsResponse other = (DescribeReplicationsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasReplications() == other.hasReplications() && Objects.equals(this.replications(), other.replications());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReplicationsResponse").add("Marker", (Object)this.marker()).add("Replications", this.hasReplications() ? this.replications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "Replications": {
                return Optional.ofNullable(clazz.cast(this.replications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Marker", MARKER_FIELD);
        map.put("Replications", REPLICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicationsResponse, T> g) {
        return obj -> g.apply((DescribeReplicationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<Replication> replications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationsResponse model) {
            super(model);
            this.marker(model.marker);
            this.replications(model.replications);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<Replication.Builder> getReplications() {
            List<Replication.Builder> result = ReplicationListCopier.copyToBuilder(this.replications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplications(Collection<Replication.BuilderImpl> replications) {
            this.replications = ReplicationListCopier.copyFromBuilder(replications);
        }

        @Override
        public final Builder replications(Collection<Replication> replications) {
            this.replications = ReplicationListCopier.copy(replications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replications(Replication ... replications) {
            this.replications(Arrays.asList(replications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replications(Consumer<Replication.Builder> ... replications) {
            this.replications(Stream.of(replications).map(c -> (Replication)((Replication.Builder)Replication.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeReplicationsResponse build() {
            return new DescribeReplicationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReplicationsResponse> {
        public Builder marker(String var1);

        public Builder replications(Collection<Replication> var1);

        public Builder replications(Replication ... var1);

        public Builder replications(Consumer<Replication.Builder> ... var1);
    }
}

