/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentRunProgress;
import software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentRunResultStatistic;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PremigrationAssessmentStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PremigrationAssessmentStatus> {
    private static final SdkField<String> PREMIGRATION_ASSESSMENT_RUN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PremigrationAssessmentRunArn").getter(PremigrationAssessmentStatus.getter(PremigrationAssessmentStatus::premigrationAssessmentRunArn)).setter(PremigrationAssessmentStatus.setter(Builder::premigrationAssessmentRunArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PremigrationAssessmentRunArn").build()}).build();
    private static final SdkField<Boolean> FAIL_ON_ASSESSMENT_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("FailOnAssessmentFailure").getter(PremigrationAssessmentStatus.getter(PremigrationAssessmentStatus::failOnAssessmentFailure)).setter(PremigrationAssessmentStatus.setter(Builder::failOnAssessmentFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailOnAssessmentFailure").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(PremigrationAssessmentStatus.getter(PremigrationAssessmentStatus::status)).setter(PremigrationAssessmentStatus.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> PREMIGRATION_ASSESSMENT_RUN_CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("PremigrationAssessmentRunCreationDate").getter(PremigrationAssessmentStatus.getter(PremigrationAssessmentStatus::premigrationAssessmentRunCreationDate)).setter(PremigrationAssessmentStatus.setter(Builder::premigrationAssessmentRunCreationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PremigrationAssessmentRunCreationDate").build()}).build();
    private static final SdkField<ReplicationTaskAssessmentRunProgress> ASSESSMENT_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AssessmentProgress").getter(PremigrationAssessmentStatus.getter(PremigrationAssessmentStatus::assessmentProgress)).setter(PremigrationAssessmentStatus.setter(Builder::assessmentProgress)).constructor(ReplicationTaskAssessmentRunProgress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssessmentProgress").build()}).build();
    private static final SdkField<String> LAST_FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastFailureMessage").getter(PremigrationAssessmentStatus.getter(PremigrationAssessmentStatus::lastFailureMessage)).setter(PremigrationAssessmentStatus.setter(Builder::lastFailureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastFailureMessage").build()}).build();
    private static final SdkField<String> RESULT_LOCATION_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResultLocationBucket").getter(PremigrationAssessmentStatus.getter(PremigrationAssessmentStatus::resultLocationBucket)).setter(PremigrationAssessmentStatus.setter(Builder::resultLocationBucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultLocationBucket").build()}).build();
    private static final SdkField<String> RESULT_LOCATION_FOLDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResultLocationFolder").getter(PremigrationAssessmentStatus.getter(PremigrationAssessmentStatus::resultLocationFolder)).setter(PremigrationAssessmentStatus.setter(Builder::resultLocationFolder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultLocationFolder").build()}).build();
    private static final SdkField<String> RESULT_ENCRYPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResultEncryptionMode").getter(PremigrationAssessmentStatus.getter(PremigrationAssessmentStatus::resultEncryptionMode)).setter(PremigrationAssessmentStatus.setter(Builder::resultEncryptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultEncryptionMode").build()}).build();
    private static final SdkField<String> RESULT_KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResultKmsKeyArn").getter(PremigrationAssessmentStatus.getter(PremigrationAssessmentStatus::resultKmsKeyArn)).setter(PremigrationAssessmentStatus.setter(Builder::resultKmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultKmsKeyArn").build()}).build();
    private static final SdkField<ReplicationTaskAssessmentRunResultStatistic> RESULT_STATISTIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResultStatistic").getter(PremigrationAssessmentStatus.getter(PremigrationAssessmentStatus::resultStatistic)).setter(PremigrationAssessmentStatus.setter(Builder::resultStatistic)).constructor(ReplicationTaskAssessmentRunResultStatistic::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultStatistic").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREMIGRATION_ASSESSMENT_RUN_ARN_FIELD, FAIL_ON_ASSESSMENT_FAILURE_FIELD, STATUS_FIELD, PREMIGRATION_ASSESSMENT_RUN_CREATION_DATE_FIELD, ASSESSMENT_PROGRESS_FIELD, LAST_FAILURE_MESSAGE_FIELD, RESULT_LOCATION_BUCKET_FIELD, RESULT_LOCATION_FOLDER_FIELD, RESULT_ENCRYPTION_MODE_FIELD, RESULT_KMS_KEY_ARN_FIELD, RESULT_STATISTIC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PremigrationAssessmentStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String premigrationAssessmentRunArn;
    private final Boolean failOnAssessmentFailure;
    private final String status;
    private final Instant premigrationAssessmentRunCreationDate;
    private final ReplicationTaskAssessmentRunProgress assessmentProgress;
    private final String lastFailureMessage;
    private final String resultLocationBucket;
    private final String resultLocationFolder;
    private final String resultEncryptionMode;
    private final String resultKmsKeyArn;
    private final ReplicationTaskAssessmentRunResultStatistic resultStatistic;

    private PremigrationAssessmentStatus(BuilderImpl builder) {
        this.premigrationAssessmentRunArn = builder.premigrationAssessmentRunArn;
        this.failOnAssessmentFailure = builder.failOnAssessmentFailure;
        this.status = builder.status;
        this.premigrationAssessmentRunCreationDate = builder.premigrationAssessmentRunCreationDate;
        this.assessmentProgress = builder.assessmentProgress;
        this.lastFailureMessage = builder.lastFailureMessage;
        this.resultLocationBucket = builder.resultLocationBucket;
        this.resultLocationFolder = builder.resultLocationFolder;
        this.resultEncryptionMode = builder.resultEncryptionMode;
        this.resultKmsKeyArn = builder.resultKmsKeyArn;
        this.resultStatistic = builder.resultStatistic;
    }

    public final String premigrationAssessmentRunArn() {
        return this.premigrationAssessmentRunArn;
    }

    public final Boolean failOnAssessmentFailure() {
        return this.failOnAssessmentFailure;
    }

    public final String status() {
        return this.status;
    }

    public final Instant premigrationAssessmentRunCreationDate() {
        return this.premigrationAssessmentRunCreationDate;
    }

    public final ReplicationTaskAssessmentRunProgress assessmentProgress() {
        return this.assessmentProgress;
    }

    public final String lastFailureMessage() {
        return this.lastFailureMessage;
    }

    public final String resultLocationBucket() {
        return this.resultLocationBucket;
    }

    public final String resultLocationFolder() {
        return this.resultLocationFolder;
    }

    public final String resultEncryptionMode() {
        return this.resultEncryptionMode;
    }

    public final String resultKmsKeyArn() {
        return this.resultKmsKeyArn;
    }

    public final ReplicationTaskAssessmentRunResultStatistic resultStatistic() {
        return this.resultStatistic;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.premigrationAssessmentRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.failOnAssessmentFailure());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.premigrationAssessmentRunCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastFailureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultLocationBucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultLocationFolder());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultEncryptionMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultKmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultStatistic());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PremigrationAssessmentStatus)) {
            return false;
        }
        PremigrationAssessmentStatus other = (PremigrationAssessmentStatus)obj;
        return Objects.equals(this.premigrationAssessmentRunArn(), other.premigrationAssessmentRunArn()) && Objects.equals(this.failOnAssessmentFailure(), other.failOnAssessmentFailure()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.premigrationAssessmentRunCreationDate(), other.premigrationAssessmentRunCreationDate()) && Objects.equals(this.assessmentProgress(), other.assessmentProgress()) && Objects.equals(this.lastFailureMessage(), other.lastFailureMessage()) && Objects.equals(this.resultLocationBucket(), other.resultLocationBucket()) && Objects.equals(this.resultLocationFolder(), other.resultLocationFolder()) && Objects.equals(this.resultEncryptionMode(), other.resultEncryptionMode()) && Objects.equals(this.resultKmsKeyArn(), other.resultKmsKeyArn()) && Objects.equals(this.resultStatistic(), other.resultStatistic());
    }

    public final String toString() {
        return ToString.builder((String)"PremigrationAssessmentStatus").add("PremigrationAssessmentRunArn", (Object)this.premigrationAssessmentRunArn()).add("FailOnAssessmentFailure", (Object)this.failOnAssessmentFailure()).add("Status", (Object)this.status()).add("PremigrationAssessmentRunCreationDate", (Object)this.premigrationAssessmentRunCreationDate()).add("AssessmentProgress", (Object)this.assessmentProgress()).add("LastFailureMessage", (Object)this.lastFailureMessage()).add("ResultLocationBucket", (Object)this.resultLocationBucket()).add("ResultLocationFolder", (Object)this.resultLocationFolder()).add("ResultEncryptionMode", (Object)this.resultEncryptionMode()).add("ResultKmsKeyArn", (Object)this.resultKmsKeyArn()).add("ResultStatistic", (Object)this.resultStatistic()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PremigrationAssessmentRunArn": {
                return Optional.ofNullable(clazz.cast(this.premigrationAssessmentRunArn()));
            }
            case "FailOnAssessmentFailure": {
                return Optional.ofNullable(clazz.cast(this.failOnAssessmentFailure()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "PremigrationAssessmentRunCreationDate": {
                return Optional.ofNullable(clazz.cast(this.premigrationAssessmentRunCreationDate()));
            }
            case "AssessmentProgress": {
                return Optional.ofNullable(clazz.cast(this.assessmentProgress()));
            }
            case "LastFailureMessage": {
                return Optional.ofNullable(clazz.cast(this.lastFailureMessage()));
            }
            case "ResultLocationBucket": {
                return Optional.ofNullable(clazz.cast(this.resultLocationBucket()));
            }
            case "ResultLocationFolder": {
                return Optional.ofNullable(clazz.cast(this.resultLocationFolder()));
            }
            case "ResultEncryptionMode": {
                return Optional.ofNullable(clazz.cast(this.resultEncryptionMode()));
            }
            case "ResultKmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.resultKmsKeyArn()));
            }
            case "ResultStatistic": {
                return Optional.ofNullable(clazz.cast(this.resultStatistic()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PremigrationAssessmentRunArn", PREMIGRATION_ASSESSMENT_RUN_ARN_FIELD);
        map.put("FailOnAssessmentFailure", FAIL_ON_ASSESSMENT_FAILURE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("PremigrationAssessmentRunCreationDate", PREMIGRATION_ASSESSMENT_RUN_CREATION_DATE_FIELD);
        map.put("AssessmentProgress", ASSESSMENT_PROGRESS_FIELD);
        map.put("LastFailureMessage", LAST_FAILURE_MESSAGE_FIELD);
        map.put("ResultLocationBucket", RESULT_LOCATION_BUCKET_FIELD);
        map.put("ResultLocationFolder", RESULT_LOCATION_FOLDER_FIELD);
        map.put("ResultEncryptionMode", RESULT_ENCRYPTION_MODE_FIELD);
        map.put("ResultKmsKeyArn", RESULT_KMS_KEY_ARN_FIELD);
        map.put("ResultStatistic", RESULT_STATISTIC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PremigrationAssessmentStatus, T> g) {
        return obj -> g.apply((PremigrationAssessmentStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String premigrationAssessmentRunArn;
        private Boolean failOnAssessmentFailure;
        private String status;
        private Instant premigrationAssessmentRunCreationDate;
        private ReplicationTaskAssessmentRunProgress assessmentProgress;
        private String lastFailureMessage;
        private String resultLocationBucket;
        private String resultLocationFolder;
        private String resultEncryptionMode;
        private String resultKmsKeyArn;
        private ReplicationTaskAssessmentRunResultStatistic resultStatistic;

        private BuilderImpl() {
        }

        private BuilderImpl(PremigrationAssessmentStatus model) {
            this.premigrationAssessmentRunArn(model.premigrationAssessmentRunArn);
            this.failOnAssessmentFailure(model.failOnAssessmentFailure);
            this.status(model.status);
            this.premigrationAssessmentRunCreationDate(model.premigrationAssessmentRunCreationDate);
            this.assessmentProgress(model.assessmentProgress);
            this.lastFailureMessage(model.lastFailureMessage);
            this.resultLocationBucket(model.resultLocationBucket);
            this.resultLocationFolder(model.resultLocationFolder);
            this.resultEncryptionMode(model.resultEncryptionMode);
            this.resultKmsKeyArn(model.resultKmsKeyArn);
            this.resultStatistic(model.resultStatistic);
        }

        public final String getPremigrationAssessmentRunArn() {
            return this.premigrationAssessmentRunArn;
        }

        public final void setPremigrationAssessmentRunArn(String premigrationAssessmentRunArn) {
            this.premigrationAssessmentRunArn = premigrationAssessmentRunArn;
        }

        @Override
        public final Builder premigrationAssessmentRunArn(String premigrationAssessmentRunArn) {
            this.premigrationAssessmentRunArn = premigrationAssessmentRunArn;
            return this;
        }

        public final Boolean getFailOnAssessmentFailure() {
            return this.failOnAssessmentFailure;
        }

        public final void setFailOnAssessmentFailure(Boolean failOnAssessmentFailure) {
            this.failOnAssessmentFailure = failOnAssessmentFailure;
        }

        @Override
        public final Builder failOnAssessmentFailure(Boolean failOnAssessmentFailure) {
            this.failOnAssessmentFailure = failOnAssessmentFailure;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getPremigrationAssessmentRunCreationDate() {
            return this.premigrationAssessmentRunCreationDate;
        }

        public final void setPremigrationAssessmentRunCreationDate(Instant premigrationAssessmentRunCreationDate) {
            this.premigrationAssessmentRunCreationDate = premigrationAssessmentRunCreationDate;
        }

        @Override
        public final Builder premigrationAssessmentRunCreationDate(Instant premigrationAssessmentRunCreationDate) {
            this.premigrationAssessmentRunCreationDate = premigrationAssessmentRunCreationDate;
            return this;
        }

        public final ReplicationTaskAssessmentRunProgress.Builder getAssessmentProgress() {
            return this.assessmentProgress != null ? this.assessmentProgress.toBuilder() : null;
        }

        public final void setAssessmentProgress(ReplicationTaskAssessmentRunProgress.BuilderImpl assessmentProgress) {
            this.assessmentProgress = assessmentProgress != null ? assessmentProgress.build() : null;
        }

        @Override
        public final Builder assessmentProgress(ReplicationTaskAssessmentRunProgress assessmentProgress) {
            this.assessmentProgress = assessmentProgress;
            return this;
        }

        public final String getLastFailureMessage() {
            return this.lastFailureMessage;
        }

        public final void setLastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
        }

        @Override
        public final Builder lastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
            return this;
        }

        public final String getResultLocationBucket() {
            return this.resultLocationBucket;
        }

        public final void setResultLocationBucket(String resultLocationBucket) {
            this.resultLocationBucket = resultLocationBucket;
        }

        @Override
        public final Builder resultLocationBucket(String resultLocationBucket) {
            this.resultLocationBucket = resultLocationBucket;
            return this;
        }

        public final String getResultLocationFolder() {
            return this.resultLocationFolder;
        }

        public final void setResultLocationFolder(String resultLocationFolder) {
            this.resultLocationFolder = resultLocationFolder;
        }

        @Override
        public final Builder resultLocationFolder(String resultLocationFolder) {
            this.resultLocationFolder = resultLocationFolder;
            return this;
        }

        public final String getResultEncryptionMode() {
            return this.resultEncryptionMode;
        }

        public final void setResultEncryptionMode(String resultEncryptionMode) {
            this.resultEncryptionMode = resultEncryptionMode;
        }

        @Override
        public final Builder resultEncryptionMode(String resultEncryptionMode) {
            this.resultEncryptionMode = resultEncryptionMode;
            return this;
        }

        public final String getResultKmsKeyArn() {
            return this.resultKmsKeyArn;
        }

        public final void setResultKmsKeyArn(String resultKmsKeyArn) {
            this.resultKmsKeyArn = resultKmsKeyArn;
        }

        @Override
        public final Builder resultKmsKeyArn(String resultKmsKeyArn) {
            this.resultKmsKeyArn = resultKmsKeyArn;
            return this;
        }

        public final ReplicationTaskAssessmentRunResultStatistic.Builder getResultStatistic() {
            return this.resultStatistic != null ? this.resultStatistic.toBuilder() : null;
        }

        public final void setResultStatistic(ReplicationTaskAssessmentRunResultStatistic.BuilderImpl resultStatistic) {
            this.resultStatistic = resultStatistic != null ? resultStatistic.build() : null;
        }

        @Override
        public final Builder resultStatistic(ReplicationTaskAssessmentRunResultStatistic resultStatistic) {
            this.resultStatistic = resultStatistic;
            return this;
        }

        public PremigrationAssessmentStatus build() {
            return new PremigrationAssessmentStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PremigrationAssessmentStatus> {
        public Builder premigrationAssessmentRunArn(String var1);

        public Builder failOnAssessmentFailure(Boolean var1);

        public Builder status(String var1);

        public Builder premigrationAssessmentRunCreationDate(Instant var1);

        public Builder assessmentProgress(ReplicationTaskAssessmentRunProgress var1);

        default public Builder assessmentProgress(Consumer<ReplicationTaskAssessmentRunProgress.Builder> assessmentProgress) {
            return this.assessmentProgress((ReplicationTaskAssessmentRunProgress)((ReplicationTaskAssessmentRunProgress.Builder)ReplicationTaskAssessmentRunProgress.builder().applyMutation(assessmentProgress)).build());
        }

        public Builder lastFailureMessage(String var1);

        public Builder resultLocationBucket(String var1);

        public Builder resultLocationFolder(String var1);

        public Builder resultEncryptionMode(String var1);

        public Builder resultKmsKeyArn(String var1);

        public Builder resultStatistic(ReplicationTaskAssessmentRunResultStatistic var1);

        default public Builder resultStatistic(Consumer<ReplicationTaskAssessmentRunResultStatistic.Builder> resultStatistic) {
            return this.resultStatistic((ReplicationTaskAssessmentRunResultStatistic)((ReplicationTaskAssessmentRunResultStatistic.Builder)ReplicationTaskAssessmentRunResultStatistic.builder().applyMutation(resultStatistic)).build());
        }
    }
}

