/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.DmsSslModeValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OracleDataProviderSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OracleDataProviderSettings> {
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerName").getter(OracleDataProviderSettings.getter(OracleDataProviderSettings::serverName)).setter(OracleDataProviderSettings.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(OracleDataProviderSettings.getter(OracleDataProviderSettings::port)).setter(OracleDataProviderSettings.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(OracleDataProviderSettings.getter(OracleDataProviderSettings::databaseName)).setter(OracleDataProviderSettings.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> SSL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SslMode").getter(OracleDataProviderSettings.getter(OracleDataProviderSettings::sslModeAsString)).setter(OracleDataProviderSettings.setter(Builder::sslMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslMode").build()}).build();
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateArn").getter(OracleDataProviderSettings.getter(OracleDataProviderSettings::certificateArn)).setter(OracleDataProviderSettings.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").build()}).build();
    private static final SdkField<String> ASM_SERVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AsmServer").getter(OracleDataProviderSettings.getter(OracleDataProviderSettings::asmServer)).setter(OracleDataProviderSettings.setter(Builder::asmServer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsmServer").build()}).build();
    private static final SdkField<String> SECRETS_MANAGER_ORACLE_ASM_SECRET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretsManagerOracleAsmSecretId").getter(OracleDataProviderSettings.getter(OracleDataProviderSettings::secretsManagerOracleAsmSecretId)).setter(OracleDataProviderSettings.setter(Builder::secretsManagerOracleAsmSecretId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerOracleAsmSecretId").build()}).build();
    private static final SdkField<String> SECRETS_MANAGER_ORACLE_ASM_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretsManagerOracleAsmAccessRoleArn").getter(OracleDataProviderSettings.getter(OracleDataProviderSettings::secretsManagerOracleAsmAccessRoleArn)).setter(OracleDataProviderSettings.setter(Builder::secretsManagerOracleAsmAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerOracleAsmAccessRoleArn").build()}).build();
    private static final SdkField<String> SECRETS_MANAGER_SECURITY_DB_ENCRYPTION_SECRET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretsManagerSecurityDbEncryptionSecretId").getter(OracleDataProviderSettings.getter(OracleDataProviderSettings::secretsManagerSecurityDbEncryptionSecretId)).setter(OracleDataProviderSettings.setter(Builder::secretsManagerSecurityDbEncryptionSecretId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerSecurityDbEncryptionSecretId").build()}).build();
    private static final SdkField<String> SECRETS_MANAGER_SECURITY_DB_ENCRYPTION_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretsManagerSecurityDbEncryptionAccessRoleArn").getter(OracleDataProviderSettings.getter(OracleDataProviderSettings::secretsManagerSecurityDbEncryptionAccessRoleArn)).setter(OracleDataProviderSettings.setter(Builder::secretsManagerSecurityDbEncryptionAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerSecurityDbEncryptionAccessRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_NAME_FIELD, PORT_FIELD, DATABASE_NAME_FIELD, SSL_MODE_FIELD, CERTIFICATE_ARN_FIELD, ASM_SERVER_FIELD, SECRETS_MANAGER_ORACLE_ASM_SECRET_ID_FIELD, SECRETS_MANAGER_ORACLE_ASM_ACCESS_ROLE_ARN_FIELD, SECRETS_MANAGER_SECURITY_DB_ENCRYPTION_SECRET_ID_FIELD, SECRETS_MANAGER_SECURITY_DB_ENCRYPTION_ACCESS_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OracleDataProviderSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serverName;
    private final Integer port;
    private final String databaseName;
    private final String sslMode;
    private final String certificateArn;
    private final String asmServer;
    private final String secretsManagerOracleAsmSecretId;
    private final String secretsManagerOracleAsmAccessRoleArn;
    private final String secretsManagerSecurityDbEncryptionSecretId;
    private final String secretsManagerSecurityDbEncryptionAccessRoleArn;

    private OracleDataProviderSettings(BuilderImpl builder) {
        this.serverName = builder.serverName;
        this.port = builder.port;
        this.databaseName = builder.databaseName;
        this.sslMode = builder.sslMode;
        this.certificateArn = builder.certificateArn;
        this.asmServer = builder.asmServer;
        this.secretsManagerOracleAsmSecretId = builder.secretsManagerOracleAsmSecretId;
        this.secretsManagerOracleAsmAccessRoleArn = builder.secretsManagerOracleAsmAccessRoleArn;
        this.secretsManagerSecurityDbEncryptionSecretId = builder.secretsManagerSecurityDbEncryptionSecretId;
        this.secretsManagerSecurityDbEncryptionAccessRoleArn = builder.secretsManagerSecurityDbEncryptionAccessRoleArn;
    }

    public final String serverName() {
        return this.serverName;
    }

    public final Integer port() {
        return this.port;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final DmsSslModeValue sslMode() {
        return DmsSslModeValue.fromValue(this.sslMode);
    }

    public final String sslModeAsString() {
        return this.sslMode;
    }

    public final String certificateArn() {
        return this.certificateArn;
    }

    public final String asmServer() {
        return this.asmServer;
    }

    public final String secretsManagerOracleAsmSecretId() {
        return this.secretsManagerOracleAsmSecretId;
    }

    public final String secretsManagerOracleAsmAccessRoleArn() {
        return this.secretsManagerOracleAsmAccessRoleArn;
    }

    public final String secretsManagerSecurityDbEncryptionSecretId() {
        return this.secretsManagerSecurityDbEncryptionSecretId;
    }

    public final String secretsManagerSecurityDbEncryptionAccessRoleArn() {
        return this.secretsManagerSecurityDbEncryptionAccessRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.asmServer());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerOracleAsmSecretId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerOracleAsmAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerSecurityDbEncryptionSecretId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerSecurityDbEncryptionAccessRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OracleDataProviderSettings)) {
            return false;
        }
        OracleDataProviderSettings other = (OracleDataProviderSettings)obj;
        return Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.sslModeAsString(), other.sslModeAsString()) && Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.asmServer(), other.asmServer()) && Objects.equals(this.secretsManagerOracleAsmSecretId(), other.secretsManagerOracleAsmSecretId()) && Objects.equals(this.secretsManagerOracleAsmAccessRoleArn(), other.secretsManagerOracleAsmAccessRoleArn()) && Objects.equals(this.secretsManagerSecurityDbEncryptionSecretId(), other.secretsManagerSecurityDbEncryptionSecretId()) && Objects.equals(this.secretsManagerSecurityDbEncryptionAccessRoleArn(), other.secretsManagerSecurityDbEncryptionAccessRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"OracleDataProviderSettings").add("ServerName", (Object)this.serverName()).add("Port", (Object)this.port()).add("DatabaseName", (Object)this.databaseName()).add("SslMode", (Object)this.sslModeAsString()).add("CertificateArn", (Object)this.certificateArn()).add("AsmServer", (Object)this.asmServer()).add("SecretsManagerOracleAsmSecretId", (Object)this.secretsManagerOracleAsmSecretId()).add("SecretsManagerOracleAsmAccessRoleArn", (Object)this.secretsManagerOracleAsmAccessRoleArn()).add("SecretsManagerSecurityDbEncryptionSecretId", (Object)this.secretsManagerSecurityDbEncryptionSecretId()).add("SecretsManagerSecurityDbEncryptionAccessRoleArn", (Object)this.secretsManagerSecurityDbEncryptionAccessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "SslMode": {
                return Optional.ofNullable(clazz.cast(this.sslModeAsString()));
            }
            case "CertificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "AsmServer": {
                return Optional.ofNullable(clazz.cast(this.asmServer()));
            }
            case "SecretsManagerOracleAsmSecretId": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerOracleAsmSecretId()));
            }
            case "SecretsManagerOracleAsmAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerOracleAsmAccessRoleArn()));
            }
            case "SecretsManagerSecurityDbEncryptionSecretId": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerSecurityDbEncryptionSecretId()));
            }
            case "SecretsManagerSecurityDbEncryptionAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerSecurityDbEncryptionAccessRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServerName", SERVER_NAME_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("SslMode", SSL_MODE_FIELD);
        map.put("CertificateArn", CERTIFICATE_ARN_FIELD);
        map.put("AsmServer", ASM_SERVER_FIELD);
        map.put("SecretsManagerOracleAsmSecretId", SECRETS_MANAGER_ORACLE_ASM_SECRET_ID_FIELD);
        map.put("SecretsManagerOracleAsmAccessRoleArn", SECRETS_MANAGER_ORACLE_ASM_ACCESS_ROLE_ARN_FIELD);
        map.put("SecretsManagerSecurityDbEncryptionSecretId", SECRETS_MANAGER_SECURITY_DB_ENCRYPTION_SECRET_ID_FIELD);
        map.put("SecretsManagerSecurityDbEncryptionAccessRoleArn", SECRETS_MANAGER_SECURITY_DB_ENCRYPTION_ACCESS_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OracleDataProviderSettings, T> g) {
        return obj -> g.apply((OracleDataProviderSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serverName;
        private Integer port;
        private String databaseName;
        private String sslMode;
        private String certificateArn;
        private String asmServer;
        private String secretsManagerOracleAsmSecretId;
        private String secretsManagerOracleAsmAccessRoleArn;
        private String secretsManagerSecurityDbEncryptionSecretId;
        private String secretsManagerSecurityDbEncryptionAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(OracleDataProviderSettings model) {
            this.serverName(model.serverName);
            this.port(model.port);
            this.databaseName(model.databaseName);
            this.sslMode(model.sslMode);
            this.certificateArn(model.certificateArn);
            this.asmServer(model.asmServer);
            this.secretsManagerOracleAsmSecretId(model.secretsManagerOracleAsmSecretId);
            this.secretsManagerOracleAsmAccessRoleArn(model.secretsManagerOracleAsmAccessRoleArn);
            this.secretsManagerSecurityDbEncryptionSecretId(model.secretsManagerSecurityDbEncryptionSecretId);
            this.secretsManagerSecurityDbEncryptionAccessRoleArn(model.secretsManagerSecurityDbEncryptionAccessRoleArn);
        }

        public final String getServerName() {
            return this.serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getSslMode() {
            return this.sslMode;
        }

        public final void setSslMode(String sslMode) {
            this.sslMode = sslMode;
        }

        @Override
        public final Builder sslMode(String sslMode) {
            this.sslMode = sslMode;
            return this;
        }

        @Override
        public final Builder sslMode(DmsSslModeValue sslMode) {
            this.sslMode(sslMode == null ? null : sslMode.toString());
            return this;
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getAsmServer() {
            return this.asmServer;
        }

        public final void setAsmServer(String asmServer) {
            this.asmServer = asmServer;
        }

        @Override
        public final Builder asmServer(String asmServer) {
            this.asmServer = asmServer;
            return this;
        }

        public final String getSecretsManagerOracleAsmSecretId() {
            return this.secretsManagerOracleAsmSecretId;
        }

        public final void setSecretsManagerOracleAsmSecretId(String secretsManagerOracleAsmSecretId) {
            this.secretsManagerOracleAsmSecretId = secretsManagerOracleAsmSecretId;
        }

        @Override
        public final Builder secretsManagerOracleAsmSecretId(String secretsManagerOracleAsmSecretId) {
            this.secretsManagerOracleAsmSecretId = secretsManagerOracleAsmSecretId;
            return this;
        }

        public final String getSecretsManagerOracleAsmAccessRoleArn() {
            return this.secretsManagerOracleAsmAccessRoleArn;
        }

        public final void setSecretsManagerOracleAsmAccessRoleArn(String secretsManagerOracleAsmAccessRoleArn) {
            this.secretsManagerOracleAsmAccessRoleArn = secretsManagerOracleAsmAccessRoleArn;
        }

        @Override
        public final Builder secretsManagerOracleAsmAccessRoleArn(String secretsManagerOracleAsmAccessRoleArn) {
            this.secretsManagerOracleAsmAccessRoleArn = secretsManagerOracleAsmAccessRoleArn;
            return this;
        }

        public final String getSecretsManagerSecurityDbEncryptionSecretId() {
            return this.secretsManagerSecurityDbEncryptionSecretId;
        }

        public final void setSecretsManagerSecurityDbEncryptionSecretId(String secretsManagerSecurityDbEncryptionSecretId) {
            this.secretsManagerSecurityDbEncryptionSecretId = secretsManagerSecurityDbEncryptionSecretId;
        }

        @Override
        public final Builder secretsManagerSecurityDbEncryptionSecretId(String secretsManagerSecurityDbEncryptionSecretId) {
            this.secretsManagerSecurityDbEncryptionSecretId = secretsManagerSecurityDbEncryptionSecretId;
            return this;
        }

        public final String getSecretsManagerSecurityDbEncryptionAccessRoleArn() {
            return this.secretsManagerSecurityDbEncryptionAccessRoleArn;
        }

        public final void setSecretsManagerSecurityDbEncryptionAccessRoleArn(String secretsManagerSecurityDbEncryptionAccessRoleArn) {
            this.secretsManagerSecurityDbEncryptionAccessRoleArn = secretsManagerSecurityDbEncryptionAccessRoleArn;
        }

        @Override
        public final Builder secretsManagerSecurityDbEncryptionAccessRoleArn(String secretsManagerSecurityDbEncryptionAccessRoleArn) {
            this.secretsManagerSecurityDbEncryptionAccessRoleArn = secretsManagerSecurityDbEncryptionAccessRoleArn;
            return this;
        }

        public OracleDataProviderSettings build() {
            return new OracleDataProviderSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OracleDataProviderSettings> {
        public Builder serverName(String var1);

        public Builder port(Integer var1);

        public Builder databaseName(String var1);

        public Builder sslMode(String var1);

        public Builder sslMode(DmsSslModeValue var1);

        public Builder certificateArn(String var1);

        public Builder asmServer(String var1);

        public Builder secretsManagerOracleAsmSecretId(String var1);

        public Builder secretsManagerOracleAsmAccessRoleArn(String var1);

        public Builder secretsManagerSecurityDbEncryptionSecretId(String var1);

        public Builder secretsManagerSecurityDbEncryptionAccessRoleArn(String var1);
    }
}

