/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersResponse;

public class DescribeDataProvidersPublisher
implements SdkPublisher<DescribeDataProvidersResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeDataProvidersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDataProvidersPublisher(DatabaseMigrationAsyncClient client, DescribeDataProvidersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDataProvidersPublisher(DatabaseMigrationAsyncClient client, DescribeDataProvidersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDataProvidersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDataProvidersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeDataProvidersResponseFetcher
    implements AsyncPageFetcher<DescribeDataProvidersResponse> {
        private DescribeDataProvidersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDataProvidersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeDataProvidersResponse> nextPage(DescribeDataProvidersResponse previousPage) {
            if (previousPage == null) {
                return DescribeDataProvidersPublisher.this.client.describeDataProviders(DescribeDataProvidersPublisher.this.firstRequest);
            }
            return DescribeDataProvidersPublisher.this.client.describeDataProviders((DescribeDataProvidersRequest)((Object)DescribeDataProvidersPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

