/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataProviderDescriptorDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataProviderDescriptorDefinition> {
    private static final SdkField<String> DATA_PROVIDER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataProviderIdentifier").getter(DataProviderDescriptorDefinition.getter(DataProviderDescriptorDefinition::dataProviderIdentifier)).setter(DataProviderDescriptorDefinition.setter(Builder::dataProviderIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProviderIdentifier").build()}).build();
    private static final SdkField<String> SECRETS_MANAGER_SECRET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretsManagerSecretId").getter(DataProviderDescriptorDefinition.getter(DataProviderDescriptorDefinition::secretsManagerSecretId)).setter(DataProviderDescriptorDefinition.setter(Builder::secretsManagerSecretId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerSecretId").build()}).build();
    private static final SdkField<String> SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretsManagerAccessRoleArn").getter(DataProviderDescriptorDefinition.getter(DataProviderDescriptorDefinition::secretsManagerAccessRoleArn)).setter(DataProviderDescriptorDefinition.setter(Builder::secretsManagerAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerAccessRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_PROVIDER_IDENTIFIER_FIELD, SECRETS_MANAGER_SECRET_ID_FIELD, SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataProviderDescriptorDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dataProviderIdentifier;
    private final String secretsManagerSecretId;
    private final String secretsManagerAccessRoleArn;

    private DataProviderDescriptorDefinition(BuilderImpl builder) {
        this.dataProviderIdentifier = builder.dataProviderIdentifier;
        this.secretsManagerSecretId = builder.secretsManagerSecretId;
        this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
    }

    public final String dataProviderIdentifier() {
        return this.dataProviderIdentifier;
    }

    public final String secretsManagerSecretId() {
        return this.secretsManagerSecretId;
    }

    public final String secretsManagerAccessRoleArn() {
        return this.secretsManagerAccessRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProviderIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerSecretId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerAccessRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProviderDescriptorDefinition)) {
            return false;
        }
        DataProviderDescriptorDefinition other = (DataProviderDescriptorDefinition)obj;
        return Objects.equals(this.dataProviderIdentifier(), other.dataProviderIdentifier()) && Objects.equals(this.secretsManagerSecretId(), other.secretsManagerSecretId()) && Objects.equals(this.secretsManagerAccessRoleArn(), other.secretsManagerAccessRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"DataProviderDescriptorDefinition").add("DataProviderIdentifier", (Object)this.dataProviderIdentifier()).add("SecretsManagerSecretId", (Object)this.secretsManagerSecretId()).add("SecretsManagerAccessRoleArn", (Object)this.secretsManagerAccessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataProviderIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dataProviderIdentifier()));
            }
            case "SecretsManagerSecretId": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerSecretId()));
            }
            case "SecretsManagerAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerAccessRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DataProviderIdentifier", DATA_PROVIDER_IDENTIFIER_FIELD);
        map.put("SecretsManagerSecretId", SECRETS_MANAGER_SECRET_ID_FIELD);
        map.put("SecretsManagerAccessRoleArn", SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataProviderDescriptorDefinition, T> g) {
        return obj -> g.apply((DataProviderDescriptorDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataProviderIdentifier;
        private String secretsManagerSecretId;
        private String secretsManagerAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProviderDescriptorDefinition model) {
            this.dataProviderIdentifier(model.dataProviderIdentifier);
            this.secretsManagerSecretId(model.secretsManagerSecretId);
            this.secretsManagerAccessRoleArn(model.secretsManagerAccessRoleArn);
        }

        public final String getDataProviderIdentifier() {
            return this.dataProviderIdentifier;
        }

        public final void setDataProviderIdentifier(String dataProviderIdentifier) {
            this.dataProviderIdentifier = dataProviderIdentifier;
        }

        @Override
        public final Builder dataProviderIdentifier(String dataProviderIdentifier) {
            this.dataProviderIdentifier = dataProviderIdentifier;
            return this;
        }

        public final String getSecretsManagerSecretId() {
            return this.secretsManagerSecretId;
        }

        public final void setSecretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
        }

        @Override
        public final Builder secretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
            return this;
        }

        public final String getSecretsManagerAccessRoleArn() {
            return this.secretsManagerAccessRoleArn;
        }

        public final void setSecretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
        }

        @Override
        public final Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
            return this;
        }

        public DataProviderDescriptorDefinition build() {
            return new DataProviderDescriptorDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataProviderDescriptorDefinition> {
        public Builder dataProviderIdentifier(String var1);

        public Builder secretsManagerSecretId(String var1);

        public Builder secretsManagerAccessRoleArn(String var1);
    }
}

